/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.JCaseStatement;
import com.android.jack.ir.ast.JIntegralConstant32;
import com.android.jack.ir.ast.JNumberLiteral;
import com.android.jack.ir.ast.JNumberValueLiteral;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JSwitchStatement;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.Number;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import javax.annotation.Nonnull;

@Description(value="Java byte literal expression")
public class JByteLiteral
extends JNumberValueLiteral
implements JIntegralConstant32,
JNumberLiteral {
    private final byte value;

    public JByteLiteral(@Nonnull SourceInfo sourceInfo, byte value) {
        super(sourceInfo);
        this.value = value;
    }

    @Override
    @Nonnull
    public JType getType() {
        return JPrimitiveType.JPrimitiveTypeEnum.BYTE.getType();
    }

    public byte getValue() {
        return this.value;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            // empty if block
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Override
    public int getIntValue() {
        return this.value;
    }

    @Override
    @Nonnull
    public Number getNumber() {
        return new Number(this.value);
    }

    @Override
    public void checkValidity() {
        if (!(this.parent instanceof JSwitchStatement) && !(this.parent instanceof JCaseStatement)) {
            super.checkValidity();
        }
    }

    @Override
    public boolean isTypeValue() {
        return this.value == 0;
    }
}

