/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JDefinedReferenceType;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JReferenceType;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.lookup.CommonTypes;
import com.android.jack.lookup.JPhantomLookup;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import javax.annotation.Nonnull;

@Description(value="Java array type")
public class JArrayType
extends JDefinedReferenceType {
    private int dims = 0;
    private JType elementType;
    private JType leafType = null;

    JArrayType(JType elementType) {
        super(SourceInfo.UNKNOWN, elementType.getName() + "[]");
        this.elementType = elementType;
        JPhantomLookup lookup = Jack.getSession().getPhantomLookup();
        this.addImplements(lookup.getInterface(CommonTypes.JAVA_IO_SERIALIZABLE));
        this.addImplements(lookup.getInterface(CommonTypes.JAVA_LANG_CLONEABLE));
        this.setSuperClass(lookup.getClass(CommonTypes.JAVA_LANG_OBJECT));
    }

    public int getDims() {
        int dims = this.dims;
        if (dims == 0) {
            dims = 1;
            if (this.elementType instanceof JArrayType) {
                dims += ((JArrayType)this.elementType).getDims();
            }
            this.dims = dims;
        }
        return dims;
    }

    public JType getElementType() {
        return this.elementType;
    }

    public void setElementType(@Nonnull JType elementType) {
        this.elementType = elementType;
    }

    public JType getLeafType() {
        if (this.leafType == null) {
            this.leafType = this.elementType instanceof JArrayType ? ((JArrayType)this.elementType).getLeafType() : this.elementType;
        }
        return this.leafType;
    }

    public void resetLeafType() {
        this.leafType = null;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            // empty if block
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Override
    public boolean canBeSafelyUpcast(@Nonnull JReferenceType castTo) {
        if (this.isTrivialCast(castTo) || castTo instanceof JInterface && this.implementsInterface((JInterface)castTo)) {
            return true;
        }
        if (castTo instanceof JArrayType) {
            JType castedToElementType = ((JArrayType)castTo).getElementType();
            if (this.elementType instanceof JReferenceType && castedToElementType instanceof JReferenceType) {
                return ((JReferenceType)this.elementType).canBeSafelyUpcast((JReferenceType)castedToElementType);
            }
        }
        return false;
    }

    @Override
    public final boolean isSameType(@Nonnull JType type) {
        if (type instanceof JArrayType) {
            return this.getDims() == ((JArrayType)type).getDims() && this.getLeafType().isSameType(((JArrayType)type).getLeafType());
        }
        return false;
    }

    @Override
    public void checkValidity() {
        throw new AssertionError();
    }
}

