/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import javax.annotation.Nonnull;

@Description(value="An allocation expression")
public class JAlloc
extends JExpression {
    @Nonnull
    private JClass instanceType;

    public JAlloc(JAlloc other) {
        super(other.getSourceInfo());
        this.instanceType = other.instanceType;
    }

    public JAlloc(@Nonnull SourceInfo info, @Nonnull JClass instanceType) {
        super(info);
        this.instanceType = instanceType;
    }

    @Override
    @Nonnull
    public JClass getType() {
        return this.instanceType;
    }

    @Nonnull
    public JClass getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(@Nonnull JClass instanceType) {
        this.instanceType = instanceType;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            // empty if block
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
    }

    @Override
    public boolean canThrow() {
        return true;
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }
}

