/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.frontend;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JDefinedInterface;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JPhantomClassOrInterface;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.lookup.CommonTypes;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Set of virtual methods visible in the marked type.")
@ValidOn(value={JDefinedClassOrInterface.class, JPhantomClassOrInterface.class})
public class VirtualMethodsMarker
implements Marker,
Iterable<JMethodIdWide>,
Cloneable {
    @Nonnull
    private HashMap<ComparableMethodId, ComparableMethodId> virtualMethods = new HashMap();

    @Nonnull
    public VirtualMethodsMarker clone() {
        try {
            VirtualMethodsMarker clone = (VirtualMethodsMarker)super.clone();
            clone.virtualMethods = (HashMap)this.virtualMethods.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    @Override
    @Nonnull
    public Marker cloneIfNeeded() {
        return this;
    }

    public void add(@Nonnull JMethodIdWide method) {
        ComparableMethodId comparable = new ComparableMethodId(method);
        this.virtualMethods.put(comparable, comparable);
    }

    @CheckForNull
    public JMethodIdWide get(@Nonnull JMethodIdWide method) {
        ComparableMethodId searched = new ComparableMethodId(method);
        ComparableMethodId found = this.virtualMethods.get(searched);
        if (found != null) {
            return found.methodId;
        }
        return null;
    }

    @Override
    @Nonnull
    public Iterator<JMethodIdWide> iterator() {
        return new Iterator<JMethodIdWide>(){
            @Nonnull
            private final Iterator<ComparableMethodId> iterator;
            {
                this.iterator = VirtualMethodsMarker.this.virtualMethods.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            @Nonnull
            public JMethodIdWide next() {
                return this.iterator.next().methodId;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static class ComparableMethodId {
        private final int hashCode;
        @Nonnull
        private final JMethodIdWide methodId;

        private ComparableMethodId(@Nonnull JMethodIdWide methodId) {
            this.methodId = methodId;
            int code = methodId.getName().hashCode();
            for (JType type : methodId.getParamTypes()) {
                code ^= type.hashCode();
            }
            this.hashCode = code;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(@CheckForNull Object obj) {
            int otherHashCode;
            ComparableMethodId other;
            if (obj == this) {
                return true;
            }
            try {
                other = (ComparableMethodId)obj;
                otherHashCode = other.hashCode;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
            if (this.hashCode != otherHashCode) {
                return false;
            }
            List<JType> thisParams = this.methodId.getParamTypes();
            List<JType> otherParams = other.methodId.getParamTypes();
            if (thisParams.size() != otherParams.size() || !this.methodId.getName().equals(other.methodId.getName())) {
                return false;
            }
            Iterator<JType> otherIterator = otherParams.iterator();
            for (JType thisParam : thisParams) {
                if (thisParam == otherIterator.next()) continue;
                return false;
            }
            return true;
        }
    }

    @Description(value="Removes VirtualMethodsMarker")
    @Transform(remove={VirtualMethodsMarker.class})
    @Constraint(need={VirtualMethodsMarker.class})
    public static class Remover
    implements RunnableSchedulable<JSession> {
        @Override
        public void run(@Nonnull JSession session) {
            new Visitor().accept(session.getTypesToEmit());
        }

        private static class Visitor
        extends JVisitor {
            @Nonnull
            private final JClass javaLangObject = Jack.getSession().getPhantomLookup().getClass(CommonTypes.JAVA_LANG_OBJECT);

            private Visitor() {
                super(false);
            }

            @Override
            public boolean visit(@Nonnull JDefinedClass definedClass) {
                if (definedClass.removeMarker(VirtualMethodsMarker.class) != null) {
                    this.ensureHierarchyVisited(definedClass);
                }
                return false;
            }

            @Override
            public boolean visit(@Nonnull JDefinedInterface defineInterface) {
                if (defineInterface.removeMarker(VirtualMethodsMarker.class) != null) {
                    this.ensureHierarchyVisited(defineInterface);
                }
                return false;
            }

            @Override
            public boolean visit(@Nonnull JPhantomClassOrInterface phantomClassOrInterface) {
                if (phantomClassOrInterface.removeMarker(VirtualMethodsMarker.class) != null) {
                    this.ensureHierarchyVisited(phantomClassOrInterface);
                }
                return false;
            }

            private void ensureHierarchyVisited(@Nonnull JClassOrInterface node) {
                JClass zuper = this.getSuper(node);
                if (zuper != null) {
                    this.accept(zuper);
                }
                if (node instanceof JDefinedClassOrInterface) {
                    for (JClassOrInterface jClassOrInterface : ((JDefinedClassOrInterface)node).getImplements()) {
                        this.accept(jClassOrInterface);
                    }
                }
            }

            @CheckForNull
            private JClass getSuper(@Nonnull JClassOrInterface node) {
                if (node instanceof JDefinedClass) {
                    return ((JDefinedClass)node).getSuperClass();
                }
                if (!node.isSameType(this.javaLangObject)) {
                    return this.javaLangObject;
                }
                return null;
            }
        }
    }
}

