/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.frontend;

import com.android.jack.frontend.MethodIdMerger;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JLambda;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JNameValuePair;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.lookup.JMethodWithReturnLookupException;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.item.Tag;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.ExclusiveAccess;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import java.util.Collection;
import javax.annotation.Nonnull;

@Description(value="Update methodIds of JMethodCalls and JNameValuePairs so that they used the merged uniq ids")
@Constraint(need={MethodIdMerger.MethodIdMerged.class})
@Transform(add={UniqMethodIds.class})
@ExclusiveAccess(value=JSession.class)
public class MethodIdDuplicateRemover
implements RunnableSchedulable<JDefinedClassOrInterface> {
    @Override
    public void run(@Nonnull JDefinedClassOrInterface type) {
        new Visitor().accept(type);
    }

    private static class Visitor
    extends JVisitor {
        private Visitor() {
            super(false);
        }

        @Nonnull
        private JMethodIdWide getResolvedMethodIdWide(@Nonnull JClassOrInterface receiverType, @Nonnull JMethodIdWide id) {
            Collection<JMethod> methods = id.getMethods();
            if (!methods.isEmpty()) {
                JMethod method = methods.iterator().next();
                return method.getMethodIdWide();
            }
            return receiverType.getOrCreateMethodIdWide(id.getName(), id.getParamTypes(), id.getKind());
        }

        @Override
        public boolean visit(@Nonnull JLambda lambda) {
            JInterface lambdaType = lambda.getType();
            try {
                JMethodId mthIdWithErasure = lambda.getMethodIdWithErasure();
                lambda.resolveMethodId(lambdaType.getMethodId(mthIdWithErasure.getMethodIdWide().getName(), mthIdWithErasure.getMethodIdWide().getParamTypes(), MethodKind.INSTANCE_VIRTUAL, mthIdWithErasure.getType()));
            }
            catch (JMethodWithReturnLookupException e) {
                throw new AssertionError();
            }
            return super.visit(lambda);
        }

        @Override
        public boolean visit(@Nonnull JMethodCall call) {
            JMethodIdWide id = this.getResolvedMethodIdWide(call.getReceiverType(), call.getMethodId());
            call.resolveMethodId(id);
            return super.visit(call);
        }

        @Override
        public boolean visit(@Nonnull JAnnotation annotation) {
            for (JNameValuePair pair : annotation.getNameValuePairs()) {
                JMethodIdWide id = this.getResolvedMethodIdWide(annotation.getType(), pair.getMethodId());
                pair.resolveMethodId(id);
            }
            return super.visit(annotation);
        }
    }

    @Description(value="Jack IR is using uniq JMethodIds")
    @Name(value="UniqMethodIds")
    public static class UniqMethodIds
    implements Tag {
    }
}

