/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.freemarker.core;

import com.android.jack.freemarker.core.Environment;
import com.android.jack.freemarker.core.ParameterRole;
import com.android.jack.freemarker.core.ParseException;
import com.android.jack.freemarker.core.TemplateElement;
import com.android.jack.freemarker.core.TemplatePostProcessor;
import com.android.jack.freemarker.core.TemplatePostProcessorException;
import com.android.jack.freemarker.template.Template;
import com.android.jack.freemarker.template.TemplateException;
import java.io.IOException;

class ThreadInterruptionSupportTemplatePostProcessor
extends TemplatePostProcessor {
    ThreadInterruptionSupportTemplatePostProcessor() {
    }

    public void postProcess(Template t) throws TemplatePostProcessorException {
        TemplateElement te = t.getRootTreeNode();
        this.addInterruptionChecks(te);
    }

    private void addInterruptionChecks(TemplateElement te) throws TemplatePostProcessorException {
        if (te == null) {
            return;
        }
        int regulatedChildrenCount = te.getChildCount();
        for (int i = 0; i < regulatedChildrenCount; ++i) {
            this.addInterruptionChecks(te.getChild(i));
        }
        if (te.isNestedBlockRepeater()) {
            try {
                te.addChild(0, new ThreadInterruptionCheck(te));
            }
            catch (ParseException e) {
                throw new TemplatePostProcessorException("Unexpected error; see cause", e);
            }
        }
    }

    static class TemplateProcessingThreadInterruptedException
    extends RuntimeException {
        TemplateProcessingThreadInterruptedException() {
            super("Template processing thread \"interrupted\" flag was set.");
        }
    }

    static class ThreadInterruptionCheck
    extends TemplateElement {
        private ThreadInterruptionCheck(TemplateElement te) throws ParseException {
            this.setLocation(te.getTemplate(), te.beginColumn, te.beginLine, te.beginColumn, te.beginLine);
        }

        TemplateElement[] accept(Environment env) throws TemplateException, IOException {
            if (Thread.currentThread().isInterrupted()) {
                throw new TemplateProcessingThreadInterruptedException();
            }
            return null;
        }

        protected String dump(boolean canonical) {
            return canonical ? "" : "<#--" + this.getNodeTypeSymbol() + "--#>";
        }

        String getNodeTypeSymbol() {
            return "##threadInterruptionCheck";
        }

        int getParameterCount() {
            return 0;
        }

        Object getParameterValue(int idx) {
            throw new IndexOutOfBoundsException();
        }

        ParameterRole getParameterRole(int idx) {
            throw new IndexOutOfBoundsException();
        }

        boolean isNestedBlockRepeater() {
            return false;
        }
    }
}

