/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ecj.loader.jast;

import com.android.jack.ecj.loader.jast.AnnotationUtils;
import com.android.jack.ecj.loader.jast.LoaderUtils;
import com.android.jack.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import com.android.jack.eclipse.jdt.internal.compiler.env.IBinaryField;
import com.android.jack.eclipse.jdt.internal.compiler.env.IBinaryTypeAnnotation;
import com.android.jack.eclipse.jdt.internal.compiler.impl.Constant;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JModifier;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

class JAstBinaryField
implements IBinaryField {
    @Nonnull
    private final JField jField;
    @CheckForNull
    private final JLiteral initialValue;

    JAstBinaryField(@Nonnull JField jField, @CheckForNull JLiteral initialValue) {
        this.jField = jField;
        this.initialValue = initialValue;
    }

    @Override
    public int getModifiers() {
        int modifiers = LoaderUtils.convertJAstModifiersToEcj(this.jField.getModifier() & 0xFFFDFFFF, this.jField);
        return modifiers;
    }

    @Override
    @CheckForNull
    public IBinaryAnnotation[] getAnnotations() {
        return AnnotationUtils.convertJAstAnnotationToEcj(this.jField, true);
    }

    @Override
    @Nonnull
    public Constant getConstant() {
        Constant constant = JModifier.isCompileTimeConstant(this.jField.getModifier()) ? LoaderUtils.convertJLiteralToEcj(this.initialValue) : Constant.NotAConstant;
        return constant;
    }

    @Override
    @CheckForNull
    public char[] getGenericSignature() {
        return LoaderUtils.getGenericSignature(this.jField);
    }

    @Override
    @Nonnull
    public char[] getName() {
        return this.jField.getName().toCharArray();
    }

    @Override
    public long getTagBits() {
        return AnnotationUtils.getTagBits(this.jField);
    }

    @Override
    @Nonnull
    public char[] getTypeName() {
        return LoaderUtils.getSignatureFormatter().getName(this.jField.getType()).toCharArray();
    }

    @Nonnull
    public String toString() {
        return this.jField.toString();
    }

    @Override
    public IBinaryTypeAnnotation[] getTypeAnnotations() {
        return null;
    }
}

