/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.ssa.back;

import com.android.jack.dx.rop.code.PlainInsn;
import com.android.jack.dx.rop.code.RegisterSpecList;
import com.android.jack.dx.rop.code.Rops;
import com.android.jack.dx.ssa.NormalSsaInsn;
import com.android.jack.dx.ssa.SsaBasicBlock;
import com.android.jack.dx.ssa.SsaInsn;
import com.android.jack.dx.ssa.SsaMethod;
import com.android.jack.dx.util.BitIntSet;
import com.android.jack.dx.util.IntList;
import java.util.List;
import javax.annotation.Nonnull;

class RedundantConditionalBranchRemover {
    @Nonnull
    private final SsaMethod method;
    @Nonnull
    private final List<SsaBasicBlock> blocks;

    RedundantConditionalBranchRemover(@Nonnull SsaMethod method) {
        this.method = method;
        this.blocks = method.getBlocks();
    }

    void process() {
        this.method.forEachBlockDepthFirst(true, new SsaBasicBlock.Visitor(){

            @Override
            public void visitBlock(SsaBasicBlock block, SsaBasicBlock parent) {
                RedundantConditionalBranchRemover.this.pruneRedundantConditionalBranch(block);
            }
        });
    }

    private void pruneRedundantConditionalBranch(@Nonnull SsaBasicBlock block) {
        int i;
        SsaInsn slast = block.getLastInsns();
        if (slast == null) {
            return;
        }
        int branchingness = slast.getOpcode().getBranchingness();
        if (branchingness != 4 && branchingness != 5) {
            return;
        }
        IntList successors = block.getSuccessorList().mutableCopy();
        if (successors.size() <= 1) {
            return;
        }
        int target = this.traceEmptyGoto(this.blocks.get(successors.get(0)));
        for (i = 1; i < successors.size(); ++i) {
            SsaBasicBlock successor = this.blocks.get(successors.get(i));
            if (this.traceEmptyGoto(successor) == target) continue;
            return;
        }
        int size = successors.size();
        for (i = 0; i < size; ++i) {
            int successorIdx = successors.get(i);
            if (successorIdx == target) continue;
            block.replaceSuccessor(successorIdx, target);
        }
        NormalSsaInsn nLast = (NormalSsaInsn)slast;
        block.replaceLastInsn(new PlainInsn(Rops.GOTO, nLast.getOriginalRopInsn().getPosition(), null, RegisterSpecList.EMPTY));
    }

    private int traceEmptyGoto(@Nonnull SsaBasicBlock block) {
        BitIntSet worklist = new BitIntSet(this.method.getBlocks().size());
        while (!worklist.has(block.getIndex())) {
            worklist.add(block.getIndex());
            if (!block.isSingleGoto()) {
                return block.getIndex();
            }
            block = block.getPrimarySuccessor();
        }
        return block.getIndex();
    }
}

