/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.dex.code;

import com.android.jack.dx.dex.code.DalvInsn;
import com.android.jack.dx.dex.code.Dop;
import com.android.jack.dx.dex.code.FixedSizeInsn;
import com.android.jack.dx.rop.code.RegisterSpecList;
import com.android.jack.dx.rop.code.SourcePosition;
import com.android.jack.dx.rop.cst.Constant;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class DualCstInsn
extends FixedSizeInsn {
    @Nonnull
    private final Constant firstConstant;
    @Nonnull
    private final Constant secondConstant;
    private int firstIndex;
    private int secondIndex;

    public DualCstInsn(@Nonnull Dop opcode, @Nonnull SourcePosition position, @Nonnull RegisterSpecList registers, @Nonnull Constant firstConstant, @Nonnull Constant secondConstant) {
        super(opcode, position, registers);
        assert (firstConstant != null);
        assert (secondConstant != null);
        this.firstConstant = firstConstant;
        this.secondConstant = secondConstant;
        this.firstIndex = -1;
        this.secondIndex = -1;
    }

    @Override
    @Nonnull
    public DalvInsn withOpcode(@Nonnull Dop opcode) {
        DualCstInsn result = new DualCstInsn(opcode, this.getPosition(), this.getRegisters(), this.firstConstant, this.secondConstant);
        if (this.firstIndex >= 0) {
            result.setFirstIndex(this.firstIndex);
        }
        if (this.secondIndex >= 0) {
            result.setSecondIndex(this.secondIndex);
        }
        return result;
    }

    @Override
    @Nonnull
    public DalvInsn withRegisters(@Nonnull RegisterSpecList registers) {
        DualCstInsn result = new DualCstInsn(this.getOpcode(), this.getPosition(), registers, this.firstConstant, this.secondConstant);
        if (this.firstIndex >= 0) {
            result.setFirstIndex(this.firstIndex);
        }
        if (this.secondIndex >= 0) {
            result.setSecondIndex(this.secondIndex);
        }
        return result;
    }

    @Nonnull
    public Constant getFirstConstant() {
        return this.firstConstant;
    }

    @Nonnull
    public Constant getSecondConstant() {
        return this.secondConstant;
    }

    public void setFirstIndex(@Nonnegative int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index < 0");
        }
        if (this.firstIndex >= 0) {
            throw new RuntimeException("firstIndex already set");
        }
        this.firstIndex = index;
    }

    public void setSecondIndex(@Nonnegative int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index < 0");
        }
        if (this.secondIndex >= 0) {
            throw new RuntimeException("secondIndex already set");
        }
        this.secondIndex = index;
    }

    @Nonnegative
    public int getFirstIndex() {
        if (this.firstIndex < 0) {
            throw new RuntimeException("index not yet set for " + this.firstConstant);
        }
        return this.firstIndex;
    }

    @Nonnegative
    public int getSecondIndex() {
        if (this.secondIndex < 0) {
            throw new RuntimeException("index not yet set for " + this.secondConstant);
        }
        return this.secondIndex;
    }

    @Override
    @Nonnull
    protected String argString() {
        return this.firstConstant.toHuman() + ", " + this.secondConstant.toHuman();
    }
}

