/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.digest;

import com.android.jack.digest.OriginDigestElement;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.marker.SerializableMarker;
import com.android.sched.marker.ValidOn;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.Nonnull;

@Description(value="Contains digest of the origine")
@ValidOn(value={JDefinedClassOrInterface.class})
public class OriginDigestMarker
implements SerializableMarker {
    @Nonnull
    private final Set<OriginDigestElement> descriptor;
    @Nonnull
    private final String algo;
    @Nonnull
    private final byte[] digest;
    @Nonnull
    private final String emitter;
    private final int major;
    private final int minor;
    @Nonnull
    private static final byte[] code = "0123456789ABCDEF".getBytes();

    public OriginDigestMarker(@Nonnull Set<OriginDigestElement> descriptor, @Nonnull String algo, @Nonnull byte[] digest, @Nonnull String emitter, int major, int minor) {
        this.algo = algo;
        this.digest = (byte[])digest.clone();
        this.descriptor = descriptor;
        this.emitter = emitter;
        this.major = major;
        this.minor = minor;
    }

    @Override
    public Marker cloneIfNeeded() {
        return this;
    }

    @Nonnull
    public byte[] getDigest() {
        return (byte[])this.digest.clone();
    }

    @Nonnull
    public Set<OriginDigestElement> getDescriptor() {
        return this.descriptor;
    }

    @Nonnull
    public String getAlgo() {
        return this.algo;
    }

    @Nonnull
    public String getEmitterId() {
        return this.emitter;
    }

    public int getMajorCode() {
        return this.major;
    }

    public int getMinorCode() {
        return this.minor;
    }

    public String toString() {
        return "<" + this.descriptor.toString() + "," + this.algo + "," + new String(OriginDigestMarker.encode(this.digest)) + ">";
    }

    @Nonnull
    private static char[] encode(@Nonnull byte[] bytes) {
        char[] array = new char[bytes.length * 2];
        for (int idx = 0; idx < bytes.length; ++idx) {
            array[idx << 1] = (char)code[(bytes[idx] & 0xF0) >> 4];
            array[(idx << 1) + 1] = (char)code[bytes[idx] & 0xF];
        }
        return array;
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof OriginDigestMarker)) {
            return false;
        }
        OriginDigestMarker marker = (OriginDigestMarker)obj;
        return this.algo.equals(marker.algo) && this.descriptor.equals(marker.descriptor) && Arrays.equals(this.digest, marker.digest);
    }

    public int hashCode() {
        return this.algo.hashCode() ^ this.descriptor.hashCode() ^ Arrays.hashCode(this.digest);
    }
}

