/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.digest;

import com.android.jack.util.TextOutput;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import javax.annotation.Nonnull;

public class DigestOutput
implements TextOutput {
    @Nonnull
    private final MessageDigest digest;

    protected DigestOutput(@Nonnull MessageDigest digest) {
        this.digest = digest;
    }

    @Nonnull
    public MessageDigest getMessageDigest() {
        return this.digest;
    }

    @Override
    public void indentIn() {
    }

    @Override
    public void indentOut() {
    }

    @Override
    public void newline() {
    }

    @Override
    public void newlineOpt() {
    }

    @Override
    public void print(char c) {
        this.digest.update((byte)(c >> 8));
        this.digest.update((byte)(c & 0xFF));
    }

    @Override
    public void print(@Nonnull char[] s) {
        this.digest.update(new String(s).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void print(@Nonnull String s) {
        this.digest.update(s.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void printOpt(char c) {
    }

    @Override
    public void printOpt(@Nonnull char[] s) {
    }

    @Override
    public void printOpt(@Nonnull String s) {
    }

    @Override
    public int getPosition() {
        throw new AssertionError();
    }
}

