/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.cfg;

import com.android.jack.Jack;
import com.android.jack.cfg.BasicBlock;
import com.android.jack.cfg.EntryBlock;
import com.android.jack.cfg.ExitBlock;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.util.graph.Graph;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import java.util.ArrayList;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@Description(value="A ControlFlowGraph marker.")
@ValidOn(value={JMethod.class})
public class ControlFlowGraph
extends Graph<BasicBlock>
implements Marker {
    @Nonnull
    private final JMethod method;
    @Nonnegative
    private final int basicBlockMaxId;

    public ControlFlowGraph(@Nonnull JMethod method, @Nonnegative int basicBlockMaxId, @Nonnull EntryBlock entryBlock, @Nonnull ExitBlock exitBlock, @Nonnull ArrayList<BasicBlock> blocks) {
        super(entryBlock, exitBlock, blocks);
        assert (method != null);
        assert (entryBlock.getStatements().isEmpty());
        assert (exitBlock.getStatements().isEmpty());
        assert (!blocks.contains(entryBlock));
        assert (!blocks.contains(exitBlock));
        this.method = method;
        this.basicBlockMaxId = basicBlockMaxId;
    }

    @Override
    @Nonnull
    public EntryBlock getEntryNode() {
        return (EntryBlock)super.getEntryNode();
    }

    @Nonnull
    public JMethod getMethod() {
        return this.method;
    }

    @Nonnull
    public String toString() {
        return "Cfg of " + Jack.getUserFriendlyFormatter().getName(this.method.getEnclosingType()) + "." + Jack.getUserFriendlyFormatter().getName(this.method);
    }

    @Override
    @Nonnull
    public Marker cloneIfNeeded() {
        return this;
    }

    @Nonnegative
    public int getBasicBlockMaxId() {
        return this.basicBlockMaxId;
    }
}

