/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.jayce;

import com.android.jack.JackEventType;
import com.android.jack.backend.jayce.TypeImportConflictException;
import com.android.jack.config.id.Brest;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.ast.Resource;
import com.android.jack.library.FileType;
import com.android.jack.library.FileTypeDoesNotExistException;
import com.android.jack.library.IgnoringImportMessage;
import com.android.jack.library.InputJackLibrary;
import com.android.jack.library.InputLibrary;
import com.android.jack.library.LibraryReadingException;
import com.android.jack.library.ResourceInInputLibraryLocation;
import com.android.jack.library.TypeInInputLibraryLocation;
import com.android.jack.lookup.JLookupException;
import com.android.jack.reporting.Reporter;
import com.android.jack.resource.ResourceImportConflictException;
import com.android.jack.resource.ResourceImporter;
import com.android.sched.util.HasDescription;
import com.android.sched.util.codec.EnumCodec;
import com.android.sched.util.codec.VariableName;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.PropertyId;
import com.android.sched.util.location.Location;
import com.android.sched.util.log.Event;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.vfs.GenericInputVFile;
import com.android.sched.vfs.InputVFile;
import com.android.sched.vfs.VPath;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

@HasKeyId
public class JayceFileImporter {
    @Nonnull
    public static final String JAYCE_FILE_EXTENSION = ".jayce";
    public static final int JACK_EXTENSION_LENGTH = ".jayce".length();
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private final List<InputJackLibrary> jackLibraries;
    private static final char VPATH_SEPARATOR = '/';
    @Nonnull
    public static final PropertyId<CollisionPolicy> COLLISION_POLICY = PropertyId.create("jack.import.type.policy", "Defines the policy to follow concerning type collision", new EnumCodec(CollisionPolicy.class, (Enum[])CollisionPolicy.values()).ignoreCase()).addDefaultValue(CollisionPolicy.FAIL).addCategory(Brest.class);
    @Nonnull
    private final CollisionPolicy collisionPolicy = ThreadConfig.get(COLLISION_POLICY);
    @Nonnull
    private final CollisionPolicy resourceCollisionPolicy = ThreadConfig.get(ResourceImporter.RESOURCE_COLLISION_POLICY);

    public JayceFileImporter(@Nonnull List<InputJackLibrary> jackLibraries) {
        this.jackLibraries = jackLibraries;
    }

    public void doJayceImport(@Nonnull JSession session) throws LibraryReadingException {
        for (InputJackLibrary jackLibrary : this.jackLibraries) {
            Reporter reporter = session.getReporter();
            logger.log(Level.FINE, "Importing jayces from {0}", jackLibrary.getLocation().getDescription());
            Iterator<InputVFile> jayceFileIt = jackLibrary.iterator(FileType.JAYCE);
            while (jayceFileIt.hasNext()) {
                InputVFile jayceFile = jayceFileIt.next();
                try {
                    this.addImportedTypes(session, jayceFile, jackLibrary);
                }
                catch (JLookupException e) {
                    throw new LibraryReadingException(e);
                }
                catch (TypeImportConflictException e) {
                    if (this.collisionPolicy == CollisionPolicy.FAIL) {
                        throw new LibraryReadingException(e);
                    }
                    reporter.report(Reporter.Severity.NON_FATAL, new IgnoringImportMessage(e));
                }
            }
        }
    }

    public void doResourceImport(@Nonnull JSession session) throws LibraryReadingException {
        for (InputJackLibrary jackLibrary : this.jackLibraries) {
            Reporter reporter = session.getReporter();
            logger.log(Level.FINE, "Importing resources from {0}", jackLibrary.getLocation().getDescription());
            Iterator<InputVFile> rscFileIt = jackLibrary.iterator(FileType.RSC);
            while (rscFileIt.hasNext()) {
                InputVFile rscFile = rscFileIt.next();
                String name = rscFile.getPathFromRoot().getPathAsString('/');
                try {
                    this.addImportedResource(rscFile, session, name, jackLibrary);
                }
                catch (ResourceImportConflictException e) {
                    if (this.resourceCollisionPolicy == CollisionPolicy.FAIL) {
                        throw new LibraryReadingException(e);
                    }
                    reporter.report(Reporter.Severity.NON_FATAL, new IgnoringImportMessage(e));
                }
            }
        }
    }

    private void addImportedTypes(@Nonnull JSession session, @Nonnull InputVFile jayceFile, @Nonnull InputLibrary intendedInputLibrary) throws TypeImportConflictException, JTypeLookupException {
        try (Event readEvent = this.tracer.open(JackEventType.NNODE_READING_FOR_IMPORT);){
            String path = jayceFile.getPathFromRoot().getPathAsString('/');
            logger.log(Level.FINEST, "Importing jayce file ''{0}'' from {1}", new Object[]{path, intendedInputLibrary.getLocation().getDescription()});
            String signature = this.convertJackFilePathToSignature(path);
            JDefinedClassOrInterface declaredType = (JDefinedClassOrInterface)session.getLookup().getType(signature);
            if (!JayceFileImporter.isTypeFromLibrary(declaredType, intendedInputLibrary)) {
                Location previousLocation = declaredType.getLocation();
                if (previousLocation instanceof TypeInInputLibraryLocation) {
                    InputLibrary previousInputLibrary = ((TypeInInputLibraryLocation)previousLocation).getInputLibrary();
                    String pathWithoutExt = path.substring(0, path.lastIndexOf(JAYCE_FILE_EXTENSION));
                    try {
                        String previousDigest = ((GenericInputVFile)previousInputLibrary.getFile(FileType.PREBUILT, new VPath(pathWithoutExt, '/'))).getDigest();
                        if (previousDigest != null && previousDigest.equals(((GenericInputVFile)jayceFile).getDigest())) {
                            return;
                        }
                    }
                    catch (FileTypeDoesNotExistException fileTypeDoesNotExistException) {
                        // empty catch block
                    }
                }
                throw new TypeImportConflictException(declaredType, intendedInputLibrary.getLocation());
            }
            session.addTypeToEmit(declaredType);
        }
    }

    private static boolean isTypeFromLibrary(@Nonnull JDefinedClassOrInterface declaredType, @Nonnull InputLibrary intendedInputLibrary) {
        Location existingSource = declaredType.getLocation();
        if (!(existingSource instanceof TypeInInputLibraryLocation)) {
            return false;
        }
        TypeInInputLibraryLocation existingLocation = (TypeInInputLibraryLocation)existingSource;
        return intendedInputLibrary.equals(existingLocation.getInputLibrary());
    }

    @Nonnull
    private String convertJackFilePathToSignature(@Nonnull String path) {
        String pathWithoutExt = path.substring(0, path.length() - JAYCE_FILE_EXTENSION.length());
        return "L" + pathWithoutExt.replace('/', '/') + ";";
    }

    private void addImportedResource(@Nonnull InputVFile file, @Nonnull JSession session, @Nonnull String currentPath, @Nonnull InputLibrary inputLibrary) throws ResourceImportConflictException {
        VPath path = new VPath(currentPath, '/');
        ResourceInInputLibraryLocation resourceLocation = new ResourceInInputLibraryLocation(inputLibrary, path);
        Resource newResource = new Resource(path, file, resourceLocation);
        for (Resource existingResource : session.getResources()) {
            if (!existingResource.getPath().equals(path)) continue;
            throw new ResourceImportConflictException(existingResource, newResource.getLocation());
        }
        session.addResource(newResource);
    }

    public static boolean isJackFileName(@Nonnull String name) {
        return name.length() > JACK_EXTENSION_LENGTH && name.substring(name.length() - JACK_EXTENSION_LENGTH).equalsIgnoreCase(JAYCE_FILE_EXTENSION);
    }

    @VariableName(value="policy")
    public static enum CollisionPolicy implements HasDescription
    {
        KEEP_FIRST("keep the first element encountered"),
        FAIL("fail when a collision occurs");

        @Nonnull
        private String description;

        private CollisionPolicy(String description) {
            this.description = description;
        }

        @Override
        @Nonnull
        public String getDescription() {
            return this.description;
        }
    }
}

