/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex.rop;

import com.android.jack.backend.dex.rop.RopHelper;
import com.android.jack.debug.DebugVariableInfoMarker;
import com.android.jack.dx.rop.code.LocalItem;
import com.android.jack.dx.rop.code.RegisterSpec;
import com.android.jack.dx.rop.cst.CstString;
import com.android.jack.dx.rop.cst.CstType;
import com.android.jack.dx.rop.type.Type;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JThis;
import com.android.jack.ir.ast.JThisRef;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVariable;
import com.android.jack.ir.ast.JVariableRef;
import com.android.jack.ir.ast.marker.GenericSignature;
import com.android.jack.ir.ast.marker.ThisRefTypeInfo;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

class RopRegisterManager {
    private int nextFreeReg = 0;
    @Nonnull
    private final Map<Type, List<RegisterSpec>> typeToTmpRegister = new Hashtable<Type, List<RegisterSpec>>();
    @Nonnull
    private final Map<Type, Integer> typeToNextPosFreeRegister = new Hashtable<Type, Integer>();
    @Nonnull
    private final Map<JVariable, Integer> variableToRegNumber = new Hashtable<JVariable, Integer>();
    @CheckForNull
    private RegisterSpec returnReg = null;
    @CheckForNull
    private RegisterSpec thisReg = null;
    private final boolean emitSyntheticDebugInfo;
    private final boolean emitDebugInfo;

    public RopRegisterManager(boolean emitDebugInfo, boolean emitSyntheticDebugInfo) {
        this.emitDebugInfo = emitDebugInfo;
        this.emitSyntheticDebugInfo = emitSyntheticDebugInfo;
    }

    @Nonnull
    RegisterSpec createThisReg(@Nonnull JThis jThis) {
        assert (this.thisReg == null) : "This register was already created.";
        JDefinedClassOrInterface type = (JDefinedClassOrInterface)jThis.getType();
        Type dexRegType = RopHelper.convertTypeToDx(type);
        String name = jThis.getName();
        if (this.emitDebugInfo && name != null) {
            assert (jThis.getMarker(GenericSignature.class) == null);
            CstString cstSignature = null;
            ThisRefTypeInfo thisMarker = type.getMarker(ThisRefTypeInfo.class);
            if (thisMarker != null && !thisMarker.getGenericSignature().isEmpty()) {
                cstSignature = new CstString(thisMarker.getGenericSignature());
            }
            LocalItem localItem = LocalItem.make(new CstString(name), RopHelper.getCstType(type), cstSignature);
            this.thisReg = RegisterSpec.make(this.nextFreeReg, dexRegType, localItem);
        } else {
            this.thisReg = RegisterSpec.make(this.nextFreeReg, dexRegType);
        }
        this.nextFreeReg += dexRegType.getCategory();
        assert (this.thisReg != null);
        return this.thisReg;
    }

    @Nonnull
    RegisterSpec createRegisterSpec(@Nonnull JType type) {
        Type dexRegType = RopHelper.convertTypeToDx(type);
        RegisterSpec reg = RegisterSpec.make(this.nextFreeReg, dexRegType);
        this.nextFreeReg += dexRegType.getCategory();
        return reg;
    }

    @Nonnegative
    int getRegisterNumber(@Nonnull JVariable variable) {
        Integer regNum = this.variableToRegNumber.get(variable);
        if (regNum == null) {
            Type dexRegType = RopHelper.convertTypeToDx(variable.getType());
            regNum = this.nextFreeReg;
            this.variableToRegNumber.put(variable, regNum);
            this.nextFreeReg += dexRegType.getCategory();
        }
        return regNum;
    }

    @Nonnull
    RegisterSpec getOrCreateRegisterSpec(@Nonnull JVariableRef varRef) {
        if (varRef instanceof JThisRef) {
            assert (this.thisReg != null) : "This register was not created.";
            return this.thisReg;
        }
        JVariable variable = varRef.getTarget();
        RegisterSpec register = this.getRegisterSpec(this.getRegisterNumber(variable), variable, varRef.getMarker(DebugVariableInfoMarker.class));
        assert (RopHelper.areTypeCompatible(RopHelper.convertTypeToDx(varRef.getType()), register.getType()));
        return register;
    }

    @Nonnull
    RegisterSpec getOrCreateRegisterSpec(@Nonnull JParameter parameter) {
        assert (parameter.getMarker(DebugVariableInfoMarker.class) == null);
        return this.getRegisterSpec(this.getRegisterNumber(parameter), parameter, null);
    }

    @Nonnull
    private RegisterSpec getRegisterSpec(@Nonnegative int regNum, @Nonnull JVariable variable, @CheckForNull DebugVariableInfoMarker debugInfo) {
        RegisterSpec reg;
        JType variableType = variable.getType();
        Type regType = RopHelper.convertTypeToDx(variableType);
        if (this.emitDebugInfo && variable.getName() != null && (this.emitSyntheticDebugInfo || !variable.isSynthetic())) {
            if (debugInfo != null) {
                CstString cstSignature = null;
                if (debugInfo.getGenericSignature() != null) {
                    cstSignature = new CstString(debugInfo.getGenericSignature());
                }
                LocalItem localItem = LocalItem.make(new CstString(debugInfo.getName()), CstType.intern(RopHelper.convertTypeToDx(debugInfo.getType())), cstSignature);
                reg = RegisterSpec.make(regNum, regType, localItem);
            } else {
                CstString cstSignature = null;
                GenericSignature infoMarker = variable.getMarker(GenericSignature.class);
                if (infoMarker != null) {
                    cstSignature = new CstString(infoMarker.getGenericSignature());
                }
                LocalItem localItem = LocalItem.make(new CstString(variable.getName()), CstType.intern(regType), cstSignature);
                reg = RegisterSpec.make(regNum, regType, localItem);
            }
        } else {
            reg = RegisterSpec.make(regNum, regType);
        }
        return reg;
    }

    @Nonnull
    RegisterSpec getReturnReg(@Nonnull JType returnType) {
        RegisterSpec localReturnReg = this.returnReg;
        assert (localReturnReg != null) : "Return reg must be firstly created.";
        assert (RopHelper.areTypeCompatible(RopHelper.convertTypeToDx(returnType), localReturnReg.getType()));
        return localReturnReg;
    }

    @Nonnull
    RegisterSpec createReturnReg(@Nonnull JType returnType) {
        assert (this.returnReg == null);
        Type dexRegType = RopHelper.convertTypeToDx(returnType);
        this.returnReg = RegisterSpec.make(0, dexRegType);
        assert (this.returnReg != null);
        return this.returnReg;
    }

    @Nonnull
    RegisterSpec getOrCreateTmpRegister(@Nonnull Type dexRegType) {
        List<RegisterSpec> regSpecs;
        Integer nextFreeRegister = this.typeToNextPosFreeRegister.get(dexRegType);
        if (nextFreeRegister == null) {
            nextFreeRegister = 0;
            this.typeToNextPosFreeRegister.put(dexRegType, nextFreeRegister);
        }
        if ((regSpecs = this.typeToTmpRegister.get(dexRegType)) == null) {
            regSpecs = new ArrayList<RegisterSpec>(2);
            this.typeToTmpRegister.put(dexRegType, regSpecs);
        }
        this.typeToNextPosFreeRegister.put(dexRegType, nextFreeRegister + 1);
        if (nextFreeRegister < regSpecs.size()) {
            return regSpecs.get(nextFreeRegister);
        }
        RegisterSpec regSpec = RegisterSpec.make(this.nextFreeReg, dexRegType);
        regSpecs.add(regSpec);
        this.nextFreeReg += dexRegType.getCategory();
        return regSpec;
    }

    void resetFreeTmpRegister() {
        for (Type type : this.typeToNextPosFreeRegister.keySet()) {
            this.typeToNextPosFreeRegister.put(type, 0);
        }
    }

    @Nonnull
    RegisterSpec getThisReg() {
        assert (this.thisReg != null);
        return this.thisReg;
    }
}

