/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex.rop;

import com.android.jack.backend.dex.rop.RopHelper;
import com.android.jack.backend.dex.rop.RopRegisterManager;
import com.android.jack.cfg.BasicBlock;
import com.android.jack.cfg.CatchBasicBlock;
import com.android.jack.cfg.PeiBasicBlock;
import com.android.jack.cfg.SwitchBasicBlock;
import com.android.jack.dx.rop.code.FillArrayDataInsn;
import com.android.jack.dx.rop.code.Insn;
import com.android.jack.dx.rop.code.PlainCstInsn;
import com.android.jack.dx.rop.code.PlainInsn;
import com.android.jack.dx.rop.code.RegisterSpec;
import com.android.jack.dx.rop.code.RegisterSpecList;
import com.android.jack.dx.rop.code.Rop;
import com.android.jack.dx.rop.code.Rops;
import com.android.jack.dx.rop.code.SourcePosition;
import com.android.jack.dx.rop.code.SwitchInsn;
import com.android.jack.dx.rop.code.ThrowingCstInsn;
import com.android.jack.dx.rop.code.ThrowingDualCstInsn;
import com.android.jack.dx.rop.code.ThrowingInsn;
import com.android.jack.dx.rop.cst.Constant;
import com.android.jack.dx.rop.cst.CstBoolean;
import com.android.jack.dx.rop.cst.CstDouble;
import com.android.jack.dx.rop.cst.CstFieldRef;
import com.android.jack.dx.rop.cst.CstFloat;
import com.android.jack.dx.rop.cst.CstInteger;
import com.android.jack.dx.rop.cst.CstKnownNull;
import com.android.jack.dx.rop.cst.CstLiteral32;
import com.android.jack.dx.rop.cst.CstLiteral64;
import com.android.jack.dx.rop.cst.CstLiteralBits;
import com.android.jack.dx.rop.cst.CstLong;
import com.android.jack.dx.rop.cst.CstMethodRef;
import com.android.jack.dx.rop.cst.CstNat;
import com.android.jack.dx.rop.cst.CstPrototypeRef;
import com.android.jack.dx.rop.cst.CstString;
import com.android.jack.dx.rop.cst.CstType;
import com.android.jack.dx.rop.type.Prototype;
import com.android.jack.dx.rop.type.StdTypeList;
import com.android.jack.dx.rop.type.Type;
import com.android.jack.dx.rop.type.TypeBearer;
import com.android.jack.dx.rop.type.TypeList;
import com.android.jack.dx.util.IntList;
import com.android.jack.ir.ast.FieldKind;
import com.android.jack.ir.ast.JAbsentArrayDimension;
import com.android.jack.ir.ast.JAbstractStringLiteral;
import com.android.jack.ir.ast.JAlloc;
import com.android.jack.ir.ast.JArrayLength;
import com.android.jack.ir.ast.JArrayRef;
import com.android.jack.ir.ast.JArrayType;
import com.android.jack.ir.ast.JBinaryOperation;
import com.android.jack.ir.ast.JBinaryOperator;
import com.android.jack.ir.ast.JBooleanLiteral;
import com.android.jack.ir.ast.JByteLiteral;
import com.android.jack.ir.ast.JCaseStatement;
import com.android.jack.ir.ast.JCatchBlock;
import com.android.jack.ir.ast.JCharLiteral;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassLiteral;
import com.android.jack.ir.ast.JDoubleLiteral;
import com.android.jack.ir.ast.JDynamicCastOperation;
import com.android.jack.ir.ast.JExceptionRuntimeValue;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JFieldRef;
import com.android.jack.ir.ast.JFloatLiteral;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JInstanceOf;
import com.android.jack.ir.ast.JIntLiteral;
import com.android.jack.ir.ast.JIntegralConstant32;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JLambda;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JLocalRef;
import com.android.jack.ir.ast.JLock;
import com.android.jack.ir.ast.JLongLiteral;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JNewArray;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JNullLiteral;
import com.android.jack.ir.ast.JPolymorphicMethodCall;
import com.android.jack.ir.ast.JPrefixNotOperation;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JReferenceType;
import com.android.jack.ir.ast.JReinterpretCastOperation;
import com.android.jack.ir.ast.JReturnStatement;
import com.android.jack.ir.ast.JShortLiteral;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JSwitchStatement;
import com.android.jack.ir.ast.JThrowStatement;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JUnaryOperation;
import com.android.jack.ir.ast.JUnlock;
import com.android.jack.ir.ast.JValueLiteral;
import com.android.jack.ir.ast.JVariableRef;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.types.JIntegralType32;
import com.android.jack.transformations.booleanoperators.FallThroughMarker;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

class RopBuilderVisitor
extends JVisitor {
    @Nonnull
    private final RopRegisterManager ropReg;
    @CheckForNull
    private List<Insn> instructions;
    @CheckForNull
    private List<Insn> extraInstructions;
    @Nonnull
    private final BasicBlock currentBasicBlock;
    private boolean noMoreInstruction = true;

    RopBuilderVisitor(@Nonnull RopRegisterManager ropReg, @Nonnull BasicBlock currentBasicBlock) {
        this.ropReg = ropReg;
        this.currentBasicBlock = currentBasicBlock;
    }

    @CheckForNull
    List<Insn> getInstructions() {
        return this.instructions;
    }

    @CheckForNull
    List<Insn> getExtraInstructions() {
        return this.extraInstructions;
    }

    public void accept(@Nonnull List<JStatement> list) {
        this.instructions = new LinkedList<Insn>();
        this.extraInstructions = new LinkedList<Insn>();
        this.noMoreInstruction = false;
        super.accept(list);
    }

    @Override
    public boolean visit(@Nonnull JExpressionStatement exprStmt) {
        JExpression expr = exprStmt.getExpr();
        if (expr instanceof JPolymorphicMethodCall) {
            this.buildInvokePolymorphic(null, (JPolymorphicMethodCall)expr);
        } else if (expr instanceof JMethodCall) {
            this.buildCall(null, (JMethodCall)expr);
        } else if (!(expr instanceof JLocalRef)) {
            if (expr instanceof JBinaryOperation) {
                JBinaryOperation binaryOperation = (JBinaryOperation)expr;
                assert (binaryOperation.getOp() == JBinaryOperator.ASG);
                JExpression lhs = binaryOperation.getLhs();
                assert (lhs instanceof JVariableRef || lhs instanceof JFieldRef || lhs instanceof JArrayRef);
                this.buildAssign(exprStmt, lhs, binaryOperation.getRhs());
            } else {
                throw new AssertionError((Object)(exprStmt.toSource() + " not yet supported."));
            }
        }
        return false;
    }

    @Override
    public boolean visit(@Nonnull JIfStatement ifStmt) {
        Rop ifOp;
        RegisterSpecList sources;
        SourcePosition ifStmtSrcPos;
        block18: {
            JBinaryOperator op;
            block17: {
                RegisterSpec sourceReg;
                JExpression condExpr = ifStmt.getIfExpr();
                ifStmtSrcPos = RopHelper.getSourcePosition(ifStmt);
                op = null;
                if (condExpr instanceof JBinaryOperation) {
                    JBinaryOperation binCondExpr = (JBinaryOperation)condExpr;
                    JExpression right = binCondExpr.getRhs();
                    RegisterSpec rightReg = this.getRegisterSpec(right);
                    JExpression left = binCondExpr.getLhs();
                    JType type = right.getType();
                    JType leftType = left.getType();
                    assert (leftType.isSameType(type) || leftType instanceof JIntegralType32 && type instanceof JIntegralType32 || leftType instanceof JReferenceType && type instanceof JReferenceType);
                    op = binCondExpr.getOp();
                    RegisterSpec leftReg = this.getRegisterSpec(left);
                    sources = RegisterSpecList.make(leftReg, rightReg);
                    if (type instanceof JPrimitiveType) {
                        switch (((JPrimitiveType)type).getPrimitiveTypeEnum()) {
                            case LONG: 
                            case FLOAT: 
                            case DOUBLE: {
                                RegisterSpec dest = this.ropReg.createRegisterSpec(JPrimitiveType.JPrimitiveTypeEnum.BOOLEAN.getType());
                                Rop cmpOp = null;
                                Type dxType = RopHelper.convertTypeToDx(type);
                                cmpOp = type == JPrimitiveType.JPrimitiveTypeEnum.LONG.getType() ? Rops.opCmpl(dxType) : this.getCmpOperatorForFloatDouble(op, dxType);
                                PlainInsn ifInst = new PlainInsn(cmpOp, ifStmtSrcPos, dest, sources);
                                this.addInstruction(ifInst);
                                sources = RegisterSpecList.make(dest);
                                break;
                            }
                            case BOOLEAN: 
                            case BYTE: 
                            case CHAR: 
                            case SHORT: 
                            case INT: {
                                break;
                            }
                            case VOID: {
                                throw new AssertionError((Object)"Void type not supported.");
                            }
                        }
                    }
                } else if (condExpr instanceof JPrefixNotOperation) {
                    sourceReg = this.getRegisterSpec(((JPrefixNotOperation)condExpr).getArg());
                    sources = RegisterSpecList.make(sourceReg);
                    op = JBinaryOperator.EQ;
                } else {
                    sourceReg = this.getRegisterSpec(condExpr);
                    sources = RegisterSpecList.make(sourceReg);
                    op = JBinaryOperator.NEQ;
                }
                assert (op != null);
                FallThroughMarker ftm = ifStmt.getMarker(FallThroughMarker.class);
                if (ftm == null) break block17;
                switch (ftm.getFallThrough()) {
                    case ELSE: {
                        ifOp = this.getOperatorForIf(op, sources);
                        break block18;
                    }
                    case THEN: {
                        ifOp = this.getReverseOperatorForIf(op, sources);
                        break block18;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            ifOp = this.getReverseOperatorForIf(op, sources);
        }
        assert (ifOp != null);
        PlainInsn ifInst = new PlainInsn(ifOp, ifStmtSrcPos, null, sources);
        this.addInstruction(ifInst);
        return false;
    }

    @Nonnull
    public Rop getCmpOperatorForFloatDouble(@Nonnull JBinaryOperator op, @Nonnull Type type) {
        assert (type == Type.FLOAT || type == Type.DOUBLE);
        switch (op) {
            case LTE: 
            case LT: {
                return Rops.opCmpg(type);
            }
            case GT: 
            case GTE: 
            case EQ: 
            case NEQ: {
                return Rops.opCmpl(type);
            }
        }
        throw new AssertionError((Object)("Operator " + op.toString() + " not yet supported into IfStmt."));
    }

    @Nonnull
    public Rop getOperatorForIf(@Nonnull JBinaryOperator op, @Nonnull RegisterSpecList sources) {
        switch (op) {
            case LT: {
                return Rops.opIfLt(sources);
            }
            case GT: {
                return Rops.opIfGt(sources);
            }
            case LTE: {
                return Rops.opIfLe(sources);
            }
            case GTE: {
                return Rops.opIfGe(sources);
            }
            case EQ: {
                return Rops.opIfEq(sources);
            }
            case NEQ: {
                return Rops.opIfNe(sources);
            }
        }
        throw new AssertionError((Object)("Operator " + op.toString() + " not yet supported into IfStmt."));
    }

    @Nonnull
    public Rop getReverseOperatorForIf(@Nonnull JBinaryOperator op, @Nonnull RegisterSpecList sources) {
        switch (op) {
            case LT: {
                return Rops.opIfGe(sources);
            }
            case GT: {
                return Rops.opIfLe(sources);
            }
            case LTE: {
                return Rops.opIfGt(sources);
            }
            case GTE: {
                return Rops.opIfLt(sources);
            }
            case EQ: {
                return Rops.opIfNe(sources);
            }
            case NEQ: {
                return Rops.opIfEq(sources);
            }
        }
        throw new AssertionError((Object)("Operator " + op.toString() + " not yet supported into IfStmt."));
    }

    @Override
    public boolean visit(@Nonnull JReturnStatement retStmt) {
        JExpression returnedExpr = retStmt.getExpr();
        RegisterSpecList sources = returnedExpr != null ? RegisterSpecList.make(this.getRegisterSpec(returnedExpr)) : RegisterSpecList.EMPTY;
        PlainInsn retInst = new PlainInsn(Rops.opReturn(RopHelper.convertTypeToDx(returnedExpr == null ? JPrimitiveType.JPrimitiveTypeEnum.VOID.getType() : returnedExpr.getType())), RopHelper.getSourcePosition(retStmt), null, sources);
        this.addInstruction(retInst);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JSwitchStatement jswitch) {
        assert (this.currentBasicBlock instanceof SwitchBasicBlock);
        SourcePosition switchStmtSrcPos = RopHelper.getSourcePosition(jswitch);
        IntList cases = new IntList();
        for (BasicBlock caseBb : ((SwitchBasicBlock)this.currentBasicBlock).getCasesBlock()) {
            JStatement firstStatement = caseBb.getStatements().get(0);
            assert (firstStatement instanceof JCaseStatement);
            JLiteral caseValue = ((JCaseStatement)firstStatement).getExpr();
            if (caseValue instanceof JIntLiteral) {
                cases.add(((JIntLiteral)caseValue).getValue());
                continue;
            }
            if (caseValue instanceof JCharLiteral) {
                cases.add(((JCharLiteral)caseValue).getValue());
                continue;
            }
            if (caseValue instanceof JShortLiteral) {
                cases.add(((JShortLiteral)caseValue).getValue());
                continue;
            }
            if (caseValue instanceof JByteLiteral) {
                cases.add(((JByteLiteral)caseValue).getValue());
                continue;
            }
            throw new AssertionError((Object)"Unsupported value");
        }
        RegisterSpecList sources = RegisterSpecList.make(this.getRegisterSpec(jswitch.getExpr()));
        SwitchInsn switchInst = new SwitchInsn(Rops.SWITCH, switchStmtSrcPos, null, sources, cases);
        this.addInstruction(switchInst);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JThrowStatement throwStmt) {
        ThrowingInsn throwInsn = new ThrowingInsn(Rops.THROW, RopHelper.getSourcePosition(throwStmt), RegisterSpecList.make(this.getRegisterSpec(throwStmt.getExpr())), this.getCatchTypes());
        this.addInstruction(throwInsn);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JLock lockStmt) {
        SourcePosition srcPosition = RopHelper.getSourcePosition(lockStmt);
        RegisterSpec lockReg = this.getRegisterSpec(lockStmt.getLockExpr());
        ThrowingInsn lockInsn = new ThrowingInsn(Rops.MONITOR_ENTER, srcPosition, RegisterSpecList.make(lockReg), this.getCatchTypes());
        this.addInstruction(lockInsn);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JUnlock unlockStmt) {
        RegisterSpec unlockReg = this.getRegisterSpec(unlockStmt.getLockExpr());
        ThrowingInsn unlockInsn = new ThrowingInsn(Rops.MONITOR_EXIT, RopHelper.getSourcePosition(unlockStmt), RegisterSpecList.make(unlockReg), this.getCatchTypes());
        this.addInstruction(unlockInsn);
        return false;
    }

    private void buildAlloc(@Nonnull RegisterSpec destReg, @Nonnull JAlloc alloc, @Nonnull SourcePosition sourcePosition) {
        CstType type = RopHelper.getCstType(alloc.getInstanceType());
        Rop rop = Rops.NEW_INSTANCE;
        this.addInstruction(new ThrowingCstInsn(rop, sourcePosition, RegisterSpecList.EMPTY, this.getCatchTypes(), (Constant)type));
        this.addMoveResultPseudoAsExtraInstruction(destReg, sourcePosition);
    }

    private void buildAssign(@Nonnull JStatement declaration, @Nonnull JExpression dest, @Nonnull JExpression value) throws AssertionError {
        if (value instanceof JExceptionRuntimeValue) {
            assert (dest instanceof JVariableRef);
            assert (declaration.getParent() instanceof JCatchBlock && ((JCatchBlock)declaration.getParent()).getStatements().get(0) == declaration);
            RegisterSpec exceptionReg = this.ropReg.getOrCreateRegisterSpec((JVariableRef)dest);
            this.addInstruction(new PlainInsn(Rops.opMoveException(exceptionReg.getTypeBearer()), RopHelper.getSourcePosition(dest), exceptionReg, RegisterSpecList.EMPTY));
        } else if (dest instanceof JFieldRef) {
            this.buildWriteField((JFieldRef)dest, value, RopHelper.getSourcePosition(declaration));
        } else if (dest instanceof JArrayRef) {
            this.buildArrayWrite((JArrayRef)dest, value, RopHelper.getSourcePosition(declaration));
        } else {
            assert (dest instanceof JVariableRef);
            JVariableRef destRef = (JVariableRef)dest;
            AssignBuilderVisitor rhsHandler = new AssignBuilderVisitor(declaration, destRef);
            rhsHandler.accept(value);
        }
    }

    private void buildArrayWrite(JArrayRef arrayRef, JExpression value, SourcePosition sourcePosition) {
        assert (arrayRef.getInstance() instanceof JVariableRef || arrayRef.getInstance() instanceof JNullLiteral);
        RegisterSpec valueReg = this.getRegisterSpec(value);
        RegisterSpec instanceReg = this.getRegisterSpec(arrayRef.getInstance());
        RegisterSpec indexReg = this.getRegisterSpec(arrayRef.getIndexExpr());
        RegisterSpecList sources = RegisterSpecList.make(valueReg, instanceReg, indexReg);
        Rop rop = Rops.opAput(RopBuilderVisitor.getComponentType(instanceReg));
        this.addInstruction(new ThrowingInsn(rop, sourcePosition, sources, this.getCatchTypes()));
    }

    private void buildInstanceOf(RegisterSpec destReg, JInstanceOf instanceOf) {
        SourcePosition srcPos = RopHelper.getSourcePosition(instanceOf);
        RegisterSpec regExpr = this.getRegisterSpec(instanceOf.getExpr());
        CstType type = RopHelper.getCstType(instanceOf.getTestType());
        this.addInstruction(new ThrowingCstInsn(Rops.INSTANCE_OF, srcPos, RegisterSpecList.make(regExpr), this.getCatchTypes(), (Constant)type));
        this.addMoveResultPseudoAsExtraInstruction(destReg, srcPos);
    }

    @Nonnull
    private static Type getComponentType(@Nonnull TypeBearer arrayTypeBearer) {
        Type arrayType = arrayTypeBearer.getType();
        if (arrayType.isArray()) {
            return arrayType.getComponentType();
        }
        assert (arrayType.equals(Type.KNOWN_NULL));
        return arrayType.getType();
    }

    private void buildArrayLength(RegisterSpec destReg, JArrayLength value) {
        RegisterSpec reg = this.getRegisterSpec(value.getInstance());
        SourcePosition srcPos = RopHelper.getSourcePosition(value);
        this.addInstruction(new ThrowingInsn(Rops.ARRAY_LENGTH, srcPos, RegisterSpecList.make(reg), this.getCatchTypes()));
        this.addMoveResultPseudoAsExtraInstruction(destReg, srcPos);
    }

    private void buildWriteField(@Nonnull JFieldRef fieldRef, @Nonnull JExpression value, @Nonnull SourcePosition sourcePosition) {
        RegisterSpec valueReg = this.getRegisterSpec(value);
        CstFieldRef cstField = RopHelper.createFieldRef(fieldRef.getFieldId(), fieldRef.getReceiverType());
        if (fieldRef.getFieldId().getKind() == FieldKind.STATIC) {
            Rop rop = Rops.opPutStatic(RopHelper.convertTypeToDx(fieldRef.getType()));
            this.addInstruction(new ThrowingCstInsn(rop, sourcePosition, RegisterSpecList.make(valueReg), this.getCatchTypes(), (Constant)cstField));
        } else {
            JExpression instance = fieldRef.getInstance();
            assert (instance != null);
            assert (instance instanceof JVariableRef || instance instanceof JNullLiteral);
            RegisterSpec instanceReg = this.getRegisterSpec(instance);
            RegisterSpecList sources = RegisterSpecList.make(valueReg, instanceReg);
            Rop rop = Rops.opPutField(RopHelper.convertTypeToDx(fieldRef.getType()));
            this.addInstruction(new ThrowingCstInsn(rop, sourcePosition, sources, this.getCatchTypes(), (Constant)cstField));
        }
    }

    private void buildCast(@Nonnull RegisterSpec destReg, @Nonnull JDynamicCastOperation cast) {
        JExpression from = cast.getExpr();
        SourcePosition sourcePosition = RopHelper.getSourcePosition(cast);
        RegisterSpec fromReg = this.getRegisterSpec(from);
        JType castTo = cast.getType();
        JType castedFrom = from.getType();
        if (castTo instanceof JPrimitiveType) {
            assert (castedFrom instanceof JPrimitiveType);
            if (castTo == castedFrom) {
                RegisterSpecList sources = RegisterSpecList.make(fromReg);
                this.addInstruction(new PlainInsn(Rops.opMove(fromReg.getTypeBearer()), sourcePosition, destReg, sources));
                return;
            }
            if (!(castTo != JPrimitiveType.JPrimitiveTypeEnum.BYTE.getType() && castTo != JPrimitiveType.JPrimitiveTypeEnum.SHORT.getType() && castTo != JPrimitiveType.JPrimitiveTypeEnum.CHAR.getType() && castTo != JPrimitiveType.JPrimitiveTypeEnum.INT.getType() && castTo != JPrimitiveType.JPrimitiveTypeEnum.BOOLEAN.getType() || castedFrom != JPrimitiveType.JPrimitiveTypeEnum.INT.getType() && castedFrom != JPrimitiveType.JPrimitiveTypeEnum.BYTE.getType() && castedFrom != JPrimitiveType.JPrimitiveTypeEnum.CHAR.getType() && castedFrom != JPrimitiveType.JPrimitiveTypeEnum.SHORT.getType() && castedFrom != JPrimitiveType.JPrimitiveTypeEnum.BOOLEAN.getType())) {
                this.addTruncateIntOrMoveInstruction(sourcePosition, ((JPrimitiveType)castTo).getPrimitiveTypeEnum(), fromReg, destReg);
            } else {
                PlainInsn inst = new PlainInsn(Rops.opConv(destReg, fromReg), sourcePosition, destReg, RegisterSpecList.make(fromReg));
                this.addInstruction(inst);
            }
        } else {
            RegisterSpecList sources = RegisterSpecList.make(fromReg);
            ThrowingCstInsn insn = new ThrowingCstInsn(Rops.CHECK_CAST, sourcePosition, sources, this.getCatchTypes(), (Constant)RopHelper.getCstType(castTo));
            this.addInstruction(insn);
            this.addMoveResultPseudoAsExtraInstruction(destReg, sourcePosition);
        }
    }

    private void addTruncateIntOrMoveInstruction(@Nonnull SourcePosition sourcePosition, @Nonnull JPrimitiveType.JPrimitiveTypeEnum castTo, @Nonnull RegisterSpec fromReg, @CheckForNull RegisterSpec destReg) throws AssertionError {
        Rop rop;
        switch (castTo) {
            case BYTE: {
                rop = Rops.TO_BYTE;
                break;
            }
            case CHAR: {
                rop = Rops.TO_CHAR;
                break;
            }
            case SHORT: {
                rop = Rops.TO_SHORT;
                break;
            }
            case BOOLEAN: 
            case INT: {
                rop = Rops.MOVE_INT;
                break;
            }
            default: {
                throw new AssertionError((Object)((Object)((Object)castTo) + " not supported"));
            }
        }
        RegisterSpecList sources = RegisterSpecList.make(fromReg);
        PlainInsn inst = new PlainInsn(rop, sourcePosition, destReg, sources);
        this.addInstruction(inst);
    }

    @Nonnull
    private Constant buildPrimitiveConstant(@Nonnull JValueLiteral literal) {
        CstLiteralBits cst = null;
        assert (literal.getType() instanceof JPrimitiveType);
        JPrimitiveType.JPrimitiveTypeEnum primitiveType = ((JPrimitiveType)literal.getType()).getPrimitiveTypeEnum();
        switch (primitiveType) {
            case BOOLEAN: {
                cst = CstInteger.make(((JBooleanLiteral)literal).getValue() ? 1 : 0);
                break;
            }
            case BYTE: {
                cst = CstInteger.make(((JByteLiteral)literal).getValue());
                break;
            }
            case CHAR: {
                cst = CstInteger.make(((JCharLiteral)literal).getValue());
                break;
            }
            case DOUBLE: {
                cst = CstDouble.make(Double.doubleToLongBits(((JDoubleLiteral)literal).getValue()));
                break;
            }
            case FLOAT: {
                cst = CstFloat.make(Float.floatToIntBits(((JFloatLiteral)literal).getValue()));
                break;
            }
            case INT: {
                cst = CstInteger.make(((JIntLiteral)literal).getValue());
                break;
            }
            case LONG: {
                cst = CstLong.make(((JLongLiteral)literal).getValue());
                break;
            }
            case SHORT: {
                cst = CstInteger.make(((JShortLiteral)literal).getValue());
                break;
            }
            case VOID: {
                throw new AssertionError((Object)(literal.toSource() + " not supported."));
            }
        }
        assert (cst != null);
        return cst;
    }

    @Nonnull
    private Constant getConstant(@Nonnull JValueLiteral literal) {
        Constant cst = null;
        JType type = literal.getType();
        if (type instanceof JPrimitiveType) {
            cst = this.buildPrimitiveConstant(literal);
        } else if (literal instanceof JAbstractStringLiteral) {
            cst = RopHelper.createString((JAbstractStringLiteral)literal);
        } else if (literal instanceof JNullLiteral) {
            cst = CstKnownNull.THE_ONE;
        } else {
            throw new AssertionError((Object)(literal.toSource() + " not supported."));
        }
        return cst;
    }

    private void buildConstant(@Nonnull RegisterSpec destReg, @Nonnull JValueLiteral literal) {
        JType type = literal.getType();
        Rop constOp = Rops.opConst(RopHelper.convertTypeToDx(type));
        SourcePosition sourcePosition = RopHelper.getSourcePosition(literal);
        if (type instanceof JPrimitiveType) {
            PlainCstInsn constInst = new PlainCstInsn(constOp, sourcePosition, destReg, RegisterSpecList.EMPTY, this.getConstant(literal));
            this.addInstruction(constInst);
        } else if (literal instanceof JAbstractStringLiteral) {
            ThrowingCstInsn constInst = new ThrowingCstInsn(constOp, sourcePosition, RegisterSpecList.EMPTY, this.getCatchTypes(), this.getConstant(literal));
            this.addInstruction(constInst);
            this.addMoveResultPseudoAsExtraInstruction(destReg, sourcePosition);
        } else if (literal instanceof JNullLiteral) {
            PlainCstInsn constInst = new PlainCstInsn(constOp, sourcePosition, destReg, RegisterSpecList.EMPTY, this.getConstant(literal));
            this.addInstruction(constInst);
        } else {
            throw new AssertionError((Object)(literal.toSource() + " not supported."));
        }
    }

    private void buildUnaryOperation(@Nonnull RegisterSpec destReg, @Nonnull JUnaryOperation unary) {
        SourcePosition unarySrcPos = RopHelper.getSourcePosition(unary);
        RegisterSpec srcRegisterSpec = this.getRegisterSpec(unary.getArg());
        RegisterSpecList sources = RegisterSpecList.make(srcRegisterSpec);
        Rop opcode = null;
        switch (unary.getOp()) {
            case NEG: {
                assert (unary.getType() == JPrimitiveType.JPrimitiveTypeEnum.BYTE.getType() || unary.getType() == JPrimitiveType.JPrimitiveTypeEnum.CHAR.getType() || unary.getType() == JPrimitiveType.JPrimitiveTypeEnum.SHORT.getType() || unary.getType() == JPrimitiveType.JPrimitiveTypeEnum.INT.getType() || unary.getType() == JPrimitiveType.JPrimitiveTypeEnum.LONG.getType() || unary.getType() == JPrimitiveType.JPrimitiveTypeEnum.FLOAT.getType() || unary.getType() == JPrimitiveType.JPrimitiveTypeEnum.DOUBLE.getType());
                opcode = Rops.opNeg(srcRegisterSpec);
                break;
            }
            case BIT_NOT: {
                assert (unary.getType() == JPrimitiveType.JPrimitiveTypeEnum.BYTE.getType() || unary.getType() == JPrimitiveType.JPrimitiveTypeEnum.CHAR.getType() || unary.getType() == JPrimitiveType.JPrimitiveTypeEnum.SHORT.getType() || unary.getType() == JPrimitiveType.JPrimitiveTypeEnum.INT.getType() || unary.getType() == JPrimitiveType.JPrimitiveTypeEnum.LONG.getType());
                opcode = Rops.opNot(srcRegisterSpec);
                break;
            }
            case NOT: {
                assert (unary.getType() == JPrimitiveType.JPrimitiveTypeEnum.BOOLEAN.getType());
                this.addInstruction(new PlainCstInsn(Rops.opXor(sources), unarySrcPos, destReg, sources, CstBoolean.make(true)));
                return;
            }
            default: {
                throw new AssertionError((Object)"Unary operation not supported.");
            }
        }
        this.addInstruction(new PlainInsn(opcode, unarySrcPos, destReg, sources));
    }

    private void buildBinaryOperation(@Nonnull RegisterSpec destReg, @Nonnull JBinaryOperation binary) {
        Rop opcode;
        RegisterSpecList sources;
        SourcePosition declarationSrcPos = RopHelper.getSourcePosition(binary);
        Constant cst = null;
        JBinaryOperator binOp = binary.getOp();
        JExpression rhs = binary.getRhs();
        JExpression lhs = binary.getLhs();
        if (lhs instanceof JVariableRef && binary.getType() instanceof JIntegralType32 && rhs instanceof JIntegralConstant32 && ((JIntegralType32)((Object)JPrimitiveType.JPrimitiveTypeEnum.SHORT.getType())).isValidValue(((JIntegralConstant32)((Object)rhs)).getIntValue())) {
            assert (rhs instanceof JValueLiteral);
            if (binOp == JBinaryOperator.SUB) {
                int newCst = -((JIntegralConstant32)((Object)rhs)).getIntValue();
                if (((JIntegralType32)((Object)JPrimitiveType.JPrimitiveTypeEnum.SHORT.getType())).isValidValue(newCst)) {
                    binOp = JBinaryOperator.ADD;
                    sources = RegisterSpecList.make(this.ropReg.getOrCreateRegisterSpec((JVariableRef)lhs));
                    cst = CstInteger.make(newCst);
                } else {
                    sources = RegisterSpecList.make(this.getRegisterSpec(lhs), this.getRegisterSpec(rhs));
                }
            } else {
                sources = RegisterSpecList.make(this.ropReg.getOrCreateRegisterSpec((JVariableRef)lhs));
                cst = this.getConstant((JValueLiteral)rhs);
            }
        } else if (rhs instanceof JVariableRef) {
            if (binOp == JBinaryOperator.SUB && lhs instanceof JIntegralConstant32 && ((JIntegralType32)((Object)JPrimitiveType.JPrimitiveTypeEnum.SHORT.getType())).isValidValue(((JIntegralConstant32)((Object)lhs)).getIntValue())) {
                sources = RegisterSpecList.make(this.ropReg.getOrCreateRegisterSpec((JVariableRef)rhs));
                cst = this.getConstant((JValueLiteral)lhs);
            } else {
                sources = RegisterSpecList.make(this.getRegisterSpec(lhs), this.ropReg.getOrCreateRegisterSpec((JVariableRef)rhs));
            }
        } else {
            assert (rhs instanceof JValueLiteral);
            sources = RegisterSpecList.make(this.getRegisterSpec(lhs), this.getRegisterSpec(rhs));
        }
        switch (binOp) {
            case ADD: {
                opcode = Rops.opAdd(sources);
                break;
            }
            case SUB: {
                opcode = Rops.opSub(sources);
                break;
            }
            case LTE: 
            case LT: 
            case GT: 
            case GTE: 
            case EQ: 
            case NEQ: 
            case ASG: 
            case ASG_ADD: 
            case ASG_BIT_AND: 
            case ASG_BIT_OR: 
            case ASG_BIT_XOR: 
            case ASG_CONCAT: 
            case ASG_DIV: 
            case ASG_MOD: 
            case ASG_MUL: 
            case ASG_SHL: 
            case ASG_SHR: 
            case ASG_SHRU: 
            case ASG_SUB: 
            case OR: 
            case AND: {
                throw new AssertionError();
            }
            case BIT_AND: {
                opcode = Rops.opAnd(sources);
                break;
            }
            case BIT_OR: {
                opcode = Rops.opOr(sources);
                break;
            }
            case BIT_XOR: {
                opcode = Rops.opXor(sources);
                break;
            }
            case DIV: {
                opcode = Rops.opDiv(sources);
                break;
            }
            case MOD: {
                opcode = Rops.opRem(sources);
                break;
            }
            case MUL: {
                opcode = Rops.opMul(sources);
                break;
            }
            case SHL: {
                opcode = Rops.opShl(sources);
                if (opcode.equals(Rops.SHL_CONST_INT)) {
                    assert (cst != null);
                    CstLiteral32 lit = (CstLiteral32)cst;
                    cst = CstInteger.make(lit.getIntBits() & 0x1F);
                    break;
                }
                if (!opcode.equals(Rops.SHL_CONST_LONG)) break;
                assert (cst != null);
                CstLiteral64 lit = (CstLiteral64)cst;
                cst = CstInteger.make(lit.getIntBits() & 0x3F);
                break;
            }
            case SHR: {
                opcode = Rops.opShr(sources);
                if (opcode.equals(Rops.SHR_CONST_INT)) {
                    assert (cst != null);
                    CstLiteral32 lit = (CstLiteral32)cst;
                    cst = CstInteger.make(lit.getIntBits() & 0x1F);
                    break;
                }
                if (!opcode.equals(Rops.SHR_CONST_LONG)) break;
                assert (cst != null);
                CstLiteral64 lit = (CstLiteral64)cst;
                cst = CstInteger.make(lit.getIntBits() & 0x3F);
                break;
            }
            case SHRU: {
                opcode = Rops.opUshr(sources);
                if (opcode.equals(Rops.USHR_CONST_INT)) {
                    assert (cst != null);
                    CstLiteral32 lit = (CstLiteral32)cst;
                    cst = CstInteger.make(lit.getIntBits() & 0x1F);
                    break;
                }
                if (!opcode.equals(Rops.USHR_CONST_LONG)) break;
                assert (cst != null);
                CstLiteral64 lit = (CstLiteral64)cst;
                cst = CstInteger.make(lit.getIntBits() & 0x3F);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (opcode.canThrow()) {
            if (cst == null) {
                this.addInstruction(new ThrowingInsn(opcode, declarationSrcPos, sources, this.getCatchTypes()));
            } else {
                this.addInstruction(new ThrowingCstInsn(opcode, declarationSrcPos, sources, this.getCatchTypes(), cst));
            }
            this.addMoveResultPseudoAsExtraInstruction(destReg, declarationSrcPos);
        } else if (cst == null) {
            this.addInstruction(new PlainInsn(opcode, declarationSrcPos, destReg, sources));
        } else {
            this.addInstruction(new PlainCstInsn(opcode, declarationSrcPos, destReg, sources, cst));
        }
    }

    private void buildInvokePolymorphic(@CheckForNull RegisterSpec result, @Nonnull JPolymorphicMethodCall methodCall) {
        CstType definingClass = RopHelper.getCstType(methodCall.getReceiverType());
        String signatureWithoutName = RopHelper.getMethodSignatureWithoutName(methodCall);
        CstNat nat = new CstNat(new CstString(methodCall.getMethodName()), new CstString(signatureWithoutName));
        CstMethodRef methodRef = new CstMethodRef(definingClass, nat);
        SourcePosition methodCallSrcPos = RopHelper.getSourcePosition(methodCall);
        Prototype prototype = Prototype.intern(RopHelper.getPolymorphicCallSiteSymbolicDescriptor(methodCall));
        Rop callOp = Rops.opInvokePolymorphic(prototype);
        RegisterSpecList sources = new RegisterSpecList(1 + methodCall.getArgs().size());
        JExpression instance = methodCall.getInstance();
        assert (instance != null);
        int paramIndex = 0;
        sources.set(paramIndex++, this.getRegisterSpec(instance));
        for (JExpression exprArg : methodCall.getArgs()) {
            sources.set(paramIndex++, this.getRegisterSpec(exprArg));
        }
        ThrowingDualCstInsn callInst = new ThrowingDualCstInsn(callOp, methodCallSrcPos, sources, this.getCatchTypes(), (Constant)methodRef, (Constant)new CstPrototypeRef(prototype));
        this.addInstruction(callInst);
        if (result != null) {
            this.addMoveResultAsExtraInstruction(prototype.getReturnType(), result, methodCallSrcPos);
        }
    }

    private void buildCall(@CheckForNull RegisterSpec result, @Nonnull JMethodCall methodCall) {
        Rop callOp;
        String signatureWithoutName = RopHelper.getMethodSignatureWithoutName(methodCall);
        SourcePosition methodCallSrcPos = RopHelper.getSourcePosition(methodCall);
        Prototype prototype = Prototype.intern(signatureWithoutName);
        int paramIndex = 0;
        MethodKind methodKind = methodCall.getMethodId().getKind();
        RegisterSpecList sources = methodKind == MethodKind.STATIC ? new RegisterSpecList(methodCall.getArgs().size()) : new RegisterSpecList(1 + methodCall.getArgs().size());
        switch (methodKind) {
            case STATIC: {
                callOp = Rops.opInvokeStatic(prototype);
                break;
            }
            case INSTANCE_NON_VIRTUAL: {
                callOp = Rops.opInvokeDirect(prototype);
                Object instance = methodCall.getInstance();
                assert (instance != null);
                sources.set(paramIndex++, this.getRegisterSpec((JExpression)instance));
                break;
            }
            case INSTANCE_VIRTUAL: {
                Object instance = methodCall.getInstance();
                assert (instance != null);
                RegisterSpec instanceReg = this.getRegisterSpec((JExpression)instance);
                callOp = methodCall.getDispatchKind() == JMethodCall.DispatchKind.DIRECT ? Rops.opInvokeSuper(prototype) : (methodCall.getReceiverType() instanceof JInterface ? Rops.opInvokeInterface(prototype) : Rops.opInvokeVirtual(prototype));
                sources.set(paramIndex++, instanceReg);
                break;
            }
            default: {
                throw new AssertionError((Object)(methodCall.toSource() + " not yet supported."));
            }
        }
        assert (prototype.getParameterTypes().size() == methodCall.getArgs().size());
        for (JExpression exprArg : methodCall.getArgs()) {
            sources.set(paramIndex++, this.getRegisterSpec(exprArg));
        }
        CstMethodRef methodRef = RopHelper.createMethodRef(methodCall);
        ThrowingCstInsn callInst = new ThrowingCstInsn(callOp, methodCallSrcPos, sources, this.getCatchTypes(), (Constant)methodRef);
        this.addInstruction(callInst);
        if (result != null) {
            this.addMoveResultAsExtraInstruction(prototype.getReturnType(), result, methodCallSrcPos);
        }
    }

    @Nonnull
    private RegisterSpec getRegisterSpec(@Nonnull JExpression expr) {
        RegisterSpec regSpec;
        if (expr instanceof JVariableRef) {
            regSpec = this.ropReg.getOrCreateRegisterSpec((JVariableRef)expr);
        } else {
            assert (expr instanceof JValueLiteral);
            regSpec = this.ropReg.getOrCreateTmpRegister(RopHelper.convertTypeToDx(expr.getType()));
            this.buildConstant(regSpec, (JValueLiteral)expr);
        }
        return regSpec;
    }

    private void addMoveResultAsExtraInstruction(@Nonnull TypeBearer type, @Nonnull RegisterSpec destReg, @Nonnull SourcePosition sourcePosition) {
        Rop moveResultOp = Rops.opMoveResult(type);
        PlainInsn moveResultInst = new PlainInsn(moveResultOp, sourcePosition, destReg, RegisterSpecList.EMPTY);
        this.addExtraInstruction(moveResultInst);
    }

    private void addMoveResultPseudoAsExtraInstruction(@Nonnull RegisterSpec destReg, @Nonnull SourcePosition sourcePosition) {
        PlainInsn moveResult = new PlainInsn(Rops.opMoveResultPseudo(destReg.getTypeBearer()), sourcePosition, destReg, RegisterSpecList.EMPTY);
        this.addExtraInstruction(moveResult);
    }

    private void addExtraInstruction(@Nonnull Insn insn) {
        assert (this.extraInstructions != null);
        this.extraInstructions.add(insn);
        this.noMoreInstruction = true;
    }

    private boolean addInstruction(@Nonnull Insn insn) {
        assert (this.instructions != null);
        assert (!this.noMoreInstruction);
        return this.instructions.add(insn);
    }

    private TypeList getCatchTypes() {
        assert (this.currentBasicBlock instanceof PeiBasicBlock);
        PeiBasicBlock peiBlock = (PeiBasicBlock)this.currentBasicBlock;
        ArrayList<JClass> catchTypes = new ArrayList<JClass>();
        for (CatchBasicBlock bb : peiBlock.getExceptionBlocks()) {
            for (JClass catchType : bb.getCatchTypes()) {
                catchTypes.add(catchType);
            }
        }
        if (catchTypes.isEmpty()) {
            return StdTypeList.EMPTY;
        }
        return RopHelper.createTypeList(catchTypes);
    }

    @Override
    public void endVisit(@Nonnull JStatement x) {
        this.ropReg.resetFreeTmpRegister();
    }

    private class AssignBuilderVisitor
    extends JVisitor {
        @Nonnull
        private final JStatement declaration;
        @Nonnull
        private final RegisterSpec destReg;
        @Nonnull
        SourcePosition sourcePosition;

        public AssignBuilderVisitor(@Nonnull JStatement declaration, JVariableRef destRef) {
            this.declaration = declaration;
            this.destReg = RopBuilderVisitor.this.ropReg.getOrCreateRegisterSpec(destRef);
            this.sourcePosition = RopHelper.getSourcePosition(declaration);
        }

        @Override
        public boolean visit(@Nonnull JNode node) {
            throw new AssertionError((Object)(this.declaration.toSource() + " not yet supported."));
        }

        @Override
        public boolean visit(@Nonnull JAlloc alloc) {
            RopBuilderVisitor.this.buildAlloc(this.destReg, alloc, this.sourcePosition);
            return false;
        }

        @Override
        public boolean visit(@Nonnull JArrayLength arrayLength) {
            RopBuilderVisitor.this.buildArrayLength(this.destReg, arrayLength);
            return false;
        }

        @Override
        public boolean visit(@Nonnull JArrayRef arrayRef) {
            this.buildArrayRead(this.destReg, arrayRef, this.sourcePosition);
            return false;
        }

        @Override
        public boolean visit(@Nonnull JBinaryOperation binOp) {
            RopBuilderVisitor.this.buildBinaryOperation(this.destReg, binOp);
            return false;
        }

        @Override
        public boolean visit(@Nonnull JReinterpretCastOperation cast) {
            SourcePosition sourcePosition = RopHelper.getSourcePosition(cast);
            RegisterSpec fromReg = RopBuilderVisitor.this.getRegisterSpec(cast.getExpr());
            RegisterSpecList sources = RegisterSpecList.make(fromReg);
            RopBuilderVisitor.this.addInstruction(new PlainInsn(Rops.opMove(fromReg.getTypeBearer()), sourcePosition, this.destReg, sources));
            return false;
        }

        @Override
        public boolean visit(@Nonnull JDynamicCastOperation cast) {
            RopBuilderVisitor.this.buildCast(this.destReg, cast);
            return false;
        }

        @Override
        public boolean visit(@Nonnull JFieldRef fieldRef) {
            this.buildReadField(this.destReg, fieldRef, this.sourcePosition);
            return false;
        }

        @Override
        public boolean visit(@Nonnull JInstanceOf instanceOf) {
            RopBuilderVisitor.this.buildInstanceOf(this.destReg, instanceOf);
            return false;
        }

        @Override
        public boolean visit(@Nonnull JLambda lambda) {
            throw new AssertionError();
        }

        @Override
        public boolean visit(@Nonnull JPolymorphicMethodCall methodCall) {
            RopBuilderVisitor.this.buildInvokePolymorphic(this.destReg, methodCall);
            return false;
        }

        @Override
        public boolean visit(@Nonnull JMethodCall call) {
            RopBuilderVisitor.this.buildCall(this.destReg, call);
            return false;
        }

        @Override
        public boolean visit(@Nonnull JVariableRef varRef) {
            RegisterSpec valueReg = RopBuilderVisitor.this.ropReg.getOrCreateRegisterSpec(varRef);
            RegisterSpecList sources = RegisterSpecList.make(valueReg);
            RopBuilderVisitor.this.addInstruction(new PlainInsn(Rops.opMove(valueReg.getTypeBearer()), this.sourcePosition, this.destReg, sources));
            return false;
        }

        @Override
        public boolean visit(@Nonnull JUnaryOperation unaryOp) {
            RopBuilderVisitor.this.buildUnaryOperation(this.destReg, unaryOp);
            return false;
        }

        @Override
        public boolean visit(@Nonnull JValueLiteral valueLit) {
            RopBuilderVisitor.this.buildConstant(this.destReg, valueLit);
            return false;
        }

        @Override
        public boolean visit(@Nonnull JClassLiteral literal) {
            CstType cst = RopHelper.getCstType(literal.getRefType());
            JType type = literal.getType();
            Rop constOp = Rops.opConst(RopHelper.convertTypeToDx(type));
            SourcePosition literalSrcPos = RopHelper.getSourcePosition(literal);
            ThrowingCstInsn constInst = new ThrowingCstInsn(constOp, literalSrcPos, RegisterSpecList.EMPTY, RopBuilderVisitor.this.getCatchTypes(), (Constant)cst);
            RopBuilderVisitor.this.addInstruction(constInst);
            RopBuilderVisitor.this.addMoveResultPseudoAsExtraInstruction(this.destReg, literalSrcPos);
            return false;
        }

        private boolean isDexFilledNewArrayCompatible(@Nonnull JNewArray newArray) {
            JType elementType = newArray.getArrayType().getElementType();
            List<JExpression> initializers = newArray.getInitializers();
            return !initializers.isEmpty() && initializers.size() <= 5 && newArray.getDims().size() == 1 && elementType == JPrimitiveType.JPrimitiveTypeEnum.INT.getType();
        }

        @Override
        public boolean visit(@Nonnull JNewArray newArray) {
            JArrayType type = newArray.getType();
            CstType cstType = RopHelper.getCstType(type);
            SourcePosition newArraySourcePosition = RopHelper.getSourcePosition(newArray);
            List<JExpression> valuesSize = newArray.getInitializers();
            if (this.isDexFilledNewArrayCompatible(newArray)) {
                int i = 0;
                RegisterSpecList sources = new RegisterSpecList(valuesSize.size());
                for (JExpression expr : valuesSize) {
                    sources.set(i++, RopBuilderVisitor.this.getRegisterSpec(expr));
                }
                Type arrayType = RopHelper.convertTypeToDx(newArray.getType());
                Rop op = Rops.opFilledNewArray(arrayType, valuesSize.size());
                ThrowingCstInsn insn = new ThrowingCstInsn(op, newArraySourcePosition, sources, RopBuilderVisitor.this.getCatchTypes(), (Constant)cstType);
                RopBuilderVisitor.this.addInstruction(insn);
                RopBuilderVisitor.this.addMoveResultAsExtraInstruction(arrayType, this.destReg, newArraySourcePosition);
            } else {
                List<JExpression> dims = newArray.getDims();
                assert (dims.size() >= 1);
                assert (this.isDexNewArrayCompatible(newArray));
                RegisterSpecList sources = RegisterSpecList.make(RopBuilderVisitor.this.getRegisterSpec(dims.get(0)));
                Rop op = Rops.opNewArray(cstType.getClassType());
                Insn insn = new ThrowingCstInsn(op, newArraySourcePosition, sources, RopBuilderVisitor.this.getCatchTypes(), (Constant)cstType);
                RopBuilderVisitor.this.addInstruction(insn);
                RopBuilderVisitor.this.addMoveResultPseudoAsExtraInstruction(this.destReg, newArraySourcePosition);
                if (!newArray.getInitializers().isEmpty()) {
                    assert (newArray.hasConstantInitializer());
                    ArrayList<Constant> initValues = new ArrayList<Constant>();
                    for (JExpression initializer : newArray.getInitializers()) {
                        initValues.add(RopBuilderVisitor.this.buildPrimitiveConstant((JValueLiteral)initializer));
                    }
                    insn = new FillArrayDataInsn(Rops.FILL_ARRAY_DATA, newArraySourcePosition, RegisterSpecList.make(this.destReg), initValues, cstType);
                    RopBuilderVisitor.this.addExtraInstruction(insn);
                }
            }
            return false;
        }

        private boolean isDexNewArrayCompatible(JNewArray newArray) {
            List<JExpression> dims = newArray.getDims();
            if (dims.size() < 1) {
                return false;
            }
            Iterator<JExpression> iter = dims.iterator();
            if (iter.next() instanceof JAbsentArrayDimension) {
                return false;
            }
            while (iter.hasNext()) {
                if (iter.next() instanceof JAbsentArrayDimension) continue;
                return false;
            }
            return true;
        }

        private void buildArrayRead(@Nonnull RegisterSpec destReg, @Nonnull JArrayRef arrayRef, @Nonnull SourcePosition sourcePosition) {
            assert (arrayRef.getInstance() instanceof JVariableRef || arrayRef.getInstance() instanceof JNullLiteral);
            RegisterSpec instanceReg = RopBuilderVisitor.this.getRegisterSpec(arrayRef.getInstance());
            RegisterSpec indexReg = RopBuilderVisitor.this.getRegisterSpec(arrayRef.getIndexExpr());
            RegisterSpecList sources = RegisterSpecList.make(instanceReg, indexReg);
            Rop rop = Rops.opAget(RopBuilderVisitor.getComponentType(instanceReg));
            RopBuilderVisitor.this.addInstruction(new ThrowingInsn(rop, sourcePosition, sources, RopBuilderVisitor.this.getCatchTypes()));
            RopBuilderVisitor.this.addMoveResultPseudoAsExtraInstruction(destReg, sourcePosition);
        }

        private void buildReadField(@Nonnull RegisterSpec destReg, @Nonnull JFieldRef fieldRef, @Nonnull SourcePosition sourcePosition) {
            CstFieldRef cstField = RopHelper.createFieldRef(fieldRef.getFieldId(), fieldRef.getReceiverType());
            Type ropFieldType = RopHelper.convertTypeToDx(fieldRef.getType());
            if (fieldRef.getFieldId().getKind() == FieldKind.STATIC) {
                Rop rop = Rops.opGetStatic(ropFieldType);
                RopBuilderVisitor.this.addInstruction(new ThrowingCstInsn(rop, sourcePosition, RegisterSpecList.EMPTY, RopBuilderVisitor.this.getCatchTypes(), (Constant)cstField));
            } else {
                JExpression instance = fieldRef.getInstance();
                assert (instance != null);
                assert (instance instanceof JVariableRef || instance instanceof JNullLiteral);
                RegisterSpec instanceReg = RopBuilderVisitor.this.getRegisterSpec(instance);
                RegisterSpecList sources = RegisterSpecList.make(instanceReg);
                Rop rop = Rops.opGetField(ropFieldType);
                RopBuilderVisitor.this.addInstruction(new ThrowingCstInsn(rop, sourcePosition, sources, RopBuilderVisitor.this.getCatchTypes(), (Constant)cstField));
            }
            RopBuilderVisitor.this.addMoveResultPseudoAsExtraInstruction(destReg, sourcePosition);
        }
    }
}

