/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex;

import com.android.jack.ir.ast.HasType;
import com.android.jack.ir.ast.JArrayLiteral;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassLiteral;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedInterface;
import com.android.jack.ir.ast.JDynamicCastOperation;
import com.android.jack.ir.ast.JFieldRef;
import com.android.jack.ir.ast.JInstanceOf;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.marker.ThrownExceptionMarker;
import javax.annotation.Nonnull;

public abstract class TypeReferenceCollector
extends JVisitor {
    protected abstract void collect(@Nonnull JType var1);

    @Override
    public boolean visit(@Nonnull JDefinedClass definedClass) {
        JClass superClass = definedClass.getSuperClass();
        if (superClass != null) {
            this.collect(superClass);
        }
        for (JInterface interf : definedClass.getImplements()) {
            this.collect(interf);
        }
        return super.visit(definedClass);
    }

    @Override
    public boolean visit(@Nonnull JMethod jmethod) {
        ThrownExceptionMarker marker = jmethod.getMarker(ThrownExceptionMarker.class);
        if (marker != null) {
            for (JClass exception : marker.getThrownExceptions()) {
                this.collect(exception);
            }
        }
        return super.visit(jmethod);
    }

    @Override
    public boolean visit(@Nonnull JDefinedInterface definedInterface) {
        for (JInterface interf : definedInterface.getImplements()) {
            this.collect(interf);
        }
        return super.visit(definedInterface);
    }

    @Override
    public boolean visit(@Nonnull JClassLiteral classLiteral) {
        this.collect(classLiteral.getRefType());
        return super.visit(classLiteral);
    }

    @Override
    public boolean visit(@Nonnull JInstanceOf instanceofStmt) {
        this.collect(instanceofStmt.getTestType());
        return super.visit(instanceofStmt);
    }

    @Override
    public boolean visit(@Nonnull JMethodCall methodCall) {
        this.collect(methodCall.getReceiverType());
        return super.visit(methodCall);
    }

    @Override
    public boolean visit(@Nonnull JFieldRef fieldRef) {
        this.collect(fieldRef.getReceiverType());
        return super.visit(fieldRef);
    }

    @Override
    public boolean visit(@Nonnull JDynamicCastOperation multiCast) {
        for (JType type : multiCast.getTypes()) {
            this.collect(type);
        }
        return false;
    }

    @Override
    public boolean visit(@Nonnull JNode node) {
        if (node instanceof HasType && !(node instanceof JArrayLiteral)) {
            this.collect(((HasType)((Object)node)).getType());
        }
        return super.visit(node);
    }
}

