/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex;

import com.android.jack.Jack;
import com.android.jack.annotations.ForceInMainDex;
import com.android.jack.annotations.MultiDexInstaller;
import com.android.jack.backend.dex.ForceInMainDexMarker;
import com.android.jack.backend.dex.MultiDex;
import com.android.jack.backend.dex.MultiDexLegacyTracerBrush;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.shrob.obfuscation.OriginalNames;
import com.android.jack.util.NamingTools;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.schedulable.Transform;
import java.lang.annotation.Annotation;
import javax.annotation.Nonnull;

@Description(value="Add markers corresponding to annotation configuring multidex.")
@Constraint(need={OriginalNames.class})
@Support(value={MultiDex.class})
@Transform(add={MultiDexLegacyTracerBrush.MultiDexInstallerMarker.class, ForceInMainDexMarker.class})
public class MultiDexAnnotationsFinder
implements RunnableSchedulable<JDefinedClassOrInterface> {
    private final JVisitor visitor = new JVisitor(){

        @Override
        public boolean visit(@Nonnull JDefinedClassOrInterface node) {
            if (!node.getAnnotations(MultiDexAnnotationsFinder.this.installerAnnotationType).isEmpty()) {
                MultiDexAnnotationsFinder.this.markIfNecessary(node);
            }
            return super.visit(node);
        }

        @Override
        public boolean visit(@Nonnull JField node) {
            if (!node.getAnnotations(MultiDexAnnotationsFinder.this.installerAnnotationType).isEmpty()) {
                MultiDexAnnotationsFinder.this.markIfNecessary(node);
            }
            return false;
        }

        @Override
        public boolean visit(@Nonnull JMethod node) {
            if (!node.getAnnotations(MultiDexAnnotationsFinder.this.installerAnnotationType).isEmpty()) {
                MultiDexAnnotationsFinder.this.markIfNecessary(node);
            }
            return false;
        }
    };
    @Nonnull
    private final JAnnotationType installerAnnotationType = this.getJAnnotationType(MultiDexInstaller.class);
    @Nonnull
    private final JAnnotationType mainDexAnnotationType = this.getJAnnotationType(ForceInMainDex.class);

    @Nonnull
    private JAnnotationType getJAnnotationType(@Nonnull Class<? extends Annotation> clazz) {
        String signature = NamingTools.getTypeSignatureName(clazz.getName());
        return Jack.getSession().getPhantomLookup().getAnnotationType(signature);
    }

    @Override
    public void run(@Nonnull JDefinedClassOrInterface type) {
        this.visitor.accept(type);
        if (!type.getAnnotations(this.mainDexAnnotationType).isEmpty()) {
            type.addMarker(ForceInMainDexMarker.INSTANCE);
        }
    }

    private void markIfNecessary(@Nonnull JNode node) {
        node.addMarkerIfAbsent(MultiDexLegacyTracerBrush.MultiDexInstallerMarker.INSTANCE);
    }
}

