/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex;

import com.android.jack.Options;
import com.android.jack.backend.dex.rop.RopHelper;
import com.android.jack.dx.dex.file.ClassDefItem;
import com.android.jack.dx.dex.file.EncodedMethod;
import com.android.jack.dx.dex.file.OffsettedItem;
import com.android.jack.dx.rop.cst.CstMethodRef;
import com.android.jack.ir.ast.JConstructor;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JModifier;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.scheduling.marker.ClassDefItemMarker;
import com.android.jack.scheduling.marker.DexCodeMarker;
import com.android.jack.transformations.EmptyClinit;
import com.android.jack.transformations.ast.removeinit.FieldInitMethod;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.item.Synchronized;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Protect;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnull;

@Description(value="Builds EncodedMethod from JMethod")
@Name(value="EncodedMethodBuilder")
@Synchronized
@Constraint(need={ClassDefItemMarker.class, DexCodeMarker.class}, no={FieldInitMethod.class, EmptyClinit.class})
@Transform(add={ClassDefItemMarker.Method.class}, modify={ClassDefItemMarker.class})
@Protect(add={JMethod.class}, modify={JMethod.class}, remove={JMethod.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class EncodedMethodBuilder
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public synchronized void run(@Nonnull JMethod method) {
        JDefinedClassOrInterface declaringClass = method.getEnclosingType();
        ClassDefItemMarker classDefItemMarker = declaringClass.getMarker(ClassDefItemMarker.class);
        assert (classDefItemMarker != null);
        ClassDefItem classDefItem = classDefItemMarker.getClassDefItem();
        assert (classDefItem != null);
        EncodedMethod encodedMethod = this.createEncodedMethod(method);
        if (EncodedMethodBuilder.isDirectMethod(method)) {
            classDefItem.addDirectMethod(encodedMethod);
        } else {
            classDefItem.addVirtualMethod(encodedMethod);
        }
    }

    private static boolean isDirectMethod(@Nonnull JMethod method) {
        return method.isPrivate() || method.isStatic() || method instanceof JConstructor;
    }

    @Nonnull
    private EncodedMethod createEncodedMethod(@Nonnull JMethod method) {
        CstMethodRef methodRef = RopHelper.createMethodRef(method);
        int accessFlags = EncodedMethodBuilder.getDxAccessFlagsForMethod(method);
        OffsettedItem code = null;
        if (this.filter.accept(this.getClass(), method) && !method.isAbstract() && !method.isNative()) {
            DexCodeMarker dcm = method.getMarker(DexCodeMarker.class);
            assert (dcm != null);
            code = (OffsettedItem)((Object)dcm.getCode());
        } else if (!method.isAbstract() && !method.isNative()) {
            accessFlags |= 0x400;
        }
        return new EncodedMethod(methodRef, accessFlags, code);
    }

    private static int getDxAccessFlagsForMethod(@Nonnull JMethod method) {
        int accessFlags = method.getModifier();
        accessFlags &= 0xFFEFFFFF;
        if (method instanceof JConstructor) {
            accessFlags |= 0x10000;
        }
        if (JModifier.isStaticInitializer(accessFlags)) {
            accessFlags &= 0xFFFEFFFF;
            accessFlags |= 0x10000;
        }
        if (JModifier.isSynchronized(accessFlags)) {
            assert (!JModifier.isBridge(accessFlags));
            if (!JModifier.isNative(accessFlags |= 0x20000)) {
                accessFlags &= 0xFFFFFFDF;
            }
        }
        return accessFlags & 0x31DFF;
    }
}

