/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.formatter.BinaryQualifiedNameFormatter;
import com.android.sched.util.SubReleaseKind;
import com.android.sched.util.Version;
import com.android.sched.vfs.VPath;
import javax.annotation.Nonnull;

public abstract class DexWriter {
    @Nonnull
    private static final String JACK_DEX_TAG_HEADER = "emitter: " + Jack.getEmitterId() + "-";
    @Nonnull
    private static final String JACK_DEX_TAG;

    @Nonnull
    static VPath getFilePath(@Nonnull JDefinedClassOrInterface type) {
        return new VPath(BinaryQualifiedNameFormatter.getFormatter().getName(type) + ".dex", '/');
    }

    @Nonnull
    public static String getJackDexTag() {
        return JACK_DEX_TAG;
    }

    public static boolean isJackDexTag(String str) {
        return str.startsWith(JACK_DEX_TAG_HEADER);
    }

    static {
        Version version = Jack.getVersion();
        String tag = JACK_DEX_TAG_HEADER + version.getReleaseCode() + "." + version.getSubReleaseCode();
        if (version.getSubReleaseKind() == SubReleaseKind.ENGINEERING) {
            tag = tag + "-eng";
            String buildId = version.getBuildId();
            if (buildId != null) {
                tag = tag + "-" + buildId;
            }
        }
        JACK_DEX_TAG = tag;
    }
}

