/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.analysis.tracer;

import com.android.jack.Jack;
import com.android.jack.analysis.tracer.TracerBrush;
import com.android.jack.debug.DebugVariableInfoMarker;
import com.android.jack.frontend.MethodIdDuplicateRemover;
import com.android.jack.ir.ast.Annotable;
import com.android.jack.ir.ast.JAbstractMethodBody;
import com.android.jack.ir.ast.JAbstractStringLiteral;
import com.android.jack.ir.ast.JAlloc;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JAnnotationMethod;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JArrayType;
import com.android.jack.ir.ast.JBinaryOperation;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassLiteral;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JConstructor;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JDefinedEnum;
import com.android.jack.ir.ast.JDefinedInterface;
import com.android.jack.ir.ast.JDynamicCastOperation;
import com.android.jack.ir.ast.JEnumLiteral;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JFieldId;
import com.android.jack.ir.ast.JFieldNameLiteral;
import com.android.jack.ir.ast.JFieldRef;
import com.android.jack.ir.ast.JInstanceOf;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JLambda;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JMethodIdRef;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JMethodNameLiteral;
import com.android.jack.ir.ast.JNameValuePair;
import com.android.jack.ir.ast.JNewArray;
import com.android.jack.ir.ast.JNewInstance;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JReinterpretCastOperation;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JTypeStringLiteral;
import com.android.jack.ir.ast.JVariable;
import com.android.jack.ir.ast.JVariableRef;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.marker.ThrownExceptionMarker;
import com.android.jack.lookup.JMethodLookupException;
import com.android.jack.reporting.Reporter;
import com.android.jack.shrob.obfuscation.SubClassOrInterfaceMarker;
import com.android.jack.shrob.shrink.PartialTypeHierarchy;
import com.android.sched.item.Description;
import com.android.sched.marker.LocalMarkerManager;
import com.android.sched.schedulable.Access;
import com.android.sched.schedulable.Constraint;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.util.log.TracerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="traces dependencies")
@Constraint(need={MethodIdDuplicateRemover.UniqMethodIds.class, SubClassOrInterfaceMarker.class, JMethodBody.class})
@Access(value=JSession.class)
public class Tracer
extends JVisitor {
    @Nonnull
    protected final com.android.sched.util.log.Tracer tracer = TracerFactory.getTracer();
    @Nonnull
    public Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private final TracerBrush brush;

    public Tracer(@Nonnull TracerBrush brush) {
        this.brush = brush;
    }

    public void run(@Nonnull JDefinedClassOrInterface type) {
        if (this.brush.startTraceSeed(type)) {
            this.trace(type);
            this.brush.endTraceSeed(type);
        }
    }

    private void trace(@Nonnull JType t) {
        if (t instanceof JDefinedClassOrInterface) {
            this.trace((JDefinedClassOrInterface)t);
        } else if (t instanceof JArrayType) {
            this.trace(((JArrayType)t).getLeafType());
        }
    }

    private void traceAnnotations(@Nonnull Annotable annotable) {
        for (JAnnotation annotation : annotable.getAnnotations()) {
            this.accept(annotation);
        }
    }

    private boolean isNullaryConstructor(@Nonnull JMethod m) {
        return m instanceof JConstructor && m.getParams().isEmpty();
    }

    private void traceImplementation(@Nonnull JDefinedClass extendingOrImplementingClass, @Nonnull JClassOrInterface superClOrI) {
        if (superClOrI instanceof JDefinedClassOrInterface) {
            JDefinedClassOrInterface definedSuperClOrI = (JDefinedClassOrInterface)superClOrI;
            for (JMethod method : definedSuperClOrI.getMethods()) {
                JType returnType;
                if (!this.brush.startTraceOverridingMethod(method)) continue;
                JMethodIdWide methodId = method.getMethodIdWide();
                JMethod implementation = this.findImplementation(methodId, returnType = method.getType(), extendingOrImplementingClass);
                if (implementation != null && implementation != method) {
                    this.trace(methodId, implementation.getEnclosingType(), returnType, true);
                }
                this.brush.endTraceOverridingMethod(method);
            }
            JClass superClass = definedSuperClOrI.getSuperClass();
            if (superClass != null) {
                this.traceImplementation(extendingOrImplementingClass, superClass);
            }
            for (JInterface i : definedSuperClOrI.getImplements()) {
                this.traceImplementation(extendingOrImplementingClass, i);
            }
        }
    }

    private void trace(@Nonnull JDefinedClassOrInterface t) {
        if (this.brush.startTrace(t)) {
            this.traceAnnotations(t);
            if (t instanceof JDefinedClass) {
                JDefinedClass definedClass = (JDefinedClass)t;
                JClass superClass = definedClass.getSuperClass();
                if (superClass != null) {
                    this.traceImplementation(definedClass, superClass);
                }
                for (JInterface i : definedClass.getImplements()) {
                    this.traceImplementation(definedClass, i);
                }
                if (t.isAnonymous() && this.brush.startTraceEnclosingMethod()) {
                    JMethod enclosingMethod = ((JDefinedClass)t).getEnclosingMethod();
                    if (enclosingMethod != null) {
                        this.trace(t.getEnclosingType());
                        this.trace(enclosingMethod);
                    }
                    this.brush.endTraceEnclosingMethod();
                }
                if (t instanceof JDefinedEnum) {
                    try {
                        JMethod values = definedClass.getMethod("values", (JType)definedClass.getArray(), new JType[0]);
                        this.trace(values);
                    }
                    catch (JMethodLookupException e) {
                        throw new AssertionError((Object)e);
                    }
                }
            }
            for (JField field : t.getFields()) {
                if (!this.brush.startTraceSeed(field)) continue;
                this.trace(field);
                this.brush.endTraceSeed(field);
            }
            PartialTypeHierarchy pth = t.getMarker(PartialTypeHierarchy.class);
            if (pth != null) {
                Jack.getSession().getReporter().report(Reporter.Severity.NON_FATAL, pth);
            }
            for (JMethod method : t.getMethods()) {
                if (JMethod.isClinit(method) || this.isNullaryConstructor(method)) {
                    this.trace(method);
                    continue;
                }
                if (!this.brush.startTraceSeed(method) && pth == null) continue;
                this.trace(method.getMethodIdWide(), method.getEnclosingType(), method.getType(), true);
                this.brush.endTraceSeed(method);
            }
            this.brush.endTrace(t);
        }
    }

    private void trace(@Nonnull JField f) {
        if (this.brush.startTrace(f)) {
            this.trace(f.getEnclosingType());
            this.trace(f.getType());
            this.traceAnnotations(f);
            this.brush.endTrace(f);
        }
    }

    private void trace(@Nonnull JFieldId fid, @Nonnull JClassOrInterface receiverType) {
        this.trace(receiverType);
        JField field = fid.getField();
        if (field != null) {
            this.trace(field);
        }
    }

    @CheckForNull
    private JMethod findMethod(@Nonnull JMethodIdWide methodIdWide, @Nonnull JClassOrInterface enclosingType, @Nonnull JType returnType) {
        JMethodId id = methodIdWide.getMethodId(returnType);
        if (id == null) {
            return null;
        }
        for (JMethod m : id.getMethods()) {
            if (!m.getEnclosingType().isSameType(enclosingType)) continue;
            return m;
        }
        return null;
    }

    private void trace(@Nonnull JMethodIdWide mid, @Nonnull JClassOrInterface receiverType, @Nonnull JType returnType, boolean mustTraceOverridingMethods) {
        SubClassOrInterfaceMarker marker;
        JMethod foundMethod = this.findMethod(mid, receiverType, returnType);
        if (foundMethod != null) {
            this.trace(foundMethod);
            if (mustTraceOverridingMethods) {
                this.brush.setMustTraceOverridingMethods(foundMethod);
            }
        }
        if (receiverType instanceof JDefinedClassOrInterface && mustTraceOverridingMethods && (marker = ((LocalMarkerManager)((Object)receiverType)).getMarker(SubClassOrInterfaceMarker.class)) != null) {
            for (JDefinedClass subClass : marker.getSubClasses()) {
                if (!this.brush.traceMarked(subClass)) continue;
                JMethod implementation = this.findImplementation(mid, returnType, subClass);
                if (implementation != null) {
                    this.trace(implementation);
                    this.brush.setMustTraceOverridingMethods(implementation);
                }
                this.brush.endTraceMarked(subClass);
            }
        }
    }

    private void trace(@Nonnull JMethod m) {
        if (this.brush.startTrace(m)) {
            JAbstractMethodBody jAbstractMethodBody;
            this.trace(m.getEnclosingType());
            this.traceAnnotations(m);
            for (JParameter jParameter : m.getParams()) {
                this.trace(jParameter.getType());
            }
            this.trace(m.getType());
            ThrownExceptionMarker marker = m.getMarker(ThrownExceptionMarker.class);
            if (marker != null) {
                for (JClass throwException : marker.getThrownExceptions()) {
                    this.trace(throwException);
                }
            }
            if (m.getEnclosingType().isToEmit() && (jAbstractMethodBody = m.getBody()) != null) {
                this.accept(jAbstractMethodBody);
            }
            this.brush.endTrace(m);
        }
    }

    private void trace(@Nonnull JAnnotation al) {
        JAnnotationType type = al.getType();
        this.trace(type);
        for (JNameValuePair pair : al.getNameValuePairs()) {
            for (JMethod method : pair.getMethodId().getMethods()) {
                if (!method.getEnclosingType().isSameType(type)) continue;
                this.trace(method);
                JLiteral defaultValue = ((JAnnotationMethod)method).getDefaultValue();
                if (defaultValue == null) continue;
                this.accept(defaultValue);
            }
        }
    }

    @Override
    public void endVisit(@Nonnull JFieldRef fr) {
        this.trace(fr.getFieldId(), fr.getReceiverType());
    }

    @Override
    public void endVisit(@Nonnull JMethodCall mc) {
        JType returnType = mc.getType();
        this.trace(returnType);
        JMethodIdWide methodId = mc.getMethodId();
        JClassOrInterface receiverType = mc.getReceiverType();
        this.trace(receiverType);
        JMethod implementationOrDefinition = null;
        if (receiverType instanceof JDefinedClass) {
            implementationOrDefinition = this.findImplementationOrDefinition(methodId, returnType, (JDefinedClass)receiverType);
            if (implementationOrDefinition == null && receiverType.isToEmit()) {
                this.logger.log(Level.WARNING, "No implementation or definition found for method {0} in {1} or its super types", new Object[]{Jack.getUserFriendlyFormatter().getName(methodId.getName(), methodId.getParamTypes(), returnType), Jack.getUserFriendlyFormatter().getName(receiverType)});
            }
        } else if (receiverType instanceof JDefinedInterface && (implementationOrDefinition = this.findDefinition(methodId, returnType, (JDefinedClassOrInterface)receiverType)) == null && receiverType.isToEmit()) {
            this.logger.log(Level.WARNING, "No implementation or definition found for method {0} in {1} or its super types", new Object[]{Jack.getUserFriendlyFormatter().getName(methodId.getName(), methodId.getParamTypes(), returnType), Jack.getUserFriendlyFormatter().getName(receiverType)});
        }
        JClassOrInterface tracingStartingPoint = null;
        if (implementationOrDefinition != null) {
            tracingStartingPoint = implementationOrDefinition.getEnclosingType();
            this.trace(tracingStartingPoint);
        } else {
            tracingStartingPoint = receiverType;
        }
        this.trace(methodId, tracingStartingPoint, returnType, true);
    }

    @Override
    public void endVisit(@Nonnull JNewInstance newInstance) {
        JClass returnType = newInstance.getType();
        this.trace(returnType);
        JMethodIdWide methodId = newInstance.getMethodId();
        this.trace(methodId, returnType, JPrimitiveType.JPrimitiveTypeEnum.VOID.getType(), false);
    }

    @CheckForNull
    private JMethod findDefinition(@Nonnull JMethodIdWide methodId, @Nonnull JType returnType, @Nonnull JDefinedClassOrInterface receiverType) {
        JMethod foundMethod = this.findMethod(methodId, receiverType, returnType);
        if (foundMethod != null) {
            return foundMethod;
        }
        for (JInterface i : receiverType.getImplements()) {
            JMethod foundDefinition;
            if (!(i instanceof JDefinedInterface) || (foundDefinition = this.findDefinition(methodId, returnType, (JDefinedInterface)i)) == null) continue;
            return foundDefinition;
        }
        return null;
    }

    @CheckForNull
    private JMethod findImplementation(@Nonnull JMethodIdWide methodId, @Nonnull JType returnType, @Nonnull JDefinedClass receiverType) {
        JClass currentType = receiverType;
        while (currentType instanceof JDefinedClass) {
            JMethod foundMethod = this.findMethod(methodId, currentType, returnType);
            if (foundMethod != null) {
                return foundMethod;
            }
            currentType = currentType.getSuperClass();
        }
        return null;
    }

    @CheckForNull
    private JMethod findImplementationOrDefinition(@Nonnull JMethodIdWide methodId, @Nonnull JType returnType, @Nonnull JDefinedClass receiverType) {
        JMethod implementation = this.findImplementation(methodId, returnType, receiverType);
        if (implementation != null) {
            return implementation;
        }
        JClass currentType = receiverType;
        while (currentType instanceof JDefinedClass) {
            JMethod definition = this.findDefinition(methodId, returnType, (JDefinedClassOrInterface)((Object)currentType));
            if (definition != null) {
                return definition;
            }
            currentType = currentType.getSuperClass();
        }
        return null;
    }

    @Override
    public void endVisit(@Nonnull JMethodNameLiteral mnl) {
        this.trace(mnl.getMethod());
    }

    @Override
    public void endVisit(@Nonnull JFieldNameLiteral fnl) {
        this.trace(fnl.getField());
    }

    @Override
    public void endVisit(@Nonnull JTypeStringLiteral tsl) {
        this.trace(tsl.getReferencedType());
    }

    @Override
    public void endVisit(@Nonnull JAlloc alloc) {
        this.trace(alloc.getInstanceType());
    }

    @Override
    public void endVisit(@Nonnull JAnnotation annotation) {
        this.trace(annotation);
    }

    @Override
    public void endVisit(@Nonnull JBinaryOperation x) {
        this.trace(x.getType());
    }

    @Override
    public void endVisit(@Nonnull JReinterpretCastOperation x) {
        this.trace(x.getType());
    }

    @Override
    public void endVisit(@Nonnull JDynamicCastOperation x) {
        for (JType type : x.getTypes()) {
            this.trace(type);
        }
    }

    @Override
    public void endVisit(@Nonnull JClassLiteral x) {
        this.trace(x.getRefType());
    }

    @Override
    public void endVisit(@Nonnull JEnumLiteral enumLit) {
        JField field = enumLit.getFieldId().getField();
        if (field != null) {
            this.traceAnnotations(field);
        }
    }

    @Override
    public void endVisit(@Nonnull JInstanceOf x) {
        this.trace(x.getTestType());
    }

    @Override
    public void endVisit(@Nonnull JNewArray x) {
        this.trace(x.getArrayType());
    }

    @Override
    public void endVisit(@Nonnull JAbstractStringLiteral x) {
        this.trace(x.getType());
    }

    @Override
    public void endVisit(@Nonnull JVariableRef x) {
        DebugVariableInfoMarker debugInfo = x.getMarker(DebugVariableInfoMarker.class);
        if (debugInfo != null) {
            this.trace(debugInfo.getType());
        }
    }

    @Override
    public void endVisit(@Nonnull JVariable x) {
        this.trace(x.getType());
    }

    @Override
    public void endVisit(@Nonnull JLambda lambdaExpr) {
        this.trace(lambdaExpr.getType());
        for (JInterface interfaze : lambdaExpr.getInterfaceBounds()) {
            this.trace(interfaze);
        }
        for (JExpression capturedVar : lambdaExpr.getCapturedVariables()) {
            this.accept(capturedVar);
        }
        JMethodIdRef methodIdRef = lambdaExpr.getMethodIdRef();
        JMethodId methodId = methodIdRef.getMethodId();
        JMethodIdWide methodIdWide = methodId.getMethodIdWide();
        JDefinedClassOrInterface receiverType = methodIdRef.getEnclosingType();
        this.trace((JType)receiverType);
        this.trace(methodIdWide, methodIdRef.getEnclosingType(), methodId.getType(), false);
    }
}

