/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.analysis.defsuses;

import com.android.jack.Jack;
import com.android.jack.Options;
import com.android.jack.analysis.UseDefsMarker;
import com.android.jack.cfg.BasicBlock;
import com.android.jack.cfg.ControlFlowGraph;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JCatchBlock;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JVariableRef;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnull;

@Description(value="Check use/defs result analysis.")
@Constraint(need={UseDefsMarker.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class UseDefsChecker
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        ControlFlowGraph cfg = method.getMarker(ControlFlowGraph.class);
        assert (cfg != null);
        Visitor visitor = new Visitor(method);
        for (BasicBlock bb : cfg.getNodes()) {
            visitor.accept(bb.getStatements());
        }
    }

    private static class Visitor
    extends JVisitor {
        @Nonnull
        private final JMethod jmethod;

        public Visitor(@Nonnull JMethod jmethod) {
            this.jmethod = jmethod;
        }

        @Override
        public boolean visit(@Nonnull JVariableRef varRef) {
            JNode parent = varRef.getParent();
            if (!(parent instanceof JAsgOperation && ((JAsgOperation)parent).getLhs() == varRef || varRef.getMarker(UseDefsMarker.class) != null)) {
                throw new AssertionError((Object)("Failed to verify use/defs chains of " + Jack.getUserFriendlyFormatter().getName(this.jmethod.getEnclosingType()) + "." + Jack.getUserFriendlyFormatter().getName(this.jmethod)));
            }
            return super.visit(varRef);
        }

        @Override
        public boolean visit(@Nonnull JIfStatement jIf) {
            this.accept(jIf.getIfExpr());
            return false;
        }

        @Override
        public boolean visit(@Nonnull JBlock jBlock) {
            return false;
        }

        @Override
        public boolean visit(@Nonnull JCatchBlock jCatchBlock) {
            return false;
        }
    }
}

