/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.analysis.common;

import com.android.jack.cfg.BasicBlock;
import com.android.jack.cfg.ControlFlowGraph;
import com.android.jack.cfg.PeiBasicBlock;
import com.android.jack.ir.ast.JStatement;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class ReachabilityAnalyzer<S> {
    @Nonnull
    protected abstract ControlFlowGraph getCfg();

    protected abstract void finalize(@Nonnull List<S> var1, @Nonnull List<S> var2, @Nonnull List<S> var3);

    @Nonnull
    protected abstract S newState(boolean var1);

    protected abstract void copyState(@Nonnull S var1, @Nonnull S var2);

    protected abstract void mergeState(@Nonnull S var1, @Nonnull S var2);

    protected abstract void processStatement(@Nonnull S var1, @Nonnull JStatement var2);

    @Nonnull
    protected abstract S cloneState(@Nonnull S var1);

    public final void analyze() {
        ControlFlowGraph cfg = this.getCfg();
        int basicBlockMaxId = cfg.getBasicBlockMaxId();
        ArrayList<S> in = new ArrayList<S>(basicBlockMaxId);
        ArrayList<S> out = new ArrayList<S>(basicBlockMaxId);
        ArrayList<S> outException = new ArrayList<S>(basicBlockMaxId);
        int entryBlockId = cfg.getEntryNode().getId();
        for (int i = 0; i < basicBlockMaxId; ++i) {
            in.add(this.newState(i == entryBlockId));
            out.add(this.newState(i == entryBlockId));
            outException.add(this.newState(i == entryBlockId));
        }
        LinkedList queue = new LinkedList(cfg.getNodes());
        BitSet mayBeQueued = new BitSet(queue.size());
        while (!queue.isEmpty()) {
            BasicBlock bb = (BasicBlock)queue.poll();
            int bbId = bb.getId();
            mayBeQueued.set(bbId);
            Object bbIn = in.get(bbId);
            Object bbOut = out.get(bbId);
            this.recalculateInSet(bb, false, bbIn, out, outException);
            Object oldOut = this.cloneState(bbOut);
            this.computeOutput(bb, bbIn, bbOut, outException.get(bbId));
            if (oldOut.equals(bbOut)) continue;
            for (BasicBlock successor : bb.getSuccessors()) {
                if (!mayBeQueued.get(successor.getId()) || successor == cfg.getExitNode()) continue;
                queue.offer(successor);
                mayBeQueued.clear(successor.getId());
            }
        }
        this.finalize(in, out, outException);
    }

    protected final void recalculateInSet(@Nonnull BasicBlock bb, boolean ignoreExceptionPath, @Nonnull S in, @Nonnull List<S> out, @Nonnull List<S> outException) {
        List predecessors = bb.getPredecessors();
        if (!predecessors.isEmpty()) {
            boolean mergeNeeded = false;
            for (BasicBlock predecessor : predecessors) {
                if (predecessor instanceof PeiBasicBlock && ((PeiBasicBlock)predecessor).isExceptionOrUncaughtBlock(bb)) {
                    if (ignoreExceptionPath) continue;
                    if (mergeNeeded) {
                        this.mergeState(in, outException.get(predecessor.getId()));
                        continue;
                    }
                    this.copyState(outException.get(predecessor.getId()), in);
                    mergeNeeded = true;
                    continue;
                }
                if (mergeNeeded) {
                    this.mergeState(in, out.get(predecessor.getId()));
                    continue;
                }
                this.copyState(out.get(predecessor.getId()), in);
                mergeNeeded = true;
            }
        }
    }

    private void computeOutput(@Nonnull BasicBlock bb, @Nonnull S inBs, @Nonnull S outBs, @Nonnull S outExceptionBs) {
        this.copyState(inBs, outBs);
        List<JStatement> statements = bb.getStatements();
        if (statements.size() > 0) {
            JStatement lastStmt = statements.get(statements.size() - 1);
            for (JStatement stmt : statements) {
                if (stmt == lastStmt) {
                    this.copyState(outBs, outExceptionBs);
                }
                this.processStatement(outBs, stmt);
            }
        }
    }
}

