/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.analysis;

import com.android.jack.analysis.DefinitionMarker;
import com.android.jack.ir.ast.JVariableRef;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

@Description(value="Keep the chain between a use and theirs used definitions.")
@ValidOn(value={JVariableRef.class})
public final class UseDefsMarker
implements Marker {
    @Nonnull
    final List<DefinitionMarker> defs = new ArrayList<DefinitionMarker>();

    public boolean isWithoutDefinition() {
        return this.defs.isEmpty();
    }

    public boolean isUsingOnlyOneDefinition() {
        return this.defs.size() == 1;
    }

    @Nonnull
    public List<DefinitionMarker> getDefs() {
        return new ArrayList<DefinitionMarker>(this.defs);
    }

    public void addUsedDefinitions(@Nonnull List<DefinitionMarker> usedDefinitions, @Nonnull JVariableRef by) {
        for (DefinitionMarker usedDefinition : usedDefinitions) {
            this.addUsedDefinition(usedDefinition, by);
        }
    }

    public void addUsedDefinition(@Nonnull DefinitionMarker usedDefinition, @Nonnull JVariableRef by) {
        assert (!this.defs.contains(usedDefinition));
        this.defs.add(usedDefinition);
        usedDefinition.uses.add(by);
    }

    public void removeAllUsedDefinitions(@Nonnull JVariableRef usedBy) {
        for (DefinitionMarker usedDef : this.defs) {
            usedDef.uses.remove(usedBy);
        }
        this.defs.clear();
    }

    @Override
    public Marker cloneIfNeeded() {
        throw new AssertionError((Object)"It is not valid to use cloneIfNeeded, create a new marker.");
    }
}

