/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack;

import com.android.jack.CLILogConfiguration;
import com.android.jack.CommandLine;
import com.android.jack.IllegalOptionsException;
import com.android.jack.Options;
import com.android.jack.kohsuke.args4j.CmdLineException;
import com.android.jack.kohsuke.args4j.CmdLineParser;
import com.android.jack.kohsuke.args4j.ParserProperties;
import com.android.sched.util.config.cli.TokenIterator;
import com.android.sched.util.file.CannotReadException;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotFileOrDirectoryException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.NoLocation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class Main
extends CommandLine {
    public static void main(@Nonnull String[] args) {
        try {
            CLILogConfiguration.setupLogs();
        }
        catch (CLILogConfiguration.LogConfigurationException e) {
            System.err.println("Failed to setup logs: " + e.getMessage());
            System.exit(2);
        }
        if (args.length == 0) {
            System.err.println("Try --help for help.");
            System.exit(0);
        }
        try {
            TokenIterator iterator = new TokenIterator(new NoLocation(), args);
            ArrayList<String> list = new ArrayList<String>();
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
            Options options = Main.parseCommandLine(list);
            if (options.askForHelp()) {
                Main.printUsage(System.out);
                System.exit(0);
            }
            if (options.askForPropertiesHelp()) {
                Main.printHelpProperties(System.out, options);
                System.exit(0);
            }
            if (options.askForVersion()) {
                Main.printVersion(System.out, options);
                System.exit(0);
            }
            if (options.askForPluginsList()) {
                Main.printPluginsList(System.out, options);
                System.exit(0);
            }
            System.exit(Main.runJack(System.err, options));
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            CmdLineParser parser = e.getParser();
            if (parser != null) {
                Main.printUsage(System.err);
            } else {
                System.err.println("Try --help for help.");
            }
            System.exit(2);
        }
        catch (CannotReadException | NoSuchFileException | NotFileOrDirectoryException | WrongPermissionException | IOException e) {
            System.err.println(e.getMessage());
            System.exit(2);
        }
        catch (IllegalOptionsException e) {
            System.err.println(e.getMessage());
            System.exit(2);
        }
    }

    @Nonnull
    public static Options parseCommandLine(@Nonnull List<String> list) throws CmdLineException {
        Options options = new Options();
        CmdLineParser parser = new CmdLineParser(options, ParserProperties.defaults().withUsageWidth(100));
        parser.parseArgument(list);
        parser.stopOptionParsing();
        return options;
    }
}

