/*
 * Decompiled with CFR 0.152.
 */
package jd.core;

import java.util.ArrayList;
import jd.core.Decompiler;
import jd.ide.intellij.config.JDPluginComponent;

public class Main {
    private static final String HELP = "Usage: java -jar jd-core-java.jar [options] <compiled.jar> [<destination>]\nOptions:\n    -z - save sources into a zip file\n    -n - add line numbers into sources; (false by default)\n    -r - not realign line numbers (true by default)\n";

    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                System.err.println(HELP);
                return;
            }
            ArrayList<String> paths = new ArrayList<String>();
            for (String arg : args) {
                if (arg.startsWith("-")) {
                    Main.processArgs(arg);
                    continue;
                }
                paths.add(arg);
            }
            if (paths.isEmpty()) {
                throw new IllegalArgumentException("Nothing is found to decomplile.");
            }
            String jarPath = (String)paths.get(0);
            String outPath = paths.size() > 1 ? (String)paths.get(1) : null;
            int numDecompiled = new Decompiler().decompile(jarPath, outPath);
            System.err.println("Decompiled " + numDecompiled + " classes");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void processArgs(String arg) {
        if ("-".equals(arg)) {
            throw new IllegalArgumentException("Illegal argument: '-'");
        }
        char[] arr$ = arg.substring(1).toCharArray();
        int len$ = arr$.length;
        block5: for (int i$ = 0; i$ < len$; ++i$) {
            Character ch = Character.valueOf(arr$[i$]);
            switch (ch.charValue()) {
                case 'z': {
                    JDPluginComponent.CONF.setSaveToZip(true);
                    continue block5;
                }
                case 'n': {
                    JDPluginComponent.CONF.setShowLineNumbersEnabled(true);
                    continue block5;
                }
                case 'r': {
                    JDPluginComponent.CONF.setRealignLineNumbersEnabled(false);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unknown argument: '" + ch + "'");
                }
            }
        }
    }
}

