/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.expr;

import com.googlecode.dex2jar.ir.Value;
import com.googlecode.dex2jar.ir.ValueBox;
import org.objectweb.asm.Type;

public class NewMutiArrayExpr
extends Value.EnExpr {
    public Type baseType;
    public int dimension;

    public NewMutiArrayExpr(Type base, int dimension, ValueBox[] sizes) {
        super(Value.VT.NEW_MUTI_ARRAY, sizes);
        this.baseType = base;
        this.dimension = dimension;
        this.ops = new ValueBox[sizes.length];
    }

    @Override
    public Value clone() {
        ValueBox[] nOps = new ValueBox[this.ops.length];
        int i = 0;
        while (i < nOps.length) {
            nOps[i] = new ValueBox(this.ops[i].value.clone());
            ++i;
        }
        return new NewMutiArrayExpr(this.baseType, this.dimension, nOps);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("new ").append(this.baseType);
        int i = 0;
        while (i < this.dimension) {
            sb.append('[').append(this.ops[i]).append(']');
            ++i;
        }
        return sb.toString();
    }
}

