/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.optimizer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class JarOptimizer {
    static final Set<String> API = new HashSet<String>();
    static final Map<String, String> HIERARCHY = new HashMap<String, String>();
    static boolean nodebug = false;

    public static void main(String[] args) throws IOException {
        String line;
        File f = new File(args[0]);
        GZIPInputStream is = new GZIPInputStream(new FileInputStream(f));
        LineNumberReader lnr = new LineNumberReader(new InputStreamReader(is));
        while ((line = ((BufferedReader)lnr).readLine()) != null) {
            if (line.startsWith("class")) {
                String c = line.substring(6, line.lastIndexOf(32));
                String sc = line.substring(line.lastIndexOf(32) + 1);
                HIERARCHY.put(c, sc);
                continue;
            }
            API.add(line);
        }
        int argIndex = 1;
        if (args[argIndex].equals("-nodebug")) {
            nodebug = true;
            ++argIndex;
        }
        JarOptimizer.optimize(new File(args[argIndex]));
    }

    static void optimize(File f) throws IOException {
        if (nodebug && f.getName().contains("debug")) {
            return;
        }
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                JarOptimizer.optimize(files[i]);
            }
        } else if (f.getName().endsWith(".jar")) {
            String string;
            File g = new File(f.getParentFile(), String.valueOf(f.getName()).concat(".new"));
            ZipFile zf = new ZipFile(f);
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(g));
            Enumeration<? extends ZipEntry> e = zf.entries();
            byte[] buf = new byte[10000];
            while (e.hasMoreElements()) {
                int n;
                ZipEntry ze = e.nextElement();
                if (ze.isDirectory()) {
                    out.putNextEntry(ze);
                    continue;
                }
                out.putNextEntry(ze);
                if (ze.getName().endsWith(".class")) {
                    ClassReader cr = new ClassReader(zf.getInputStream(ze));
                    cr.accept(new ClassVerifier(), 0);
                }
                InputStream is = zf.getInputStream(ze);
                do {
                    if ((n = is.read(buf, 0, buf.length)) == -1) continue;
                    out.write(buf, 0, n);
                } while (n != -1);
                out.closeEntry();
            }
            out.close();
            zf.close();
            if (!f.delete()) {
                string = String.valueOf(f);
                throw new IOException(new StringBuilder(19 + String.valueOf(string).length()).append("Cannot delete file ").append(string).toString());
            }
            if (!g.renameTo(f)) {
                string = String.valueOf(g);
                throw new IOException(new StringBuilder(19 + String.valueOf(string).length()).append("Cannot rename file ").append(string).toString());
            }
        }
    }

    static class ClassVerifier
    extends ClassVisitor {
        String owner;
        String method;

        public ClassVerifier() {
            super(327680);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.owner = name;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            String string = String.valueOf(name);
            String string2 = String.valueOf(desc);
            this.method = string2.length() != 0 ? string.concat(string2) : new String(string);
            return new MethodVisitor(327680){

                public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                    ClassVerifier.this.check(owner, name);
                }

                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    String string = String.valueOf(name);
                    String string2 = String.valueOf(desc);
                    ClassVerifier.this.check(owner, string2.length() != 0 ? string.concat(string2) : new String(string));
                }
            };
        }

        void check(String owner, String member) {
            if (owner.startsWith("java/")) {
                String string;
                String o = owner;
                while (o != null) {
                    string = o;
                    if (API.contains(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(member).length()).append(string).append(" ").append(member).toString())) {
                        return;
                    }
                    o = HIERARCHY.get(o);
                }
                string = this.owner;
                String string2 = this.method;
                System.out.println(new StringBuilder(52 + String.valueOf(owner).length() + String.valueOf(member).length() + String.valueOf(string).length() + String.valueOf(string2).length()).append("WARNING: ").append(owner).append(" ").append(member).append(" called in ").append(string).append(" ").append(string2).append(" is not defined in JDK 1.3 API").toString());
            }
        }
    }

    static class ClassDump
    extends ClassVisitor {
        String owner;

        public ClassDump() {
            super(327680);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.owner = name;
            if (this.owner.startsWith("java/")) {
                System.out.println(new StringBuilder(7 + String.valueOf(name).length() + String.valueOf(superName).length()).append("class ").append(name).append(" ").append(superName).toString());
            }
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if (this.owner.startsWith("java/")) {
                String string = this.owner;
                System.out.println(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(name).length()).append(string).append(" ").append(name).toString());
            }
            return null;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.owner.startsWith("java/")) {
                String string = this.owner;
                System.out.println(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(name).length() + String.valueOf(desc).length()).append(string).append(" ").append(name).append(desc).toString());
            }
            return null;
        }
    }
}

