/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j.spi;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import org.kohsuke.args4j.spi.ConfigElement;
import org.kohsuke.args4j.spi.OptionHandler;

public abstract class AnnotationImpl
implements Annotation {
    private final Class<? extends Annotation> annotationType;
    public String[] aliases;
    public Class<? extends OptionHandler> handler;
    public String metaVar;
    public boolean multiValued;
    public boolean required;
    public boolean help;
    public boolean hidden;
    public String usage;
    public int index;

    protected AnnotationImpl(Class<? extends Annotation> annotationType) {
        this.annotationType = annotationType;
    }

    protected AnnotationImpl(Class<? extends Annotation> annotationType, ConfigElement ce) throws ClassNotFoundException {
        this(annotationType);
        this.aliases = ce.aliases != null ? ce.aliases : new String[]{};
        this.handler = ce.handler != null ? Class.forName(ce.handler) : OptionHandler.class;
        this.metaVar = ce.metavar != null ? ce.metavar : "";
        this.multiValued = ce.multiValued;
        this.required = ce.required;
        this.hidden = ce.hidden;
        this.usage = ce.usage != null ? ce.usage : "";
    }

    public String[] aliases() {
        return Arrays.copyOf(this.aliases, this.aliases.length);
    }

    public Class<? extends OptionHandler> handler() {
        return this.handler;
    }

    public String metaVar() {
        return this.metaVar;
    }

    public boolean multiValued() {
        return this.multiValued;
    }

    public boolean required() {
        return this.required;
    }

    public boolean help() {
        return this.help;
    }

    public boolean hidden() {
        return this.hidden;
    }

    public String usage() {
        return this.usage;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    public int index() {
        return this.index;
    }
}

