/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.args4j.spi.ConfigElement;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class Config {
    public List<ConfigElement> options = new ArrayList<ConfigElement>();
    public List<ConfigElement> arguments = new ArrayList<ConfigElement>();

    public static Config parse(InputSource xml) throws IOException, SAXException {
        Config rv = new Config();
        XMLReader reader = XMLReaderFactory.createXMLReader();
        Config config = rv;
        config.getClass();
        ConfigHandler handler = config.new ConfigHandler(rv);
        reader.setContentHandler(handler);
        reader.parse(xml);
        return rv;
    }

    public class ConfigHandler
    extends DefaultHandler {
        Config config;
        ConfigElement currentCE;

        public ConfigHandler(Config config) {
            this.config = config;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("option") || qName.equals("argument")) {
                this.currentCE = new ConfigElement();
                this.currentCE.field = attributes.getValue("field");
                this.currentCE.handler = attributes.getValue("handler");
                this.currentCE.metavar = attributes.getValue("metavar");
                this.currentCE.method = attributes.getValue("method");
                this.currentCE.name = attributes.getValue("name");
                this.currentCE.usage = attributes.getValue("usage");
                this.currentCE.multiValued = Boolean.getBoolean(attributes.getValue("multiValued"));
                this.currentCE.required = Boolean.getBoolean(attributes.getValue("required"));
                this.currentCE.aliases = attributes.getValue("aliases") != null ? attributes.getValue("aliases").split(",") : new String[0];
                (qName.equals("option") ? this.config.options : this.config.arguments).add(this.currentCE);
            }
        }
    }
}

