/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.tools.jacoco;

import com.android.jack.tools.jacoco.ErrorCode;
import com.android.jack.tools.jacoco.JackCoverageAnalyzer;
import com.android.jack.tools.jacoco.Options;
import com.android.jack.tools.jacoco.ReportType;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.tools.ExecFileLoader;
import org.jacoco.report.DirectorySourceFileLocator;
import org.jacoco.report.FileMultiReportOutput;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.MultiSourceFileLocator;
import org.jacoco.report.csv.CSVFormatter;
import org.jacoco.report.html.HTMLFormatter;
import org.jacoco.report.xml.XMLFormatter;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.ParserProperties;
import org.kohsuke.args4j.spi.OptionHandler;

public class Main {
    public static void main(String[] args) {
        try {
            Options options = Main.parseCommandLine(Arrays.asList(args));
            if (options.isHelpRequested()) {
                Main.printUsage(System.out);
            } else {
                Main.createReport(options);
            }
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            CmdLineParser parser = e.getParser();
            if (parser != null) {
                Main.printUsage(System.err);
            } else {
                System.err.println("Try --help for help.");
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            Main.printErrorAndExit(ErrorCode.INERNAL_ERROR, e.getMessage());
        }
    }

    @Nonnull
    private static Options parseCommandLine(@Nonnull List<String> list) throws CmdLineException {
        Options options = new Options();
        CmdLineParser parser = new CmdLineParser(options, ParserProperties.defaults().withUsageWidth(100));
        parser.parseArgument(list);
        parser.stopOptionParsing();
        return options;
    }

    private static void printUsage(@Nonnull PrintStream printStream) {
        CmdLineParser parser = new CmdLineParser(new Options(), ParserProperties.defaults().withUsageWidth(100));
        StringBuilder oneLineUsage = new StringBuilder("Usage:");
        for (OptionHandler optionHandler : parser.getOptions()) {
            if (!optionHandler.option.required()) continue;
            oneLineUsage.append(' ');
            oneLineUsage.append(optionHandler.option.toString());
            oneLineUsage.append(' ');
            oneLineUsage.append(optionHandler.option.metaVar());
            if (!optionHandler.option.isMultiValued()) continue;
            oneLineUsage.append(" ...");
        }
        oneLineUsage.append(" [<options>]");
        printStream.println(oneLineUsage.toString());
        printStream.println();
        printStream.println("Options:");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        parser.printUsage(outputStream);
        printStream.append(outputStream.toString());
    }

    private static void createReport(@Nonnull Options options) throws IOException {
        List<File> coverageDescriptionFiles = options.getCoverageDescriptionFiles();
        for (File file : coverageDescriptionFiles) {
            Main.checkFileExists(file);
            Main.checkCanReadFromFile(file);
        }
        List<File> coverageExecutionDataFiles = options.getCoverageExecutionFiles();
        for (File coverageExecutionDataFile : coverageExecutionDataFiles) {
            Main.checkFileExists(coverageExecutionDataFile);
            Main.checkCanReadFromFile(coverageExecutionDataFile);
        }
        File file = options.getReportOutputDirectory();
        assert (file != null);
        Main.checkDirectoryExists(file);
        Main.checkCanWriteToFile(file);
        List<File> sourceFilesDirectories = options.getSourceFilesDirectories();
        for (File sourceFilesDirectory : sourceFilesDirectories) {
            Main.checkDirectoryExists(sourceFilesDirectory);
            Main.checkCanReadFromFile(sourceFilesDirectory);
        }
        String reportName = options.getReportName();
        ReportType reportType = options.getReportType();
        String outputEncoding = options.getOutputReportEncoding();
        ExecFileLoader loader = new ExecFileLoader();
        for (File coverageExecutionDataFile : coverageExecutionDataFiles) {
            loader.load(coverageExecutionDataFile);
        }
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        JackCoverageAnalyzer analyzer = new JackCoverageAnalyzer(loader.getExecutionDataStore(), coverageBuilder);
        for (File coverageDescriptionFile : coverageDescriptionFiles) {
            analyzer.analyze(coverageDescriptionFile);
        }
        IBundleCoverage bundleCoverage = coverageBuilder.getBundle(reportName);
        IReportVisitor visitor = null;
        switch (reportType) {
            case HTML: {
                HTMLFormatter htmlFormatter = new HTMLFormatter();
                htmlFormatter.setOutputEncoding(outputEncoding);
                visitor = htmlFormatter.createVisitor(new FileMultiReportOutput(file));
                break;
            }
            case XML: {
                XMLFormatter xmlFormatter = new XMLFormatter();
                xmlFormatter.setOutputEncoding(outputEncoding);
                File xmlReportFile = new File(file, "report.xml");
                visitor = xmlFormatter.createVisitor(new FileOutputStream(xmlReportFile));
                break;
            }
            case CSV: {
                CSVFormatter csvFormatter = new CSVFormatter();
                csvFormatter.setOutputEncoding(outputEncoding);
                File csvReportFile = new File(file, "report.csv");
                visitor = csvFormatter.createVisitor(new FileOutputStream(csvReportFile));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown report type");
            }
        }
        if (visitor == null) {
            throw new NullPointerException("Report's visitor has not been created");
        }
        visitor.visitInfo(loader.getSessionInfoStore().getInfos(), loader.getExecutionDataStore().getContents());
        int tabWidth = options.getTabWidth();
        MultiSourceFileLocator sourceFileLocator = new MultiSourceFileLocator(tabWidth);
        String sourceFilesEncoding = options.getInputSourceFilesEncoding();
        for (File sourceFilesDirectory : sourceFilesDirectories) {
            sourceFileLocator.add(new DirectorySourceFileLocator(sourceFilesDirectory, sourceFilesEncoding, tabWidth));
        }
        visitor.visitBundle(bundleCoverage, sourceFileLocator);
        visitor.visitEnd();
        String string = String.valueOf(file);
        System.out.println(new StringBuilder(18 + String.valueOf(string).length()).append("Created report at ").append(string).toString());
    }

    private static void checkFileExists(@Nonnull File file) {
        if (!file.exists()) {
            Main.printErrorAndExit(ErrorCode.USAGE_ERROR, MessageFormat.format("File {0} does not exist", file));
        }
    }

    private static void checkCanReadFromFile(@Nonnull File file) {
        if (!file.canRead()) {
            Main.printErrorAndExit(ErrorCode.USAGE_ERROR, MessageFormat.format("Cannot read from file {0}", file));
        }
    }

    private static void checkCanWriteToFile(@Nonnull File file) {
        if (!file.canWrite()) {
            Main.printErrorAndExit(ErrorCode.USAGE_ERROR, MessageFormat.format("Cannot write to file {0}", file));
        }
    }

    private static void checkDirectoryExists(@Nonnull File file) {
        Main.checkFileExists(file);
        if (!file.isDirectory()) {
            Main.printErrorAndExit(ErrorCode.USAGE_ERROR, MessageFormat.format("File {0} is not a directory", file));
        }
    }

    private static void printErrorAndExit(@Nonnull ErrorCode error, String msg) {
        System.err.println(msg);
        System.exit(error.getErrorCode());
    }
}

