/*
 * Decompiled with CFR 0.152.
 */
package com.android.multidex;

import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.ConstantPool;
import com.android.dx.rop.cst.CstFieldRef;
import com.android.dx.rop.cst.CstMethodRef;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.Prototype;
import com.android.dx.rop.type.StdTypeList;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeList;
import com.android.multidex.MainDexListBuilder;
import com.android.multidex.Path;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassReferenceListBuilder {
    private static final String CLASS_EXTENSION = ".class";
    private final Path path;
    private final Set<String> classNames = new HashSet<String>();

    public ClassReferenceListBuilder(Path path) {
        this.path = path;
    }

    @Deprecated
    public static void main(String[] args) {
        MainDexListBuilder.main(args);
    }

    public void addRoots(ZipFile jarOfRoots) throws IOException {
        String name;
        ZipEntry entry;
        Enumeration<? extends ZipEntry> entries = jarOfRoots.entries();
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            name = entry.getName();
            if (!name.endsWith(CLASS_EXTENSION)) continue;
            this.classNames.add(name.substring(0, name.length() - CLASS_EXTENSION.length()));
        }
        entries = jarOfRoots.entries();
        while (entries.hasMoreElements()) {
            DirectClassFile classFile;
            entry = entries.nextElement();
            name = entry.getName();
            if (!name.endsWith(CLASS_EXTENSION)) continue;
            try {
                classFile = this.path.getClass(name);
            }
            catch (FileNotFoundException e) {
                throw new IOException("Class " + name + " is missing form original class path " + this.path, e);
            }
            this.addDependencies(classFile.getConstantPool());
        }
    }

    Set<String> getClassNames() {
        return this.classNames;
    }

    private void addDependencies(ConstantPool pool) {
        for (Constant constant : pool.getEntries()) {
            if (constant instanceof CstType) {
                this.checkDescriptor(((CstType)constant).getClassType());
                continue;
            }
            if (constant instanceof CstFieldRef) {
                this.checkDescriptor(((CstFieldRef)constant).getType());
                continue;
            }
            if (!(constant instanceof CstMethodRef)) continue;
            Prototype proto = ((CstMethodRef)constant).getPrototype();
            this.checkDescriptor(proto.getReturnType());
            StdTypeList args = proto.getParameterTypes();
            for (int i = 0; i < args.size(); ++i) {
                this.checkDescriptor(args.get(i));
            }
        }
    }

    private void checkDescriptor(Type type) {
        String descriptor = type.getDescriptor();
        if (descriptor.endsWith(";")) {
            int lastBrace = descriptor.lastIndexOf(91);
            if (lastBrace < 0) {
                this.addClassWithHierachy(descriptor.substring(1, descriptor.length() - 1));
            } else {
                assert (descriptor.length() > lastBrace + 3 && descriptor.charAt(lastBrace + 1) == 'L');
                this.addClassWithHierachy(descriptor.substring(lastBrace + 2, descriptor.length() - 1));
            }
        }
    }

    private void addClassWithHierachy(String classBinaryName) {
        if (this.classNames.contains(classBinaryName)) {
            return;
        }
        try {
            DirectClassFile classFile = this.path.getClass(classBinaryName + CLASS_EXTENSION);
            this.classNames.add(classBinaryName);
            CstType superClass = classFile.getSuperclass();
            if (superClass != null) {
                this.addClassWithHierachy(superClass.getClassType().getClassName());
            }
            TypeList interfaceList = classFile.getInterfaces();
            int interfaceNumber = interfaceList.size();
            for (int i = 0; i < interfaceNumber; ++i) {
                this.addClassWithHierachy(interfaceList.getType(i).getClassName());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }
}

