/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.command.dexer;

import com.android.dex.Dex;
import com.android.dex.DexException;
import com.android.dex.util.FileUtils;
import com.android.dx.cf.code.SimException;
import com.android.dx.cf.direct.ClassPathOpener;
import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.direct.StdAttributeFactory;
import com.android.dx.cf.iface.ParseException;
import com.android.dx.command.DxConsole;
import com.android.dx.command.UsageException;
import com.android.dx.dex.DexOptions;
import com.android.dx.dex.cf.CfOptions;
import com.android.dx.dex.cf.CfTranslator;
import com.android.dx.dex.file.ClassDefItem;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.EncodedMethod;
import com.android.dx.merge.CollisionPolicy;
import com.android.dx.merge.DexMerger;
import com.android.dx.rop.annotation.Annotation;
import com.android.dx.rop.annotation.Annotations;
import com.android.dx.rop.annotation.AnnotationsList;
import com.android.dx.rop.cst.CstNat;
import com.android.dx.rop.cst.CstString;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class Main {
    private static final String DEX_EXTENSION = ".dex";
    private static final String DEX_PREFIX = "classes";
    private static final String IN_RE_CORE_CLASSES = "Ill-advised or mistaken usage of a core class (java.* or javax.*)\nwhen not building a core library.\n\nThis is often due to inadvertently including a core library file\nin your application's project, when using an IDE (such as\nEclipse). If you are sure you're not intentionally defining a\ncore class, then this is the most likely explanation of what's\ngoing on.\n\nHowever, you might actually be trying to define a class in a core\nnamespace, the source of which you may have taken, for example,\nfrom a non-Android virtual machine project. This will most\nassuredly not work. At a minimum, it jeopardizes the\ncompatibility of your app with future versions of the platform.\nIt is also often of questionable legality.\n\nIf you really intend to build a core library -- which is only\nappropriate as part of creating a full virtual machine\ndistribution, as opposed to compiling an application -- then use\nthe \"--core-library\" option to suppress this error message.\n\nIf you go ahead and use \"--core-library\" but are in fact\nbuilding an application, then be forewarned that your application\nwill still fail to build or run, at some point. Please be\nprepared for angry customers who find, for example, that your\napplication ceases to function once they upgrade their operating\nsystem. You will be to blame for this problem.\n\nIf you are legitimately using some code that happens to be in a\ncore package, then the easiest safe alternative you have is to\nrepackage that code. That is, move the classes in question into\nyour own package namespace. This means that they will never be in\nconflict with core system classes. JarJar is a tool that may help\nyou in this endeavor. If you find that you cannot do this, then\nthat is an indication that the path you are on will ultimately\nlead to pain, suffering, grief, and lamentation.\n";
    private static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private static final Attributes.Name CREATED_BY = new Attributes.Name("Created-By");
    private static final String[] JAVAX_CORE = new String[]{"accessibility", "crypto", "imageio", "management", "naming", "net", "print", "rmi", "security", "sip", "sound", "sql", "swing", "transaction", "xml"};
    private static final int MAX_METHOD_ADDED_DURING_DEX_CREATION = 2;
    private static final int MAX_FIELD_ADDED_DURING_DEX_CREATION = 9;
    private static AtomicInteger errors = new AtomicInteger(0);
    private static Arguments args;
    private static DexFile outputDex;
    private static TreeMap<String, byte[]> outputResources;
    private static final List<byte[]> libraryDexBuffers;
    private static ExecutorService classTranslatorPool;
    private static ExecutorService classDefItemConsumer;
    private static List<Future<Boolean>> addToDexFutures;
    private static ExecutorService dexOutPool;
    private static List<Future<byte[]>> dexOutputFutures;
    private static Object dexRotationLock;
    private static int maxMethodIdsInProcess;
    private static int maxFieldIdsInProcess;
    private static volatile boolean anyFilesProcessed;
    private static long minimumFileAge;
    private static Set<String> classesInMainDex;
    private static List<byte[]> dexOutputArrays;
    private static OutputStreamWriter humanOutWriter;

    private Main() {
    }

    public static void main(String[] argArray) throws IOException {
        Arguments arguments = new Arguments();
        arguments.parse(argArray);
        int result = Main.run(arguments);
        if (result != 0) {
            System.exit(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int run(Arguments arguments) throws IOException {
        errors.set(0);
        libraryDexBuffers.clear();
        args = arguments;
        Main.args.makeOptionsObjects();
        OutputStream humanOutRaw = null;
        if (Main.args.humanOutName != null) {
            humanOutRaw = Main.openOutput(Main.args.humanOutName);
            humanOutWriter = new OutputStreamWriter(humanOutRaw);
        }
        try {
            if (Main.args.multiDex) {
                int n = Main.runMultiDex();
                return n;
            }
            int n = Main.runMonoDex();
            return n;
        }
        finally {
            Main.closeOutput(humanOutRaw);
        }
    }

    public static String getTooManyIdsErrorMessage() {
        if (Main.args.multiDex) {
            return "The list of classes given in --main-dex-list is too big and does not fit in the main dex.";
        }
        return "You may try using --multi-dex option.";
    }

    private static int runMonoDex() throws IOException {
        File incrementalOutFile = null;
        if (Main.args.incremental) {
            if (Main.args.outName == null) {
                System.err.println("error: no incremental output name specified");
                return -1;
            }
            incrementalOutFile = new File(Main.args.outName);
            if (incrementalOutFile.exists()) {
                minimumFileAge = incrementalOutFile.lastModified();
            }
        }
        if (!Main.processAllFiles()) {
            return 1;
        }
        if (Main.args.incremental && !anyFilesProcessed) {
            return 0;
        }
        byte[] outArray = null;
        if (!(outputDex.isEmpty() && Main.args.humanOutName == null || (outArray = Main.writeDex(outputDex)) != null)) {
            return 2;
        }
        if (Main.args.incremental) {
            outArray = Main.mergeIncremental(outArray, incrementalOutFile);
        }
        outArray = Main.mergeLibraryDexBuffers(outArray);
        if (Main.args.jarOutput) {
            outputDex = null;
            if (outArray != null) {
                outputResources.put("classes.dex", outArray);
            }
            if (!Main.createJar(Main.args.outName)) {
                return 3;
            }
        } else if (outArray != null && Main.args.outName != null) {
            OutputStream out = Main.openOutput(Main.args.outName);
            out.write(outArray);
            Main.closeOutput(out);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int runMultiDex() throws IOException {
        assert (!Main.args.incremental);
        if (Main.args.mainDexListFile != null) {
            classesInMainDex = new HashSet<String>();
            Main.readPathsFromFile(Main.args.mainDexListFile, classesInMainDex);
        }
        dexOutPool = Executors.newFixedThreadPool(Main.args.numThreads);
        if (!Main.processAllFiles()) {
            return 1;
        }
        if (!libraryDexBuffers.isEmpty()) {
            throw new DexException("Library dex files are not supported in multi-dex mode");
        }
        if (outputDex != null) {
            dexOutputFutures.add(dexOutPool.submit(new DexWriter(outputDex)));
            outputDex = null;
        }
        try {
            dexOutPool.shutdown();
            if (!dexOutPool.awaitTermination(600L, TimeUnit.SECONDS)) {
                throw new RuntimeException("Timed out waiting for dex writer threads.");
            }
            for (Future<byte[]> f : dexOutputFutures) {
                dexOutputArrays.add(f.get());
            }
        }
        catch (InterruptedException ex) {
            dexOutPool.shutdownNow();
            throw new RuntimeException("A dex writer thread has been interrupted.");
        }
        catch (Exception e) {
            dexOutPool.shutdownNow();
            throw new RuntimeException("Unexpected exception in dex writer thread");
        }
        if (Main.args.jarOutput) {
            for (int i = 0; i < dexOutputArrays.size(); ++i) {
                outputResources.put(Main.getDexFileName(i), dexOutputArrays.get(i));
            }
            if (!Main.createJar(Main.args.outName)) {
                return 3;
            }
        } else if (Main.args.outName != null) {
            File outDir = new File(Main.args.outName);
            assert (outDir.isDirectory());
            for (int i = 0; i < dexOutputArrays.size(); ++i) {
                FileOutputStream out = new FileOutputStream(new File(outDir, Main.getDexFileName(i)));
                try {
                    ((OutputStream)out).write(dexOutputArrays.get(i));
                    continue;
                }
                finally {
                    Main.closeOutput(out);
                }
            }
        }
        return 0;
    }

    private static String getDexFileName(int i) {
        if (i == 0) {
            return "classes.dex";
        }
        return DEX_PREFIX + (i + 1) + DEX_EXTENSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readPathsFromFile(String fileName, Collection<String> paths) throws IOException {
        BufferedReader bfr = null;
        try {
            String line;
            FileReader fr = new FileReader(fileName);
            bfr = new BufferedReader(fr);
            while (null != (line = bfr.readLine())) {
                paths.add(Main.fixPath(line));
            }
        }
        finally {
            if (bfr != null) {
                bfr.close();
            }
        }
    }

    private static byte[] mergeIncremental(byte[] update, File base) throws IOException {
        Dex dexA = null;
        Dex dexB = null;
        if (update != null) {
            dexA = new Dex(update);
        }
        if (base.exists()) {
            dexB = new Dex(base);
        }
        if (dexA == null && dexB == null) {
            return null;
        }
        Dex result = dexA == null ? dexB : (dexB == null ? dexA : new DexMerger(new Dex[]{dexA, dexB}, CollisionPolicy.KEEP_FIRST).merge());
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        result.writeTo(bytesOut);
        return bytesOut.toByteArray();
    }

    private static byte[] mergeLibraryDexBuffers(byte[] outArray) throws IOException {
        ArrayList<Dex> dexes = new ArrayList<Dex>();
        if (outArray != null) {
            dexes.add(new Dex(outArray));
        }
        for (byte[] libraryDex : libraryDexBuffers) {
            dexes.add(new Dex(libraryDex));
        }
        if (dexes.isEmpty()) {
            return null;
        }
        Dex merged = new DexMerger(dexes.toArray(new Dex[dexes.size()]), CollisionPolicy.FAIL).merge();
        return merged.getBytes();
    }

    /*
     * Exception decompiling
     */
    private static boolean processAllFiles() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void createDexFile() {
        outputDex = new DexFile(Main.args.dexOptions);
        if (Main.args.dumpWidth != 0) {
            outputDex.setDumpWidth(Main.args.dumpWidth);
        }
    }

    private static void rotateDexFile() {
        if (outputDex != null) {
            if (dexOutPool != null) {
                dexOutputFutures.add(dexOutPool.submit(new DexWriter(outputDex)));
            } else {
                dexOutputArrays.add(Main.writeDex(outputDex));
            }
        }
        Main.createDexFile();
    }

    private static void processOne(String pathname, ClassPathOpener.FileNameFilter filter) {
        ClassPathOpener opener = new ClassPathOpener(pathname, true, filter, new FileBytesConsumer());
        if (opener.process()) {
            Main.updateStatus(true);
        }
    }

    private static void updateStatus(boolean res) {
        anyFilesProcessed |= res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processFileBytes(String name, long lastModified, byte[] bytes) {
        boolean keepResources;
        boolean isClass = name.endsWith(".class");
        boolean isClassesDex = name.equals("classes.dex");
        boolean bl = keepResources = outputResources != null;
        if (!(isClass || isClassesDex || keepResources)) {
            if (Main.args.verbose) {
                DxConsole.out.println("ignored resource " + name);
            }
            return false;
        }
        if (Main.args.verbose) {
            DxConsole.out.println("processing " + name + "...");
        }
        String fixedName = Main.fixPath(name);
        if (isClass) {
            if (keepResources && Main.args.keepClassesInJar) {
                TreeMap<String, byte[]> treeMap = outputResources;
                synchronized (treeMap) {
                    outputResources.put(fixedName, bytes);
                }
            }
            if (lastModified < minimumFileAge) {
                return true;
            }
            Main.processClass(fixedName, bytes);
            return false;
        }
        if (isClassesDex) {
            List<byte[]> list = libraryDexBuffers;
            synchronized (list) {
                libraryDexBuffers.add(bytes);
            }
            return true;
        }
        TreeMap<String, byte[]> treeMap = outputResources;
        synchronized (treeMap) {
            outputResources.put(fixedName, bytes);
        }
        return true;
    }

    private static boolean processClass(String name, byte[] bytes) {
        if (!Main.args.coreLibrary) {
            Main.checkClassName(name);
        }
        try {
            new DirectClassFileConsumer(name, bytes, null).call(new ClassParserTask(name, bytes).call());
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception parsing classes", ex);
        }
        return true;
    }

    private static DirectClassFile parseClass(String name, byte[] bytes) {
        DirectClassFile cf = new DirectClassFile(bytes, name, Main.args.cfOptions.strictNameCheck);
        cf.setAttributeFactory(StdAttributeFactory.THE_ONE);
        cf.getMagic();
        return cf;
    }

    private static ClassDefItem translateClass(byte[] bytes, DirectClassFile cf) {
        try {
            return CfTranslator.translate(cf, bytes, Main.args.cfOptions, Main.args.dexOptions, outputDex);
        }
        catch (ParseException ex) {
            DxConsole.err.println("\ntrouble processing:");
            if (Main.args.debug) {
                ex.printStackTrace(DxConsole.err);
            } else {
                ex.printContext(DxConsole.err);
            }
            errors.incrementAndGet();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean addClassToDex(ClassDefItem clazz) {
        DexFile dexFile = outputDex;
        synchronized (dexFile) {
            outputDex.add(clazz);
        }
        return true;
    }

    private static void checkClassName(String name) {
        boolean bogus = false;
        if (name.startsWith("java/")) {
            bogus = true;
        } else if (name.startsWith("javax/")) {
            int slashAt = name.indexOf(47, 6);
            if (slashAt == -1) {
                bogus = true;
            } else {
                String pkg = name.substring(6, slashAt);
                boolean bl = bogus = Arrays.binarySearch(JAVAX_CORE, pkg) >= 0;
            }
        }
        if (!bogus) {
            return;
        }
        DxConsole.err.println("\ntrouble processing \"" + name + "\":\n\n" + IN_RE_CORE_CLASSES);
        errors.incrementAndGet();
        throw new StopProcessing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] writeDex(DexFile outputDex) {
        byte[] outArray = null;
        try {
            try {
                if (Main.args.methodToDump != null) {
                    outputDex.toDex(null, false);
                    Main.dumpMethod(outputDex, Main.args.methodToDump, humanOutWriter);
                } else {
                    outArray = outputDex.toDex(humanOutWriter, Main.args.verboseDump);
                }
                if (Main.args.statistics) {
                    DxConsole.out.println(outputDex.getStatistics().toHuman());
                }
            }
            finally {
                if (humanOutWriter != null) {
                    humanOutWriter.flush();
                }
            }
        }
        catch (Exception ex) {
            if (Main.args.debug) {
                DxConsole.err.println("\ntrouble writing output:");
                ex.printStackTrace(DxConsole.err);
            } else {
                DxConsole.err.println("\ntrouble writing output: " + ex.getMessage());
            }
            return null;
        }
        return outArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean createJar(String fileName) {
        try {
            Manifest manifest = Main.makeManifest();
            OutputStream out = Main.openOutput(fileName);
            JarOutputStream jarOut = new JarOutputStream(out, manifest);
            try {
                for (Map.Entry<String, byte[]> e : outputResources.entrySet()) {
                    String name = e.getKey();
                    byte[] contents = e.getValue();
                    JarEntry entry = new JarEntry(name);
                    int length = contents.length;
                    if (Main.args.verbose) {
                        DxConsole.out.println("writing " + name + "; size " + length + "...");
                    }
                    entry.setSize(length);
                    jarOut.putNextEntry(entry);
                    jarOut.write(contents);
                    jarOut.closeEntry();
                }
            }
            finally {
                jarOut.finish();
                jarOut.flush();
                Main.closeOutput(out);
            }
        }
        catch (Exception ex) {
            if (Main.args.debug) {
                DxConsole.err.println("\ntrouble writing output:");
                ex.printStackTrace(DxConsole.err);
            } else {
                DxConsole.err.println("\ntrouble writing output: " + ex.getMessage());
            }
            return false;
        }
        return true;
    }

    private static Manifest makeManifest() throws IOException {
        Attributes attribs;
        Manifest manifest;
        byte[] manifestBytes = outputResources.get(MANIFEST_NAME);
        if (manifestBytes == null) {
            manifest = new Manifest();
            attribs = manifest.getMainAttributes();
            attribs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        } else {
            manifest = new Manifest(new ByteArrayInputStream(manifestBytes));
            attribs = manifest.getMainAttributes();
            outputResources.remove(MANIFEST_NAME);
        }
        String createdBy = attribs.getValue(CREATED_BY);
        createdBy = createdBy == null ? "" : createdBy + " + ";
        createdBy = createdBy + "dx 1.11";
        attribs.put(CREATED_BY, createdBy);
        attribs.putValue("Dex-Location", "classes.dex");
        return manifest;
    }

    private static OutputStream openOutput(String name) throws IOException {
        if (name.equals("-") || name.startsWith("-.")) {
            return System.out;
        }
        return new FileOutputStream(name);
    }

    private static void closeOutput(OutputStream stream) throws IOException {
        if (stream == null) {
            return;
        }
        stream.flush();
        if (stream != System.out) {
            stream.close();
        }
    }

    private static String fixPath(String path) {
        int index;
        if (File.separatorChar == '\\') {
            path = path.replace('\\', '/');
        }
        if ((index = path.lastIndexOf("/./")) != -1) {
            return path.substring(index + 3);
        }
        if (path.startsWith("./")) {
            return path.substring(2);
        }
        return path;
    }

    private static void dumpMethod(DexFile dex, String fqName, OutputStreamWriter out) {
        boolean wildcard = fqName.endsWith("*");
        int lastDot = fqName.lastIndexOf(46);
        if (lastDot <= 0 || lastDot == fqName.length() - 1) {
            DxConsole.err.println("bogus fully-qualified method name: " + fqName);
            return;
        }
        String className = fqName.substring(0, lastDot).replace('.', '/');
        String methodName = fqName.substring(lastDot + 1);
        ClassDefItem clazz = dex.getClassOrNull(className);
        if (clazz == null) {
            DxConsole.err.println("no such class: " + className);
            return;
        }
        if (wildcard) {
            methodName = methodName.substring(0, methodName.length() - 1);
        }
        ArrayList<EncodedMethod> allMeths = clazz.getMethods();
        TreeMap<CstNat, EncodedMethod> meths = new TreeMap<CstNat, EncodedMethod>();
        for (EncodedMethod meth : allMeths) {
            String methName = meth.getName().getString();
            if ((!wildcard || !methName.startsWith(methodName)) && (wildcard || !methName.equals(methodName))) continue;
            meths.put(meth.getRef().getNat(), meth);
        }
        if (meths.size() == 0) {
            DxConsole.err.println("no such method: " + fqName);
            return;
        }
        PrintWriter pw = new PrintWriter(out);
        for (EncodedMethod meth : meths.values()) {
            meth.debugPrint(pw, Main.args.verboseDump);
            CstString sourceFile = clazz.getSourceFile();
            if (sourceFile != null) {
                pw.println("  source file: " + sourceFile.toQuoted());
            }
            Annotations methodAnnotations = clazz.getMethodAnnotations(meth.getRef());
            AnnotationsList parameterAnnotations = clazz.getParameterAnnotations(meth.getRef());
            if (methodAnnotations != null) {
                pw.println("  method annotations:");
                for (Annotation a : methodAnnotations.getAnnotations()) {
                    pw.println("    " + a);
                }
            }
            if (parameterAnnotations == null) continue;
            pw.println("  parameter annotations:");
            int sz = parameterAnnotations.size();
            for (int i = 0; i < sz; ++i) {
                pw.println("    parameter " + i);
                Annotations annotations = parameterAnnotations.get(i);
                for (Annotation a : annotations.getAnnotations()) {
                    pw.println("      " + a);
                }
            }
        }
        pw.flush();
    }

    static {
        libraryDexBuffers = new ArrayList<byte[]>();
        addToDexFutures = new ArrayList<Future<Boolean>>();
        dexOutputFutures = new ArrayList<Future<byte[]>>();
        dexRotationLock = new Object();
        maxMethodIdsInProcess = 0;
        maxFieldIdsInProcess = 0;
        minimumFileAge = 0L;
        classesInMainDex = null;
        dexOutputArrays = new ArrayList<byte[]>();
        humanOutWriter = null;
    }

    private static class DexWriter
    implements Callable<byte[]> {
        private DexFile dexFile;

        private DexWriter(DexFile dexFile) {
            this.dexFile = dexFile;
        }

        @Override
        public byte[] call() throws IOException {
            return Main.writeDex(this.dexFile);
        }
    }

    private static class ClassDefItemConsumer
    implements Callable<Boolean> {
        String name;
        Future<ClassDefItem> futureClazz;
        int maxMethodIdsInClass;
        int maxFieldIdsInClass;

        private ClassDefItemConsumer(String name, Future<ClassDefItem> futureClazz, int maxMethodIdsInClass, int maxFieldIdsInClass) {
            this.name = name;
            this.futureClazz = futureClazz;
            this.maxMethodIdsInClass = maxMethodIdsInClass;
            this.maxFieldIdsInClass = maxFieldIdsInClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            try {
                ClassDefItem clazz = this.futureClazz.get();
                if (clazz != null) {
                    Main.addClassToDex(clazz);
                    Main.updateStatus(true);
                }
                Boolean bl = true;
                return bl;
            }
            catch (ExecutionException ex) {
                Throwable t = ex.getCause();
                throw t instanceof Exception ? (Exception)t : ex;
            }
            finally {
                if (args.multiDex) {
                    Object object = dexRotationLock;
                    synchronized (object) {
                        maxMethodIdsInProcess -= this.maxMethodIdsInClass;
                        maxFieldIdsInProcess -= this.maxFieldIdsInClass;
                        dexRotationLock.notifyAll();
                    }
                }
            }
        }
    }

    private static class ClassTranslatorTask
    implements Callable<ClassDefItem> {
        String name;
        byte[] bytes;
        DirectClassFile classFile;

        private ClassTranslatorTask(String name, byte[] bytes, DirectClassFile classFile) {
            this.name = name;
            this.bytes = bytes;
            this.classFile = classFile;
        }

        @Override
        public ClassDefItem call() {
            ClassDefItem clazz = Main.translateClass(this.bytes, this.classFile);
            return clazz;
        }
    }

    private static class DirectClassFileConsumer
    implements Callable<Boolean> {
        String name;
        byte[] bytes;
        Future<DirectClassFile> dcff;

        private DirectClassFileConsumer(String name, byte[] bytes, Future<DirectClassFile> dcff) {
            this.name = name;
            this.bytes = bytes;
            this.dcff = dcff;
        }

        @Override
        public Boolean call() throws Exception {
            DirectClassFile cf = this.dcff.get();
            return this.call(cf);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Boolean call(DirectClassFile cf) {
            int maxMethodIdsInClass = 0;
            int maxFieldIdsInClass = 0;
            if (args.multiDex) {
                int constantPoolSize = cf.getConstantPool().size();
                maxMethodIdsInClass = constantPoolSize + cf.getMethods().size() + 2;
                maxFieldIdsInClass = constantPoolSize + cf.getFields().size() + 9;
                Object object = dexRotationLock;
                synchronized (object) {
                    int numFieldIds;
                    int numMethodIds;
                    DexFile dexFile = outputDex;
                    synchronized (dexFile) {
                        numMethodIds = outputDex.getMethodIds().items().size();
                        numFieldIds = outputDex.getFieldIds().items().size();
                    }
                    while (numMethodIds + maxMethodIdsInClass + maxMethodIdsInProcess > args.maxNumberOfIdxPerDex || numFieldIds + maxFieldIdsInClass + maxFieldIdsInProcess > args.maxNumberOfIdxPerDex) {
                        if (maxMethodIdsInProcess > 0 || maxFieldIdsInProcess > 0) {
                            try {
                                dexRotationLock.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        } else {
                            if (outputDex.getClassDefs().items().size() <= 0) break;
                            Main.rotateDexFile();
                        }
                        dexFile = outputDex;
                        synchronized (dexFile) {
                            numMethodIds = outputDex.getMethodIds().items().size();
                            numFieldIds = outputDex.getFieldIds().items().size();
                        }
                    }
                    maxMethodIdsInProcess += maxMethodIdsInClass;
                    maxFieldIdsInProcess += maxFieldIdsInClass;
                }
            }
            Future<ClassDefItem> cdif = classTranslatorPool.submit(new ClassTranslatorTask(this.name, this.bytes, cf));
            Future<Boolean> res = classDefItemConsumer.submit(new ClassDefItemConsumer(this.name, cdif, maxMethodIdsInClass, maxFieldIdsInClass));
            addToDexFutures.add(res);
            return true;
        }
    }

    private static class ClassParserTask
    implements Callable<DirectClassFile> {
        String name;
        byte[] bytes;

        private ClassParserTask(String name, byte[] bytes) {
            this.name = name;
            this.bytes = bytes;
        }

        @Override
        public DirectClassFile call() throws Exception {
            DirectClassFile cf = Main.parseClass(this.name, this.bytes);
            return cf;
        }
    }

    private static class FileBytesConsumer
    implements ClassPathOpener.Consumer {
        private FileBytesConsumer() {
        }

        @Override
        public boolean processFileBytes(String name, long lastModified, byte[] bytes) {
            return Main.processFileBytes(name, lastModified, bytes);
        }

        @Override
        public void onException(Exception ex) {
            if (ex instanceof StopProcessing) {
                throw (StopProcessing)ex;
            }
            if (ex instanceof SimException) {
                DxConsole.err.println("\nEXCEPTION FROM SIMULATION:");
                DxConsole.err.println(ex.getMessage() + "\n");
                DxConsole.err.println(((SimException)ex).getContext());
            } else {
                DxConsole.err.println("\nUNEXPECTED TOP-LEVEL EXCEPTION:");
                ex.printStackTrace(DxConsole.err);
            }
            errors.incrementAndGet();
        }

        @Override
        public void onProcessArchiveStart(File file) {
            if (args.verbose) {
                DxConsole.out.println("processing archive " + file + "...");
            }
        }
    }

    public static class Arguments {
        private static final String MINIMAL_MAIN_DEX_OPTION = "--minimal-main-dex";
        private static final String MAIN_DEX_LIST_OPTION = "--main-dex-list";
        private static final String MULTI_DEX_OPTION = "--multi-dex";
        private static final String NUM_THREADS_OPTION = "--num-threads";
        private static final String INCREMENTAL_OPTION = "--incremental";
        private static final String INPUT_LIST_OPTION = "--input-list";
        public boolean debug = false;
        public boolean warnings = true;
        public boolean verbose = false;
        public boolean verboseDump = false;
        public boolean coreLibrary = false;
        public String methodToDump = null;
        public int dumpWidth = 0;
        public String outName = null;
        public String humanOutName = null;
        public boolean strictNameCheck = true;
        public boolean emptyOk = false;
        public boolean jarOutput = false;
        public boolean keepClassesInJar = false;
        public int positionInfo = 2;
        public boolean localInfo = true;
        public boolean incremental = false;
        public boolean forceJumbo = false;
        public String[] fileNames;
        public boolean optimize = true;
        public String optimizeListFile = null;
        public String dontOptimizeListFile = null;
        public boolean statistics;
        public CfOptions cfOptions;
        public DexOptions dexOptions;
        public int numThreads = 1;
        public boolean multiDex = false;
        public String mainDexListFile = null;
        public boolean minimalMainDex = false;
        private List<String> inputList = null;
        private int maxNumberOfIdxPerDex = 65536;

        public void parse(String[] args) {
            ArgumentsParser parser = new ArgumentsParser(args);
            boolean outputIsDirectory = false;
            boolean outputIsDirectDex = false;
            while (parser.getNext()) {
                if (parser.isArg("--debug")) {
                    this.debug = true;
                    continue;
                }
                if (parser.isArg("--no-warning")) {
                    this.warnings = false;
                    continue;
                }
                if (parser.isArg("--verbose")) {
                    this.verbose = true;
                    continue;
                }
                if (parser.isArg("--verbose-dump")) {
                    this.verboseDump = true;
                    continue;
                }
                if (parser.isArg("--no-files")) {
                    this.emptyOk = true;
                    continue;
                }
                if (parser.isArg("--no-optimize")) {
                    this.optimize = false;
                    continue;
                }
                if (parser.isArg("--no-strict")) {
                    this.strictNameCheck = false;
                    continue;
                }
                if (parser.isArg("--core-library")) {
                    this.coreLibrary = true;
                    continue;
                }
                if (parser.isArg("--statistics")) {
                    this.statistics = true;
                    continue;
                }
                if (parser.isArg("--optimize-list=")) {
                    if (this.dontOptimizeListFile != null) {
                        System.err.println("--optimize-list and --no-optimize-list are incompatible.");
                        throw new UsageException();
                    }
                    this.optimize = true;
                    this.optimizeListFile = parser.getLastValue();
                    continue;
                }
                if (parser.isArg("--no-optimize-list=")) {
                    if (this.dontOptimizeListFile != null) {
                        System.err.println("--optimize-list and --no-optimize-list are incompatible.");
                        throw new UsageException();
                    }
                    this.optimize = true;
                    this.dontOptimizeListFile = parser.getLastValue();
                    continue;
                }
                if (parser.isArg("--keep-classes")) {
                    this.keepClassesInJar = true;
                    continue;
                }
                if (parser.isArg("--output=")) {
                    this.outName = parser.getLastValue();
                    if (new File(this.outName).isDirectory()) {
                        this.jarOutput = false;
                        outputIsDirectory = true;
                        continue;
                    }
                    if (FileUtils.hasArchiveSuffix(this.outName)) {
                        this.jarOutput = true;
                        continue;
                    }
                    if (this.outName.endsWith(Main.DEX_EXTENSION) || this.outName.equals("-")) {
                        this.jarOutput = false;
                        outputIsDirectDex = true;
                        continue;
                    }
                    System.err.println("unknown output extension: " + this.outName);
                    throw new UsageException();
                }
                if (parser.isArg("--dump-to=")) {
                    this.humanOutName = parser.getLastValue();
                    continue;
                }
                if (parser.isArg("--dump-width=")) {
                    this.dumpWidth = Integer.parseInt(parser.getLastValue());
                    continue;
                }
                if (parser.isArg("--dump-method=")) {
                    this.methodToDump = parser.getLastValue();
                    this.jarOutput = false;
                    continue;
                }
                if (parser.isArg("--positions=")) {
                    String pstr = parser.getLastValue().intern();
                    if (pstr == "none") {
                        this.positionInfo = 1;
                        continue;
                    }
                    if (pstr == "important") {
                        this.positionInfo = 3;
                        continue;
                    }
                    if (pstr == "lines") {
                        this.positionInfo = 2;
                        continue;
                    }
                    System.err.println("unknown positions option: " + pstr);
                    throw new UsageException();
                }
                if (parser.isArg("--no-locals")) {
                    this.localInfo = false;
                    continue;
                }
                if (parser.isArg("--num-threads=")) {
                    this.numThreads = Integer.parseInt(parser.getLastValue());
                    continue;
                }
                if (parser.isArg(INCREMENTAL_OPTION)) {
                    this.incremental = true;
                    continue;
                }
                if (parser.isArg("--force-jumbo")) {
                    this.forceJumbo = true;
                    continue;
                }
                if (parser.isArg(MULTI_DEX_OPTION)) {
                    this.multiDex = true;
                    continue;
                }
                if (parser.isArg("--main-dex-list=")) {
                    this.mainDexListFile = parser.getLastValue();
                    continue;
                }
                if (parser.isArg(MINIMAL_MAIN_DEX_OPTION)) {
                    this.minimalMainDex = true;
                    continue;
                }
                if (parser.isArg("--set-max-idx-number=")) {
                    this.maxNumberOfIdxPerDex = Integer.parseInt(parser.getLastValue());
                    continue;
                }
                if (parser.isArg("--input-list=")) {
                    File inputListFile = new File(parser.getLastValue());
                    try {
                        this.inputList = new ArrayList<String>();
                        Main.readPathsFromFile(inputListFile.getAbsolutePath(), this.inputList);
                        continue;
                    }
                    catch (IOException e) {
                        System.err.println("Unable to read input list file: " + inputListFile.getName());
                        throw new UsageException();
                    }
                }
                System.err.println("unknown option: " + parser.getCurrent());
                throw new UsageException();
            }
            this.fileNames = parser.getRemaining();
            if (this.inputList != null && !this.inputList.isEmpty()) {
                this.inputList.addAll(Arrays.asList(this.fileNames));
                this.fileNames = this.inputList.toArray(new String[this.inputList.size()]);
            }
            if (this.fileNames.length == 0) {
                if (!this.emptyOk) {
                    System.err.println("no input files specified");
                    throw new UsageException();
                }
            } else if (this.emptyOk) {
                System.out.println("ignoring input files");
            }
            if (this.humanOutName == null && this.methodToDump != null) {
                this.humanOutName = "-";
            }
            if (this.mainDexListFile != null && !this.multiDex) {
                System.err.println("--main-dex-list is only supported in combination with --multi-dex");
                throw new UsageException();
            }
            if (this.minimalMainDex && (this.mainDexListFile == null || !this.multiDex)) {
                System.err.println("--minimal-main-dex is only supported in combination with --multi-dex and --main-dex-list");
                throw new UsageException();
            }
            if (this.multiDex && this.incremental) {
                System.err.println("--incremental is not supported with --multi-dex");
                throw new UsageException();
            }
            if (this.multiDex && outputIsDirectDex) {
                System.err.println("Unsupported output \"" + this.outName + "\". " + MULTI_DEX_OPTION + " supports only archive or directory output");
                throw new UsageException();
            }
            if (outputIsDirectory && !this.multiDex) {
                this.outName = new File(this.outName, "classes.dex").getPath();
            }
            this.makeOptionsObjects();
        }

        private void makeOptionsObjects() {
            this.cfOptions = new CfOptions();
            this.cfOptions.positionInfo = this.positionInfo;
            this.cfOptions.localInfo = this.localInfo;
            this.cfOptions.strictNameCheck = this.strictNameCheck;
            this.cfOptions.optimize = this.optimize;
            this.cfOptions.optimizeListFile = this.optimizeListFile;
            this.cfOptions.dontOptimizeListFile = this.dontOptimizeListFile;
            this.cfOptions.statistics = this.statistics;
            this.cfOptions.warn = this.warnings ? DxConsole.err : DxConsole.noop;
            this.dexOptions = new DexOptions();
            this.dexOptions.forceJumbo = this.forceJumbo;
        }

        private static class ArgumentsParser {
            private final String[] arguments;
            private int index;
            private String current;
            private String lastValue;

            public ArgumentsParser(String[] arguments) {
                this.arguments = arguments;
                this.index = 0;
            }

            public String getCurrent() {
                return this.current;
            }

            public String getLastValue() {
                return this.lastValue;
            }

            public boolean getNext() {
                if (this.index >= this.arguments.length) {
                    return false;
                }
                this.current = this.arguments[this.index];
                if (this.current.equals("--") || !this.current.startsWith("--")) {
                    return false;
                }
                ++this.index;
                return true;
            }

            private boolean getNextValue() {
                if (this.index >= this.arguments.length) {
                    return false;
                }
                this.current = this.arguments[this.index];
                ++this.index;
                return true;
            }

            public String[] getRemaining() {
                int n = this.arguments.length - this.index;
                String[] remaining = new String[n];
                if (n > 0) {
                    System.arraycopy(this.arguments, this.index, remaining, 0, n);
                }
                return remaining;
            }

            public boolean isArg(String prefix) {
                int n = prefix.length();
                if (n > 0 && prefix.charAt(n - 1) == '=') {
                    if (this.current.startsWith(prefix)) {
                        this.lastValue = this.current.substring(n);
                        return true;
                    }
                    if (this.current.equals(prefix = prefix.substring(0, n - 1))) {
                        if (this.getNextValue()) {
                            this.lastValue = this.current;
                            return true;
                        }
                        System.err.println("Missing value after parameter " + prefix);
                        throw new UsageException();
                    }
                    return false;
                }
                return this.current.equals(prefix);
            }
        }
    }

    private static class StopProcessing
    extends RuntimeException {
        private StopProcessing() {
        }
    }

    private static class BestEffortMainDexListFilter
    implements ClassPathOpener.FileNameFilter {
        Map<String, List<String>> map = new HashMap<String, List<String>>();

        public BestEffortMainDexListFilter() {
            for (String pathOfClass : classesInMainDex) {
                String normalized = Main.fixPath(pathOfClass);
                String simple = BestEffortMainDexListFilter.getSimpleName(normalized);
                List<String> fullPath = this.map.get(simple);
                if (fullPath == null) {
                    fullPath = new ArrayList<String>(1);
                    this.map.put(simple, fullPath);
                }
                fullPath.add(normalized);
            }
        }

        @Override
        public boolean accept(String path) {
            if (path.endsWith(".class")) {
                String normalized = Main.fixPath(path);
                String simple = BestEffortMainDexListFilter.getSimpleName(normalized);
                List<String> fullPaths = this.map.get(simple);
                if (fullPaths != null) {
                    for (String fullPath : fullPaths) {
                        if (!normalized.endsWith(fullPath)) continue;
                        return true;
                    }
                }
                return false;
            }
            return true;
        }

        private static String getSimpleName(String path) {
            int index = path.lastIndexOf(47);
            if (index >= 0) {
                return path.substring(index + 1);
            }
            return path;
        }
    }

    private static class MainDexListFilter
    implements ClassPathOpener.FileNameFilter {
        private MainDexListFilter() {
        }

        @Override
        public boolean accept(String fullPath) {
            if (fullPath.endsWith(".class")) {
                String path = Main.fixPath(fullPath);
                return classesInMainDex.contains(path);
            }
            return true;
        }
    }

    private static class NotFilter
    implements ClassPathOpener.FileNameFilter {
        private final ClassPathOpener.FileNameFilter filter;

        private NotFilter(ClassPathOpener.FileNameFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean accept(String path) {
            return !this.filter.accept(path);
        }
    }
}

