/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.coverage;

import com.android.jack.coverage.CoveragePattern;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class CoverageFilterSet {
    @Nonnull
    private final List<CoveragePattern> patterns = new ArrayList<CoveragePattern>();

    public void addPattern(@Nonnull CoveragePattern pattern) {
        assert (pattern != null);
        if (!this.patterns.contains(pattern)) {
            this.patterns.add(pattern);
        }
    }

    @Nonnull
    public List<CoveragePattern> getPatterns() {
        return this.patterns;
    }

    public boolean isEmpty() {
        return this.patterns.isEmpty();
    }

    public boolean matchesAny(@Nonnull String className) {
        for (CoveragePattern pattern : this.patterns) {
            if (!pattern.matchesAny(className)) continue;
            return true;
        }
        return false;
    }

    public CoverageFilterSet makeCopy() {
        CoverageFilterSet copy = new CoverageFilterSet();
        for (CoveragePattern cp : this.getPatterns()) {
            copy.addPattern(cp);
        }
        return copy;
    }
}

