/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.util;

import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.ow2.asmdex.ApplicationReader;
import org.ow2.asmdex.ApplicationVisitor;
import org.ow2.asmdex.ClassVisitor;
import org.ow2.asmdex.util.AsmDexPrinter;
import org.ow2.asmdex.util.AsmDexifierClassVisitor;
import org.ow2.asmdex.util.TextComposite;
import org.ow2.asmdex.util.TextLeaf;

public class AsmDexifierApplicationVisitor
extends ApplicationVisitor {
    private final AsmDexPrinter pr;
    public static final String OPCODES_FULLY_QUALIFIED_NAME = "org.ow2.asmdex.Opcodes";
    private static final String OPCODES_START = "INSN_";
    private String packageName = null;
    private String filenameOutput = null;
    private static final int NB_OPCODES = 256;
    protected final PrintWriter pw;
    private static String dexFileName;
    private static String[] classesToVisit;
    private static String[] opcodeNames;
    private ArrayList<String> dumpMethods;
    private TextComposite methodToCall;

    public AsmDexifierApplicationVisitor(int api, PrintWriter pw) {
        super(api);
        this.pw = pw;
        this.pr = new AsmDexPrinter();
        this.dumpMethods = new ArrayList();
        this.methodToCall = new TextComposite();
    }

    public AsmDexifierApplicationVisitor(int api, PrintWriter pw, String packageName, String filenameOutput) {
        this(api, pw);
        this.packageName = packageName;
        this.filenameOutput = filenameOutput;
    }

    public static void main(String[] args) throws Exception {
        Field[] fields;
        boolean ok;
        int i = 0;
        int flags = 2;
        int nbArgs = args.length;
        boolean bl = ok = nbArgs > 0;
        if (ok && "-debug".equals(args[0])) {
            i = 1;
            flags = 0;
            if (nbArgs < 2) {
                ok = false;
            }
        }
        if (!ok || !args[i].endsWith(".dex")) {
            System.err.println("Prints the AsmDex code to generate the given class.");
            System.err.println("Usage: ASMifierApplicationVisitor [-debug] <Dex file to open> [<fully qualified class names>]");
            return;
        }
        classesToVisit = null;
        if (nbArgs > i + 1) {
            int nbClasses = nbArgs - i - 1;
            classesToVisit = new String[nbClasses];
            int classIndex = 0;
            int j = i + 1;
            while (j < nbArgs) {
                AsmDexifierApplicationVisitor.classesToVisit[classIndex++] = args[j];
                ++j;
            }
        }
        dexFileName = AsmDexifierApplicationVisitor.trimDexFileName(args[i]);
        opcodeNames = new String[256];
        Field[] fieldArray = fields = Class.forName(OPCODES_FULLY_QUALIFIED_NAME).getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            int opcode;
            Field field = fieldArray[n2];
            String fieldName = field.getName();
            int goodFlag = 25;
            if (fieldName.startsWith(OPCODES_START) && field.getModifiers() == goodFlag && (opcode = field.getInt(field)) < 256) {
                AsmDexifierApplicationVisitor.opcodeNames[opcode] = fieldName;
            }
            ++n2;
        }
        ApplicationReader ar = new ApplicationReader(262144, args[i]);
        ar.accept(new AsmDexifierApplicationVisitor(262144, new PrintWriter(System.out)), classesToVisit, flags);
    }

    public static String trimDexFileName(String fullFileName) {
        String trimmedFileName = fullFileName;
        int n = trimmedFileName.lastIndexOf(".dex");
        if (n != -1) {
            trimmedFileName = trimmedFileName.substring(0, n);
        }
        if ((n = trimmedFileName.lastIndexOf(47)) != -1) {
            trimmedFileName = trimmedFileName.substring(n + 1);
        }
        return trimmedFileName;
    }

    public static void setDexFileName(String name) {
        dexFileName = name;
    }

    @Override
    public void visit() {
        char firstLetter = Character.toUpperCase(dexFileName.charAt(0));
        String otherLetters = dexFileName.length() > 1 ? dexFileName.substring(1) : "";
        String camelName = String.valueOf(firstLetter) + otherLetters;
        if (this.packageName != null) {
            this.pr.addText("package " + this.packageName + ";\n");
            this.pr.addEOL();
        }
        this.pr.addText("import java.util.*;\n");
        if (this.filenameOutput != null) {
            this.pr.addText("import java.io.*;\n");
        }
        this.pr.addText("import org.ow2.asmdex.*;\n");
        this.pr.addText("import org.ow2.asmdex.structureCommon.*;\n\n");
        this.pr.addText("public class " + camelName + "Dump implements Opcodes {\n\n");
        if (this.filenameOutput != null) {
            this.pr.addText("public static void main(String[] args) throws Exception {\n");
            this.pr.addText("\tbyte[] b = dump();\n");
            this.pr.addText("\tFile outputFile;\n");
            this.pr.addText("\tif (args.length == 1) {\n");
            this.pr.addText("\t\toutputFile = new File(args[0]);\n");
            this.pr.addText("\t\tFileOutputStream outputStream = new FileOutputStream(outputFile);\n");
            this.pr.addText("\t\toutputStream.write(b);\n");
            this.pr.addText("\t\toutputStream.close();\n");
            this.pr.addText("\t}\n");
            this.pr.addText("}\n\n");
        }
        this.pr.addText("public static byte[] dump() throws Exception {\n\n");
        this.pr.addText("\tApplicationWriter aw = new ApplicationWriter();\n");
        this.pr.addText("\taw.visit();\n");
        this.pr.addEOL();
        this.pr.closeText();
        this.pr.addTextToList(this.methodToCall);
        this.pr.addEOL();
        this.pr.addText("\taw.visitEnd();\n\n");
        this.pr.addText("\treturn aw.toByteArray();\n");
        this.pr.addText("}\n\n");
        this.pr.closeText();
    }

    @Override
    public ClassVisitor visitClass(int access, String name, String[] signature, String superName, String[] interfaces) {
        String className = this.getAcceptableMethodName(name);
        this.pr.addText("public static void ");
        this.pr.addText(className);
        this.pr.addText("(ApplicationWriter aw) {\n");
        this.pr.addText("\tClassVisitor cv;\n");
        this.pr.addText("\tFieldVisitor fv;\n");
        this.pr.addText("\tMethodVisitor mv;\n");
        this.pr.addText("\tAnnotationVisitor av0;\n\n");
        this.pr.addText("\tcv = aw.visitClass(");
        this.pr.addAccessFlags(access, true);
        this.pr.addConstant(name, true);
        this.pr.addConstant(signature, true);
        this.pr.addConstant(superName, true);
        this.pr.addConstant(interfaces, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
        AsmDexifierClassVisitor cv = new AsmDexifierClassVisitor(this.api, 1);
        this.pr.addTextToList(cv.getTextComponent());
        this.pr.addText("}\n\n");
        this.pr.closeText();
        return cv;
    }

    @Override
    public void visitEnd() {
        this.pr.addText("}\n\n");
        this.pr.closeText();
        for (String methodName : this.dumpMethods) {
            StringBuffer sb = new StringBuffer("\t" + methodName);
            sb.append("(aw);\n");
            TextLeaf leaf = new TextLeaf(sb);
            this.methodToCall.addComponent(leaf);
        }
        this.pr.getTextComponent().print(this.pw);
        this.pw.flush();
    }

    public static String getOpcodeName(int opcode) {
        String result = null;
        if (opcodeNames != null && opcode < opcodeNames.length) {
            result = opcodeNames[opcode];
        }
        return result;
    }

    public String getAcceptableMethodName(String className) {
        int i;
        String result = "Method";
        if (className != null && !className.equals("") && (i = (result = (i = className.lastIndexOf(47)) >= 0 ? className.substring(i + 1) : className).lastIndexOf(59)) > 0) {
            result = result.substring(0, i);
        }
        if (this.dumpMethods.contains(result = "dump" + result)) {
            boolean stillFound = true;
            int i2 = 2;
            String newResult = null;
            while (stillFound) {
                newResult = String.valueOf(result) + i2;
                stillFound = this.dumpMethods.contains(newResult);
                ++i2;
            }
            result = newResult;
        }
        this.dumpMethods.add(result);
        return result;
    }
}

