/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.util;

import org.ow2.asmdex.AnnotationVisitor;
import org.ow2.asmdex.util.AsmDexPrinter;
import org.ow2.asmdex.util.TextComponent;

public class AsmDexifierAnnotationVisitor
extends AnnotationVisitor {
    protected final int id;
    private final AsmDexPrinter pr;

    public AsmDexifierAnnotationVisitor(int api, int id, int nbTabulations) {
        super(api);
        this.id = id;
        this.pr = new AsmDexPrinter();
        this.pr.currentTabulation = nbTabulations;
    }

    @Override
    public void visit(String name, Object value) {
        this.pr.addTabulation();
        this.pr.addText("av");
        this.pr.addNumber(this.id, false);
        this.pr.addText(".visit(");
        this.pr.addConstant(name, true);
        this.pr.addConstant(value, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, String desc) {
        this.pr.addTabulation();
        this.pr.addText("{\n");
        this.pr.addTabulation();
        this.pr.addText("\tAnnotationVisitor av");
        this.pr.addNumber(this.id + 1, false);
        this.pr.addText(" = ");
        this.pr.addText("av");
        this.pr.addNumber(this.id, false);
        this.pr.addText(".visitAnnotation(");
        this.pr.addConstant(name, true);
        this.pr.addConstant(desc, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
        AsmDexifierAnnotationVisitor av = new AsmDexifierAnnotationVisitor(this.api, this.id + 1, this.pr.currentTabulation + 1);
        this.pr.addTextToList(av.getTextComponent());
        this.pr.addTabulation();
        this.pr.addText("}\n");
        this.pr.closeText();
        return av;
    }

    TextComponent getTextComponent() {
        return this.pr.getTextComponent();
    }

    @Override
    public AnnotationVisitor visitArray(String name) {
        this.pr.addTabulation();
        this.pr.addText("{\n");
        this.pr.addTabulation();
        this.pr.addText("\tAnnotationVisitor av");
        this.pr.addNumber(this.id + 1, false);
        this.pr.addText(" = ");
        this.pr.addText("av");
        this.pr.addNumber(this.id, false);
        this.pr.addText(".visitArray(");
        this.pr.addConstant(name, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
        AsmDexifierAnnotationVisitor av = new AsmDexifierAnnotationVisitor(this.api, this.id + 1, this.pr.currentTabulation + 1);
        this.pr.addTextToList(av.getTextComponent());
        this.pr.addTabulation();
        this.pr.addText("}\n");
        this.pr.closeText();
        return av;
    }

    @Override
    public void visitEnd() {
        this.pr.addTabulation();
        this.pr.addText("av");
        this.pr.addNumber(this.id, false);
        this.pr.addText(".visitEnd();");
        this.pr.addEOL();
        this.pr.closeText();
    }

    @Override
    public void visitEnum(String name, String desc, String value) {
        this.pr.addTabulation();
        this.pr.addText("av");
        this.pr.addNumber(this.id, false);
        this.pr.addText(".visitEnum(");
        this.pr.addConstant(name, true);
        this.pr.addConstant(desc, true);
        this.pr.addConstant(value, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
    }

    @Override
    public void visitClass(String annotationName, String className) {
        this.pr.addTabulation();
        this.pr.addText("av");
        this.pr.addNumber(this.id, false);
        this.pr.addText(".visitClass(");
        this.pr.addConstant(annotationName, true);
        this.pr.addConstant(className, false);
        this.pr.addText(");");
        this.pr.addEOL();
        this.pr.closeText();
    }
}

