/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ow2.asmdex.AnnotationVisitor;
import org.ow2.asmdex.ClassVisitor;
import org.ow2.asmdex.MethodVisitor;
import org.ow2.asmdex.structureCommon.Label;
import org.ow2.asmdex.structureWriter.Prototype;
import org.ow2.asmdex.tree.AnnotationNode;
import org.ow2.asmdex.tree.ArrayLengthInsnNode;
import org.ow2.asmdex.tree.ArrayOperationInsnNode;
import org.ow2.asmdex.tree.FieldInsnNode;
import org.ow2.asmdex.tree.FillArrayDataInsnNode;
import org.ow2.asmdex.tree.InsnList;
import org.ow2.asmdex.tree.InsnNode;
import org.ow2.asmdex.tree.IntInsnNode;
import org.ow2.asmdex.tree.JumpInsnNode;
import org.ow2.asmdex.tree.LabelNode;
import org.ow2.asmdex.tree.LineNumberNode;
import org.ow2.asmdex.tree.LocalVariableNode;
import org.ow2.asmdex.tree.LookupSwitchInsnNode;
import org.ow2.asmdex.tree.MethodInsnNode;
import org.ow2.asmdex.tree.MultiANewArrayInsnNode;
import org.ow2.asmdex.tree.OperationInsnNode;
import org.ow2.asmdex.tree.StringInsnNode;
import org.ow2.asmdex.tree.TableSwitchInsnNode;
import org.ow2.asmdex.tree.TryCatchBlockNode;
import org.ow2.asmdex.tree.TypeInsnNode;
import org.ow2.asmdex.tree.VarInsnLongNode;
import org.ow2.asmdex.tree.VarInsnNode;

public class MethodNode
extends MethodVisitor {
    public int access;
    public String name;
    public String desc;
    public String[] signature;
    public String[] parameters;
    public List<String> exceptions;
    public Object annotationDefault;
    public List<List<AnnotationNode>> visibleParameterAnnotations;
    public List<List<AnnotationNode>> invisibleParameterAnnotations;
    public List<AnnotationNode> visibleAnnotations;
    public List<AnnotationNode> invisibleAnnotations;
    public InsnList instructions = new InsnList();
    public List<TryCatchBlockNode> tryCatchBlocks;
    public int maxStack;
    public List<LocalVariableNode> localVariables;

    public MethodNode(int api) {
        super(api);
    }

    public MethodNode(int api, int access, String name, String desc, String[] signature, String[] exceptions) {
        this(api);
        boolean isAbstract;
        this.access = access;
        this.name = name;
        this.desc = desc;
        this.signature = signature;
        if (exceptions != null) {
            this.exceptions = new ArrayList<String>(exceptions.length);
            this.exceptions.addAll(Arrays.asList(exceptions));
        }
        boolean bl = isAbstract = (access & 0x400) != 0;
        if (!isAbstract) {
            this.localVariables = new ArrayList<LocalVariableNode>(5);
        }
        this.tryCatchBlocks = new ArrayList<TryCatchBlockNode>();
    }

    public MethodNode(int access, String name, String desc, String[] signature, String[] exceptions) {
        this(262144, access, name, desc, signature, exceptions);
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        AnnotationNode an = new AnnotationNode((List<Object>)new ArrayList<Object>(0){
            private static final long serialVersionUID = -8912565660163841010L;

            @Override
            public boolean add(Object o) {
                MethodNode.this.annotationDefault = o;
                return super.add(o);
            }
        });
        an.desc = this.name;
        return an;
    }

    @Override
    public void visitArrayLengthInsn(int destinationRegister, int arrayReferenceBearing) {
        this.instructions.add(new ArrayLengthInsnNode(destinationRegister, arrayReferenceBearing));
    }

    @Override
    public void visitArrayOperationInsn(int opcode, int valueRegister, int arrayRegister, int indexRegister) {
        this.instructions.add(new ArrayOperationInsnNode(opcode, valueRegister, arrayRegister, indexRegister));
    }

    @Override
    public void visitCode() {
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc, int valueRegister, int objectRegister) {
        this.instructions.add(new FieldInsnNode(opcode, owner, name, desc, valueRegister, objectRegister));
    }

    @Override
    public void visitFillArrayDataInsn(int arrayReference, Object[] arrayData) {
        this.instructions.add(new FillArrayDataInsnNode(arrayReference, arrayData));
    }

    @Override
    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
    }

    @Override
    public void visitInsn(int opcode) {
        this.instructions.add(new InsnNode(opcode));
    }

    @Override
    public void visitIntInsn(int opcode, int register) {
        this.instructions.add(new IntInsnNode(opcode, register));
    }

    @Override
    public void visitJumpInsn(int opcode, Label label, int registerA, int registerB) {
        this.instructions.add(new JumpInsnNode(opcode, this.getLabelNode(label), registerA, registerB));
    }

    @Override
    public void visitLabel(Label label) {
        this.instructions.add(this.getLabelNode(label));
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        this.instructions.add(new LineNumberNode(line, this.getLabelNode(start)));
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.localVariables.add(new LocalVariableNode(name, desc, signature, this.getLabelNode(start), this.getLabelNode(end), index));
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, List<Label> ends, List<Label> restarts, int index) {
        this.localVariables.add(new LocalVariableNode(name, desc, signature, this.getLabelNode(start), this.getLabelNodes(ends), this.getLabelNodes(restarts), index));
    }

    @Override
    public void visitLookupSwitchInsn(int register, Label dflt, int[] keys, Label[] labels) {
        this.instructions.add(new LookupSwitchInsnNode(register, this.getLabelNode(dflt), keys, this.getLabelNodes(labels)));
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        this.maxStack = maxStack;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, int[] arguments) {
        this.instructions.add(new MethodInsnNode(opcode, owner, name, desc, arguments));
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int[] registers) {
        this.instructions.add(new MultiANewArrayInsnNode(desc, registers));
    }

    @Override
    public void visitOperationInsn(int opcode, int destinationRegister, int firstSourceRegister, int secondSourceRegister, int value) {
        this.instructions.add(new OperationInsnNode(opcode, destinationRegister, firstSourceRegister, secondSourceRegister, value));
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        AnnotationNode an = new AnnotationNode(desc);
        if (visible) {
            if (this.visibleParameterAnnotations == null) {
                int params = Prototype.getNbParametersFromTypeDescriptor(this.desc);
                this.visibleParameterAnnotations = new ArrayList<List<AnnotationNode>>(params);
                int i = 0;
                while (i < params) {
                    this.visibleParameterAnnotations.add(null);
                    ++i;
                }
            }
            if (this.visibleParameterAnnotations.get(parameter) == null) {
                this.visibleParameterAnnotations.set(parameter, new ArrayList(1));
            }
            this.visibleParameterAnnotations.get(parameter).add(an);
        } else {
            if (this.invisibleParameterAnnotations == null) {
                int params = Prototype.getNbParametersFromTypeDescriptor(this.desc);
                this.invisibleParameterAnnotations = new ArrayList<List<AnnotationNode>>(params);
                int i = 0;
                while (i < params) {
                    this.invisibleParameterAnnotations.add(null);
                    ++i;
                }
            }
            if (this.invisibleParameterAnnotations.get(parameter) == null) {
                this.invisibleParameterAnnotations.set(parameter, new ArrayList(1));
            }
            this.invisibleParameterAnnotations.get(parameter).add(an);
        }
        return an;
    }

    @Override
    public void visitParameters(String[] parameters) {
        this.parameters = parameters;
    }

    @Override
    public void visitStringInsn(int opcode, int destinationRegister, String string) {
        this.instructions.add(new StringInsnNode(opcode, destinationRegister, string));
    }

    @Override
    public void visitTableSwitchInsn(int register, int min, int max, Label dflt, Label[] labels) {
        this.instructions.add(new TableSwitchInsnNode(register, min, max, this.getLabelNode(dflt), this.getLabelNodes(labels)));
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.tryCatchBlocks.add(new TryCatchBlockNode(this.getLabelNode(start), this.getLabelNode(end), this.getLabelNode(handler), type));
    }

    @Override
    public void visitTypeInsn(int opcode, int destinationRegister, int referenceBearingRegister, int sizeRegister, String type) {
        this.instructions.add(new TypeInsnNode(opcode, destinationRegister, referenceBearingRegister, sizeRegister, type));
    }

    @Override
    public void visitVarInsn(int opcode, int destinationRegister, int var) {
        this.instructions.add(new VarInsnNode(opcode, destinationRegister, var));
    }

    @Override
    public void visitVarInsn(int opcode, int destinationRegister, long var) {
        this.instructions.add(new VarInsnLongNode(opcode, destinationRegister, var));
    }

    protected LabelNode getLabelNode(Label l) {
        if (l == null) {
            return null;
        }
        if (!(l.info instanceof LabelNode)) {
            l.info = new LabelNode(l);
        }
        return (LabelNode)l.info;
    }

    private LabelNode[] getLabelNodes(Label[] l) {
        if (l == null) {
            return null;
        }
        LabelNode[] nodes = new LabelNode[l.length];
        int i = 0;
        while (i < l.length) {
            nodes[i] = this.getLabelNode(l[i]);
            ++i;
        }
        return nodes;
    }

    private List<LabelNode> getLabelNodes(List<Label> l) {
        if (l == null) {
            return null;
        }
        ArrayList<LabelNode> nodes = new ArrayList<LabelNode>(l.size());
        for (Label label : l) {
            nodes.add(this.getLabelNode(label));
        }
        return nodes;
    }

    public void accept(ClassVisitor cv) {
        MethodVisitor mv;
        String[] exceptions = null;
        if (this.exceptions != null) {
            exceptions = new String[this.exceptions.size()];
            this.exceptions.toArray(exceptions);
        }
        if ((mv = cv.visitMethod(this.access, this.name, this.desc, this.signature, exceptions)) != null) {
            this.accept(mv);
        }
    }

    public void accept(MethodVisitor mv) {
        AnnotationNode an;
        int j;
        List<AnnotationNode> l;
        AnnotationNode an2;
        if (this.annotationDefault != null) {
            AnnotationVisitor av = mv.visitAnnotationDefault();
            AnnotationNode.accept(av, this.name, this.annotationDefault);
            if (av != null) {
                av.visitEnd();
            }
        }
        if (this.parameters != null && this.parameters.length > 0) {
            mv.visitParameters(this.parameters);
        }
        int n = this.visibleAnnotations == null ? 0 : this.visibleAnnotations.size();
        int i = 0;
        while (i < n) {
            an2 = this.visibleAnnotations.get(i);
            an2.accept(mv.visitAnnotation(an2.desc, true));
            ++i;
        }
        n = this.invisibleAnnotations == null ? 0 : this.invisibleAnnotations.size();
        i = 0;
        while (i < n) {
            an2 = this.invisibleAnnotations.get(i);
            an2.accept(mv.visitAnnotation(an2.desc, false));
            ++i;
        }
        n = this.visibleParameterAnnotations == null ? 0 : this.visibleParameterAnnotations.size();
        i = 0;
        while (i < n) {
            l = this.visibleParameterAnnotations.get(i);
            if (l != null) {
                j = 0;
                while (j < l.size()) {
                    an = l.get(j);
                    an.accept(mv.visitParameterAnnotation(i, an.desc, true));
                    ++j;
                }
            }
            ++i;
        }
        n = this.invisibleParameterAnnotations == null ? 0 : this.invisibleParameterAnnotations.size();
        i = 0;
        while (i < n) {
            l = this.invisibleParameterAnnotations.get(i);
            if (l != null) {
                j = 0;
                while (j < l.size()) {
                    an = l.get(j);
                    an.accept(mv.visitParameterAnnotation(i, an.desc, false));
                    ++j;
                }
            }
            ++i;
        }
        if (this.instructions.size() > 0) {
            mv.visitCode();
            n = this.tryCatchBlocks == null ? 0 : this.tryCatchBlocks.size();
            i = 0;
            while (i < n) {
                this.tryCatchBlocks.get(i).accept(mv);
                ++i;
            }
            this.instructions.accept(mv);
            n = this.localVariables == null ? 0 : this.localVariables.size();
            i = 0;
            while (i < n) {
                this.localVariables.get(i).accept(mv);
                ++i;
            }
            mv.visitMaxs(this.maxStack, 0);
        }
        mv.visitEnd();
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationNode an = new AnnotationNode(desc);
        if (visible) {
            if (this.visibleAnnotations == null) {
                this.visibleAnnotations = new ArrayList<AnnotationNode>(1);
            }
            this.visibleAnnotations.add(an);
        } else {
            if (this.invisibleAnnotations == null) {
                this.invisibleAnnotations = new ArrayList<AnnotationNode>(1);
            }
            this.invisibleAnnotations.add(an);
        }
        return an;
    }
}

