/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.tree;

import java.util.ArrayList;
import java.util.List;
import org.ow2.asmdex.AnnotationVisitor;
import org.ow2.asmdex.ClassVisitor;
import org.ow2.asmdex.FieldVisitor;
import org.ow2.asmdex.tree.AnnotationNode;

public class FieldNode
extends FieldVisitor {
    public int access;
    public String name;
    public String desc;
    public String[] signature;
    public Object value;
    public List<AnnotationNode> visibleAnnotations;
    public List<AnnotationNode> invisibleAnnotations;

    public FieldNode(int api, int access, String name, String desc, String[] signature, Object value) {
        super(api);
        this.access = access;
        this.name = name;
        this.desc = desc;
        this.signature = signature;
        this.value = value;
    }

    public FieldNode(int access, String name, String desc, String[] signature, Object value) {
        this(262144, access, name, desc, signature, value);
    }

    public void accept(ClassVisitor cv) {
        AnnotationNode an;
        FieldVisitor fv = cv.visitField(this.access, this.name, this.desc, this.signature, this.value);
        if (fv == null) {
            return;
        }
        int n = this.visibleAnnotations == null ? 0 : this.visibleAnnotations.size();
        int i = 0;
        while (i < n) {
            an = this.visibleAnnotations.get(i);
            an.accept(fv.visitAnnotation(an.desc, true));
            ++i;
        }
        n = this.invisibleAnnotations == null ? 0 : this.invisibleAnnotations.size();
        i = 0;
        while (i < n) {
            an = this.invisibleAnnotations.get(i);
            an.accept(fv.visitAnnotation(an.desc, false));
            ++i;
        }
        fv.visitEnd();
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationNode an = new AnnotationNode(desc);
        if (visible) {
            if (this.visibleAnnotations == null) {
                this.visibleAnnotations = new ArrayList<AnnotationNode>(1);
            }
            this.visibleAnnotations.add(an);
        } else {
            if (this.invisibleAnnotations == null) {
                this.invisibleAnnotations = new ArrayList<AnnotationNode>(1);
            }
            this.invisibleAnnotations.add(an);
        }
        return an;
    }
}

