/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ow2.asmdex.AnnotationVisitor;
import org.ow2.asmdex.ClassVisitor;
import org.ow2.asmdex.FieldVisitor;
import org.ow2.asmdex.MethodVisitor;
import org.ow2.asmdex.tree.AnnotationNode;
import org.ow2.asmdex.tree.ApplicationNode;
import org.ow2.asmdex.tree.FieldNode;
import org.ow2.asmdex.tree.InnerClassNode;
import org.ow2.asmdex.tree.MethodNode;

public class ClassNode
extends ClassVisitor {
    public int access;
    public String name;
    public List<String> signature;
    public String superName;
    public List<String> interfaces;
    public String sourceFile;
    public String outerClass;
    public String outerMethod;
    public String outerMethodDesc;
    public List<InnerClassNode> innerClasses = new ArrayList<InnerClassNode>();
    public List<FieldNode> fields = new ArrayList<FieldNode>();
    public List<MethodNode> methods = new ArrayList<MethodNode>();
    public List<AnnotationNode> visibleAnnotations;
    public List<AnnotationNode> invisibleAnnotations;

    public ClassNode(int api) {
        super(api);
    }

    public ClassNode(int api, int access, String name, String[] signature, String superName, String[] interfaces) {
        super(api);
        this.access = access;
        this.name = name;
        if (signature != null) {
            this.signature = Arrays.asList(signature);
        }
        this.superName = superName;
        if (interfaces != null) {
            this.interfaces = Arrays.asList(interfaces);
        }
    }

    public ClassNode(int access, String name, String[] signature, String superName, String[] interfaces) {
        this(262144, access, name, signature, superName, interfaces);
    }

    @Override
    public void visit(int version, int access, String name, String[] signature, String superName, String[] interfaces) {
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String[] signature, Object value) {
        FieldNode n = new FieldNode(access, name, desc, signature, value);
        this.fields.add(n);
        return n;
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        InnerClassNode n = new InnerClassNode(name, outerName, innerName, access);
        this.innerClasses.add(n);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String[] signature, String[] exceptions) {
        MethodNode n = new MethodNode(this.api, access, name, desc, signature, exceptions);
        this.methods.add(n);
        return n;
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
        this.outerClass = owner;
        this.outerMethod = name;
        this.outerMethodDesc = desc;
    }

    @Override
    public void visitSource(String source, String debug) {
        this.sourceFile = source;
    }

    public void accept(ClassVisitor cv) {
        AnnotationNode an;
        cv.visit(0, this.access, this.name, ApplicationNode.getStringArray(this.signature), this.superName, ApplicationNode.getStringArray(this.interfaces));
        if (this.sourceFile != null) {
            cv.visitSource(this.sourceFile, null);
        }
        if (this.outerClass != null) {
            cv.visitOuterClass(this.outerClass, this.outerMethod, this.outerMethodDesc);
        }
        int n = this.visibleAnnotations == null ? 0 : this.visibleAnnotations.size();
        int i = 0;
        while (i < n) {
            an = this.visibleAnnotations.get(i);
            an.accept(cv.visitAnnotation(an.desc, true));
            ++i;
        }
        n = this.invisibleAnnotations == null ? 0 : this.invisibleAnnotations.size();
        i = 0;
        while (i < n) {
            an = this.invisibleAnnotations.get(i);
            an.accept(cv.visitAnnotation(an.desc, false));
            ++i;
        }
        for (InnerClassNode icn : this.innerClasses) {
            icn.accept(cv);
        }
        for (FieldNode fn : this.fields) {
            fn.accept(cv);
        }
        for (MethodNode mn : this.methods) {
            mn.accept(cv);
        }
        cv.visitEnd();
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationNode an = new AnnotationNode(desc);
        if (visible) {
            if (this.visibleAnnotations == null) {
                this.visibleAnnotations = new ArrayList<AnnotationNode>(1);
            }
            this.visibleAnnotations.add(an);
        } else {
            if (this.invisibleAnnotations == null) {
                this.invisibleAnnotations = new ArrayList<AnnotationNode>(1);
            }
            this.invisibleAnnotations.add(an);
        }
        return an;
    }
}

