/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.structureWriter;

import java.util.ArrayList;
import org.ow2.asmdex.structureCommon.Label;
import org.ow2.asmdex.structureWriter.ExceptionHandler;

public class TryCatch {
    private final Label start;
    private final Label end;
    private ArrayList<ExceptionHandler> exceptionHandlers = new ArrayList();
    private Label catchAllHandler;

    public TryCatch(Label start, Label end, ExceptionHandler exceptionHandler) {
        this.start = start;
        this.end = end;
        this.addExceptionHandler(exceptionHandler);
    }

    public void addExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandlers.add(exceptionHandler);
        if (exceptionHandler.getType() == null) {
            if (this.hasCatchAll()) {
                try {
                    throw new Exception("A Try/Catch can't support more than one CatchAll.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.catchAllHandler = exceptionHandler.getHandler();
            }
        }
    }

    public void addExceptionHandlers(ArrayList<ExceptionHandler> exceptionHandlers) {
        for (ExceptionHandler exceptionHandler : exceptionHandlers) {
            this.addExceptionHandler(exceptionHandler);
        }
    }

    public Label getStart() {
        return this.start;
    }

    public Label getEnd() {
        return this.end;
    }

    public ArrayList<ExceptionHandler> getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public int getNbExceptionHandler() {
        return this.exceptionHandlers.size();
    }

    public boolean hasCatchAll() {
        return this.catchAllHandler != null;
    }

    public Label getCatchAllHandler() {
        return this.catchAllHandler;
    }
}

