/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.structureWriter;

import org.ow2.asmdex.encodedValue.EncodedValue;
import org.ow2.asmdex.encodedValue.EncodedValueFactory;
import org.ow2.asmdex.encodedValue.EncodedValueString;
import org.ow2.asmdex.encodedValue.EncodedValueUtil;
import org.ow2.asmdex.structureWriter.AnnotationItem;
import org.ow2.asmdex.structureWriter.AnnotationSetItem;
import org.ow2.asmdex.structureWriter.ConstantPool;
import org.ow2.asmdex.structureWriter.IAnnotationsHolder;

public class Field
implements Comparable<Field>,
IAnnotationsHolder {
    private final String className;
    private final String typeName;
    private final String fieldName;
    private int access;
    private String[] signature;
    private EncodedValue value = null;
    private AnnotationSetItem annotationSetItem = new AnnotationSetItem();
    private final int hashcode;

    public Field(String fieldName, String desc, String classOwningName) {
        this.fieldName = fieldName;
        this.typeName = desc;
        this.className = classOwningName;
        this.hashcode = Field.calculateHashCode(fieldName, this.className, this.typeName);
    }

    public void init(int access, String[] signature, Object value, ConstantPool constantPool) {
        this.access = access;
        this.signature = signature;
        this.setEncodedValueFromObject(value, this.typeName, constantPool);
    }

    private void setEncodedValueFromObject(Object value, String desc, ConstantPool constantPool) {
        if ((this.access & 8) > 0 && value != null) {
            boolean isRef = EncodedValueUtil.isTypeAReference(desc);
            if (isRef) {
                if (EncodedValueUtil.isString(desc)) {
                    String str = (String)value;
                    this.value = new EncodedValueString(str);
                    constantPool.addStringToConstantPool(str);
                } else {
                    this.setNoValue();
                }
            } else {
                this.value = EncodedValueFactory.getEncodedValue(value, desc);
            }
        }
    }

    public static int calculateHashCode(String fieldName, String classOwningName, String desc) {
        return classOwningName.hashCode() + desc.hashCode() + fieldName.hashCode();
    }

    public void completeInformation(int access, String[] signature, Object value, ConstantPool constantPool) {
        this.access = access;
        this.signature = signature;
        this.setEncodedValueFromObject(value, this.typeName, constantPool);
    }

    public boolean isStatic() {
        return (this.access & 8) > 0;
    }

    public boolean isFinalStatic() {
        return (this.access & 8) > 0 && (this.access & 0x10) > 0;
    }

    public boolean isUnknown() {
        return (this.access & 0x40000) != 0;
    }

    public void addAnnotationItem(AnnotationItem annotationItem) {
        this.annotationSetItem.addAnnotationItem(annotationItem);
    }

    public String getClassName() {
        return this.className;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public int getAccess() {
        return this.access;
    }

    public String[] getSignature() {
        return this.signature;
    }

    public EncodedValue getValue() {
        return this.value;
    }

    public byte[] encodeValue(ConstantPool constantPool) {
        return this.value == null ? null : this.value.encode(constantPool);
    }

    public void setNoValue() {
        this.value = EncodedValueFactory.getEncodedEmptyValue(this.typeName);
    }

    @Override
    public AnnotationSetItem getAnnotationSetItem() {
        return this.annotationSetItem;
    }

    @Override
    public int getNbAnnotations() {
        return this.annotationSetItem.getNbAnnotationItems();
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Field) {
            Field field = (Field)obj;
            return this.fieldName.equals(field.fieldName) && this.className.equals(field.className) && this.typeName.equals(field.typeName);
        }
        return false;
    }

    @Override
    public int compareTo(Field field) {
        if (this == field) {
            return 0;
        }
        int compare = this.className.compareTo(field.className);
        if (compare != 0) {
            return compare;
        }
        compare = this.fieldName.compareTo(field.fieldName);
        if (compare != 0) {
            return compare;
        }
        return this.typeName.compareTo(field.typeName);
    }
}

