/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.structureWriter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import org.ow2.asmdex.structureWriter.AnnotationDirectoryItem;
import org.ow2.asmdex.structureWriter.AnnotationItem;
import org.ow2.asmdex.structureWriter.AnnotationSetItem;
import org.ow2.asmdex.structureWriter.AnnotationSetRefList;
import org.ow2.asmdex.structureWriter.ClassDefinitionItem;
import org.ow2.asmdex.structureWriter.Field;
import org.ow2.asmdex.structureWriter.Method;
import org.ow2.asmdex.structureWriter.Prototype;
import org.ow2.asmdex.structureWriter.TypeList;

public class ConstantPool {
    private boolean useSymbolicElements = true;
    private HashMap<String, Integer> symbolicStringsToIndexes = new HashMap();
    private HashMap<String, Integer> symbolicTypesToIndexes = new HashMap();
    private HashMap<Method, Integer> symbolicMethodsToIndexes = new HashMap();
    private HashMap<Field, Integer> symbolicFieldsToIndexes = new HashMap();
    private int[] symbolicStringsIndexToResolvedStringsIndex;
    private int[] symbolicFieldsIndexToResolvedFieldsIndex;
    private int[] symbolicMethodsIndexToResolvedMethodsIndex;
    private int[] symbolicTypesIndexToResolvedTypesIndex;
    private HashMap<String, Integer> resolvedStringsToIndexes = new HashMap();
    private HashMap<String, Integer> resolvedTypesToIndexes = new HashMap();
    private HashMap<Method, Integer> resolvedMethodsToIndexes = new HashMap();
    private HashMap<Field, Integer> resolvedFieldsToIndexes = new HashMap();
    private HashMap<Prototype, Integer> prototypesToIndexes = new HashMap();
    private HashMap<TypeList, Integer> typeListsToOffsets = new HashMap();
    private TreeSet<String> strings = new TreeSet();
    private HashMap<Prototype, Prototype> prototypes = new HashMap();
    private TreeSet<Prototype> orderedPrototypes;
    private TreeSet<String> types = new TreeSet();
    private HashMap<Field, Field> fields = new HashMap();
    private HashMap<Method, Method> methods = new HashMap();
    private TreeSet<Field> orderedFields;
    private TreeSet<Method> orderedMethods;
    private ArrayList<ClassDefinitionItem> orderedClasses;
    private HashSet<TypeList> typeList = new HashSet();
    private TreeSet<TypeList> orderedTypeList;
    private HashMap<ClassDefinitionItem, Integer> staticValuesEncodedArrayItemOffsets = new HashMap();
    private TreeSet<AnnotationItem> annotationItems = new TreeSet();
    private HashMap<AnnotationItem, Integer> annotationItemsToOffsets = new HashMap();
    private TreeSet<AnnotationSetItem> annotationSetItems = new TreeSet();
    private HashMap<AnnotationSetItem, Integer> annotationSetItemsToOffsets = new HashMap();
    private HashSet<AnnotationSetRefList> annotationSetRefLists = new HashSet();
    private HashMap<AnnotationSetRefList, Integer> annotationSetRefListsToOffsets = new HashMap();
    private HashMap<AnnotationDirectoryItem, Integer> classesToAnnotationDirectoryItemOffsets = new HashMap();
    private HashMap<String, ClassDefinitionItem> classNameToClassDefinitionItem = new HashMap();
    private HashSet<AnnotationDirectoryItem> annotationDirectoryItems = new HashSet();

    public int getStringCount() {
        return this.strings.size();
    }

    public int getTypeCount() {
        return this.types.size();
    }

    public int getPrototypeCount() {
        return this.prototypes.size();
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public int getMethodCount() {
        return this.methods.size();
    }

    public int getClassDefinitionCount() {
        return this.classNameToClassDefinitionItem.size();
    }

    public int getTypeListCount() {
        return this.typeList.size();
    }

    public TreeSet<String> getStrings() {
        return this.strings;
    }

    public TreeSet<String> getTypes() {
        return this.types;
    }

    public TreeSet<Field> getFields() {
        return this.orderedFields;
    }

    public TreeSet<Prototype> getPrototypes() {
        return this.orderedPrototypes;
    }

    public TreeSet<Method> getMethods() {
        return this.orderedMethods;
    }

    public TreeSet<TypeList> getTypeList() {
        return this.orderedTypeList;
    }

    public int getStringIndex(String string) {
        if (this.useSymbolicElements) {
            return this.symbolicStringsToIndexes.get(string);
        }
        return this.resolvedStringsToIndexes.get(string);
    }

    public int getTypeListOffset(TypeList typeList) {
        return this.typeListsToOffsets.get(typeList);
    }

    public void setTypeListOffset(TypeList typeList, int offset) {
        this.typeListsToOffsets.put(typeList, offset);
    }

    public int getTypeIndex(String type) {
        if (this.useSymbolicElements) {
            return this.symbolicTypesToIndexes.get(type);
        }
        return this.resolvedTypesToIndexes.get(type);
    }

    public int getPrototypeIndex(Prototype prototype) {
        return this.prototypesToIndexes.get(prototype);
    }

    public int getFieldIndex(Field field) {
        if (this.useSymbolicElements) {
            return this.symbolicFieldsToIndexes.get(field);
        }
        return this.resolvedFieldsToIndexes.get(field);
    }

    public int getMethodIndex(Method method) {
        if (this.useSymbolicElements) {
            return this.symbolicMethodsToIndexes.get(method);
        }
        return this.resolvedMethodsToIndexes.get(method);
    }

    public int getAnnotationItemOffset(AnnotationItem annotationItem) {
        return this.annotationItemsToOffsets.get(annotationItem);
    }

    public void setAnnotationItemOffset(AnnotationItem annotationItem, int offset) {
        this.annotationItemsToOffsets.put(annotationItem, offset);
    }

    public int getAnnotationSetItemOffset(AnnotationSetItem annotationSetItem) {
        return this.annotationSetItemsToOffsets.get(annotationSetItem);
    }

    public void setAnnotationSetItemOffset(AnnotationSetItem annotationSetItem, int offset) {
        this.annotationSetItemsToOffsets.put(annotationSetItem, offset);
    }

    public int getAnnotationSetRefListOffset(AnnotationSetRefList annotationSetRefList) {
        return this.annotationSetRefListsToOffsets.get(annotationSetRefList);
    }

    public void setAnnotationSetRefListOffset(AnnotationSetRefList annotationSetRefList, int offset) {
        this.annotationSetRefListsToOffsets.put(annotationSetRefList, offset);
    }

    public int getAnnotationDirectoryItemOffset(AnnotationDirectoryItem annotationDirectoryItem) {
        if (this.classesToAnnotationDirectoryItemOffsets.containsKey(annotationDirectoryItem)) {
            return this.classesToAnnotationDirectoryItemOffsets.get(annotationDirectoryItem);
        }
        return 0;
    }

    public void setAnnotationDirectoryItemOffset(AnnotationDirectoryItem annotationDirectoryItem, int offset) {
        this.classesToAnnotationDirectoryItemOffsets.put(annotationDirectoryItem, offset);
    }

    public TreeSet<AnnotationItem> getAnnotationItems() {
        return this.annotationItems;
    }

    public TreeSet<AnnotationSetItem> getAnnotationSetItems() {
        return this.annotationSetItems;
    }

    public HashSet<AnnotationSetRefList> getAnnotationSetRefLists() {
        return this.annotationSetRefLists;
    }

    public int getAnnotationItemCount() {
        return this.annotationItems.size();
    }

    public int getAnnotationSetItemCount() {
        return this.annotationSetItems.size();
    }

    public int getAnnotationSetRefListsCount() {
        return this.annotationSetRefLists.size();
    }

    public int getAnnotationDirectoryItemCount() {
        return this.classesToAnnotationDirectoryItemOffsets.size();
    }

    public int getOffsetOfStaticValuesEncodedArrayItemOfClass(ClassDefinitionItem cdi) {
        int result = 0;
        if (this.staticValuesEncodedArrayItemOffsets.containsKey(cdi)) {
            result = this.staticValuesEncodedArrayItemOffsets.get(cdi);
        }
        return result;
    }

    public ArrayList<ClassDefinitionItem> getClasses() {
        return this.orderedClasses;
    }

    public HashSet<AnnotationDirectoryItem> getAnnotationDirectoryItems() {
        return this.annotationDirectoryItems;
    }

    public int getResolvedMethodIndexFromSymbolicMethodIndex(int methodIndex) {
        return this.symbolicMethodsIndexToResolvedMethodsIndex[methodIndex];
    }

    public int getResolvedFieldIndexFromSymbolicFieldIndex(int fieldIndex) {
        return this.symbolicFieldsIndexToResolvedFieldsIndex[fieldIndex];
    }

    public int getResolvedTypeIndexFromSymbolicTypeIndex(int typeIndex) {
        return this.symbolicTypesIndexToResolvedTypesIndex[typeIndex];
    }

    public int getResolvedStringIndexFromSymbolicStringIndex(int stringIndex) {
        return this.symbolicStringsIndexToResolvedStringsIndex[stringIndex];
    }

    public void addStringToConstantPool(String string) {
        if (string != null) {
            if (this.useSymbolicElements && !this.symbolicStringsToIndexes.containsKey(string)) {
                this.symbolicStringsToIndexes.put(string, this.symbolicStringsToIndexes.size());
            }
            this.strings.add(string);
        }
    }

    public void addStringsToConstantPool(String[] strings) {
        if (strings != null) {
            String[] stringArray = strings;
            int n = strings.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                this.addStringToConstantPool(string);
                ++n2;
            }
        }
    }

    public void addTypeToConstantPool(String type) {
        if (type != null && !"".equals(type)) {
            this.addStringToConstantPool(type);
            if (this.useSymbolicElements && !this.symbolicTypesToIndexes.containsKey(type)) {
                this.symbolicTypesToIndexes.put(type, this.symbolicTypesToIndexes.size());
            }
            this.types.add(type);
        }
    }

    public void addTypesToConstantPool(String[] types) {
        if (types != null) {
            String[] stringArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                this.addTypeToConstantPool(type);
                ++n2;
            }
        }
    }

    public void addPrototypeToConstantPool(Prototype prototype) {
        Prototype existing = this.prototypes.get(prototype);
        if (existing == null) {
            prototype.initialize();
            this.addStringToConstantPool(prototype.getShortyDescriptor());
            this.addTypeToConstantPool(prototype.getReturnType());
            this.addTypeListToConstantPool(prototype.getParameterTypes());
            this.prototypes.put(prototype, prototype);
        }
    }

    public Prototype addPrototypeToConstantPool(String descriptor) {
        Prototype prototype = new Prototype(descriptor);
        Prototype existing = this.prototypes.get(prototype);
        if (existing == null) {
            this.addPrototypeToConstantPool(prototype);
        } else {
            prototype = existing;
        }
        return prototype;
    }

    public void addTypeListToConstantPool(TypeList typeList) {
        if (typeList.size() > 0) {
            String[] stringArray = typeList.getTypeList();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                this.addTypeToConstantPool(type);
                ++n2;
            }
            this.typeList.add(typeList);
        }
    }

    public Method addMethodToConstantPool(String methodName, String className, String methodDescriptor, int access, String[] signature, String[] exceptionNames) {
        Prototype prototype = this.addPrototypeToConstantPool(methodDescriptor);
        Method method = new Method(methodName, className, prototype);
        Method foundMethod = this.methods.get(method);
        if (foundMethod == null) {
            method.init(access, signature, exceptionNames, this);
            this.methods.put(method, method);
            this.symbolicMethodsToIndexes.put(method, this.symbolicMethodsToIndexes.size());
            this.addStringToConstantPool(methodName);
            this.addTypeToConstantPool(className);
            this.addStringsToConstantPool(signature);
            this.addTypesToConstantPool(exceptionNames);
            return method;
        }
        if ((access & 0x40000) == 0 && foundMethod.isUnknown()) {
            foundMethod.completeInformation(access, exceptionNames, signature, this);
        }
        return foundMethod;
    }

    public Field addFieldToConstantPool(String fieldName, String desc, String classOwningName, int access, String[] signature, Object value) {
        Field field = new Field(fieldName, desc, classOwningName);
        Field foundField = this.fields.get(field);
        if (foundField == null) {
            field.init(access, signature, value, this);
            this.fields.put(field, field);
            this.symbolicFieldsToIndexes.put(field, this.symbolicFieldsToIndexes.size());
            this.addStringToConstantPool(fieldName);
            this.addTypeToConstantPool(desc);
            this.addTypeToConstantPool(classOwningName);
            this.addStringsToConstantPool(signature);
            return field;
        }
        if ((access & 0x40000) == 0 && foundField.isUnknown()) {
            foundField.completeInformation(access, signature, value, this);
        }
        return foundField;
    }

    public ClassDefinitionItem addClassToConstantPool(String className, String superName, int access, String[] interfaceNames, String[] signature) {
        if (!this.classNameToClassDefinitionItem.containsKey(className)) {
            TypeList interfaceTypeList = new TypeList(interfaceNames);
            ClassDefinitionItem cdi = new ClassDefinitionItem(className, superName, access, interfaceTypeList, signature, this);
            this.classNameToClassDefinitionItem.put(className, cdi);
            this.addTypeToConstantPool(className);
            this.addTypeToConstantPool(superName);
            this.addStringsToConstantPool(signature);
            this.addTypeListToConstantPool(interfaceTypeList);
            return cdi;
        }
        return this.classNameToClassDefinitionItem.get(className);
    }

    public void addAnnotationItemToConstantPool(AnnotationItem annotationItem) {
        this.annotationItems.add(annotationItem);
    }

    public void addAnnotationSetItemToConstantPool(AnnotationSetItem annotationSetItem) {
        if (annotationSetItem.getNbAnnotationItems() > 0) {
            this.annotationSetItems.add(annotationSetItem);
        }
    }

    public void addAnnotationSetItemNoSizeCheck(AnnotationSetItem annotationSetItem) {
        this.annotationSetItems.add(annotationSetItem);
    }

    public void addAnnotationSetRefListToConstantPool(AnnotationSetRefList annotationSetRefList) {
        if (annotationSetRefList.getNbAnnotationSetItemsUsed() > 0) {
            this.annotationSetRefLists.add(annotationSetRefList);
            AnnotationSetItem[] annotationSetItemArray = annotationSetRefList.getAnnotationSetItems();
            int n = annotationSetItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                AnnotationSetItem annotationSetItem = annotationSetItemArray[n2];
                this.addAnnotationSetItemNoSizeCheck(annotationSetItem);
                ++n2;
            }
        }
    }

    public void addOffsetForStaticValuesEncodedArrayItemOfClass(ClassDefinitionItem cdi, int offset) {
        this.staticValuesEncodedArrayItemOffsets.put(cdi, offset);
    }

    public void addAnnotationDirectoryItem(AnnotationDirectoryItem annotationDirectoryItem) {
        this.annotationDirectoryItems.add(annotationDirectoryItem);
    }

    public void prepareGeneration() {
        this.generateSortedCollections();
        this.buildIndexMaps();
    }

    private void generateSortedCollections() {
        this.orderedTypeList = new TreeSet<TypeList>(this.typeList);
        this.orderedFields = new TreeSet<Field>(this.fields.values());
        this.orderedPrototypes = new TreeSet<Prototype>(this.prototypes.values());
        this.orderedMethods = new TreeSet<Method>(this.methods.values());
        this.sortClasses();
    }

    private void buildIndexMaps() {
        int symbolicIndex;
        this.useSymbolicElements = false;
        this.resolvedStringsToIndexes.clear();
        this.symbolicStringsIndexToResolvedStringsIndex = new int[this.strings.size()];
        int index = 0;
        for (String string : this.strings) {
            this.resolvedStringsToIndexes.put(string, index);
            symbolicIndex = this.symbolicStringsToIndexes.get(string);
            this.symbolicStringsIndexToResolvedStringsIndex[symbolicIndex] = index++;
        }
        this.resolvedTypesToIndexes.clear();
        this.symbolicTypesIndexToResolvedTypesIndex = new int[this.types.size()];
        index = 0;
        for (String type : this.types) {
            this.resolvedTypesToIndexes.put(type, index);
            symbolicIndex = this.symbolicTypesToIndexes.get(type);
            this.symbolicTypesIndexToResolvedTypesIndex[symbolicIndex] = index++;
        }
        this.prototypesToIndexes.clear();
        index = 0;
        for (Prototype prototype : this.orderedPrototypes) {
            this.prototypesToIndexes.put(prototype, index);
            ++index;
        }
        this.resolvedFieldsToIndexes.clear();
        this.symbolicFieldsIndexToResolvedFieldsIndex = new int[this.fields.size()];
        index = 0;
        for (Field field : this.orderedFields) {
            this.resolvedFieldsToIndexes.put(field, index);
            symbolicIndex = this.symbolicFieldsToIndexes.get(field);
            this.symbolicFieldsIndexToResolvedFieldsIndex[symbolicIndex] = index++;
        }
        this.resolvedMethodsToIndexes.clear();
        this.symbolicMethodsIndexToResolvedMethodsIndex = new int[this.orderedMethods.size()];
        index = 0;
        for (Method method : this.orderedMethods) {
            this.resolvedMethodsToIndexes.put(method, index);
            symbolicIndex = this.symbolicMethodsToIndexes.get(method);
            this.symbolicMethodsIndexToResolvedMethodsIndex[symbolicIndex] = index++;
        }
    }

    private void sortClasses() {
        this.orderedClasses = new ArrayList();
        Collection<ClassDefinitionItem> classes = this.classNameToClassDefinitionItem.values();
        for (ClassDefinitionItem cdi : classes) {
            this.sortClassRec(cdi);
        }
        if (this.classNameToClassDefinitionItem.size() != this.orderedClasses.size()) {
            try {
                throw new Exception("Sorted Classes list doesn't match the original list !");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void sortClassRec(ClassDefinitionItem cdi) {
        if (!this.orderedClasses.contains(cdi)) {
            String superClass = cdi.getSuperClassName();
            if (superClass != null) {
                this.sortClassRecString(superClass);
            }
            TypeList tl = cdi.getInterfaces();
            String[] stringArray = tl.getTypeList();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String className = stringArray[n2];
                this.sortClassRecString(className);
                ++n2;
            }
            this.orderedClasses.add(cdi);
        }
    }

    private void sortClassRecString(String className) {
        ClassDefinitionItem ncdi = this.classNameToClassDefinitionItem.get(className);
        if (ncdi != null && !this.orderedClasses.contains(ncdi)) {
            this.sortClassRec(ncdi);
        }
    }
}

