/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.lowLevelUtils;

import java.util.Arrays;

public class ByteVector {
    byte[] data;
    int length;

    public byte[] getData() {
        if (this.data == null) {
            return null;
        }
        if (this.length == this.data.length) {
            return this.data;
        }
        return Arrays.copyOf(this.data, this.length);
    }

    public byte[] getBuffer() {
        return this.data;
    }

    public int getLength() {
        return this.length;
    }

    public ByteVector() {
        this.data = new byte[64];
    }

    public ByteVector(int initialSize) {
        this.data = new byte[initialSize];
    }

    public ByteVector(byte[] bytes) {
        this.data = bytes;
        this.length = bytes.length;
    }

    public ByteVector putByte(int b) {
        int length = this.length;
        if (length + 1 > this.data.length) {
            this.enlarge(1);
        }
        this.data[length++] = (byte)b;
        this.length = length;
        return this;
    }

    public ByteVector putByte(int b, int position) {
        this.data[position] = (byte)b;
        return this;
    }

    public ByteVector putByteVector(ByteVector bv) {
        this.putByteArray(bv.data, 0, bv.length);
        return this;
    }

    public ByteVector putByteVector(ByteVector bv, int position) {
        byte[] b = bv.getData();
        this.putByteArray(b, position);
        return this;
    }

    ByteVector put11(int b1, int b2) {
        int length = this.length;
        if (length + 2 > this.data.length) {
            this.enlarge(2);
        }
        byte[] data = this.data;
        data[length++] = (byte)b1;
        data[length++] = (byte)b2;
        this.length = length;
        return this;
    }

    public ByteVector putShort(int s) {
        int length = this.length;
        if (length + 2 > this.data.length) {
            this.enlarge(2);
        }
        byte[] data = this.data;
        data[length++] = (byte)s;
        data[length++] = (byte)(s >>> 8);
        this.length = length;
        return this;
    }

    public ByteVector putShort(int s, int position) {
        byte[] data = this.data;
        data[position++] = (byte)s;
        data[position++] = (byte)(s >>> 8);
        return this;
    }

    public ByteVector putUleb128(int s) {
        int length;
        int nb1 = s & 0x7F;
        int nb2 = 0;
        int nb3 = 0;
        int nb4 = 0;
        int nb5 = 0;
        int nbLength = 1;
        if (s > 127) {
            ++nbLength;
            nb1 += 128;
            nb2 = s >>> 7 & 0x7F;
            if (s > 16383) {
                ++nbLength;
                nb2 += 128;
                nb3 = s >>> 14 & 0x7F;
                if (s > 0x1FFFFF) {
                    ++nbLength;
                    nb3 += 128;
                    nb4 = s >>> 21 & 0x7F;
                    if (s > 0xFFFFFFF) {
                        ++nbLength;
                        nb4 &= 0x7F;
                    }
                    nb5 = (s >>> 28) + 128;
                }
            }
        }
        if ((length = this.length) + nbLength > this.data.length) {
            this.enlarge(nbLength);
        }
        byte[] data = this.data;
        data[length++] = (byte)nb1;
        if (nbLength > 1) {
            data[length++] = (byte)nb2;
        }
        if (nbLength > 2) {
            data[length++] = (byte)nb3;
        }
        if (nbLength > 3) {
            data[length++] = (byte)nb4;
        }
        if (nbLength > 4) {
            data[length++] = (byte)nb5;
        }
        this.length = length;
        return this;
    }

    public ByteVector putUleb128p1(int s) {
        return this.putUleb128(s + 1);
    }

    public ByteVector putSleb128(int s) {
        int length;
        int nb1 = 0;
        int nb2 = 0;
        int nb3 = 0;
        int nb4 = 0;
        int nb5 = 0;
        int remaining = s >> 7;
        int nbLength = 0;
        int end = (s & Integer.MIN_VALUE) == 0 ? 0 : -1;
        boolean mustContinue = remaining != end || (remaining & 1) != (s >> 6 & 1);
        nb1 = s & 0x7F | (mustContinue ? 128 : 0);
        s = remaining;
        remaining >>= 7;
        ++nbLength;
        if (mustContinue) {
            mustContinue = remaining != end || (remaining & 1) != (s >> 6 & 1);
            nb2 = s & 0x7F | (mustContinue ? 128 : 0);
            s = remaining;
            remaining >>= 7;
            ++nbLength;
            if (mustContinue) {
                mustContinue = remaining != end || (remaining & 1) != (s >> 6 & 1);
                nb3 = s & 0x7F | (mustContinue ? 128 : 0);
                s = remaining;
                remaining >>= 7;
                ++nbLength;
                if (mustContinue) {
                    mustContinue = remaining != end || (remaining & 1) != (s >> 6 & 1);
                    nb4 = s & 0x7F | (mustContinue ? 128 : 0);
                    s = remaining;
                    remaining >>= 7;
                    ++nbLength;
                }
                if (mustContinue) {
                    nb5 = s & 0x7F | (mustContinue ? 128 : 0);
                    ++nbLength;
                }
            }
        }
        if ((length = this.length) + nbLength > this.data.length) {
            this.enlarge(nbLength);
        }
        byte[] data = this.data;
        data[length++] = (byte)nb1;
        if (nbLength > 1) {
            data[length++] = (byte)nb2;
        }
        if (nbLength > 2) {
            data[length++] = (byte)nb3;
        }
        if (nbLength > 3) {
            data[length++] = (byte)nb4;
        }
        if (nbLength > 4) {
            data[length++] = (byte)nb5;
        }
        this.length = length;
        return this;
    }

    ByteVector put12(int b, int s) {
        int length = this.length;
        if (length + 3 > this.data.length) {
            this.enlarge(3);
        }
        byte[] data = this.data;
        data[length++] = (byte)b;
        data[length++] = (byte)s;
        data[length++] = (byte)(s >>> 8);
        this.length = length;
        return this;
    }

    public ByteVector putInt(int i) {
        int length = this.length;
        if (length + 4 > this.data.length) {
            this.enlarge(4);
        }
        byte[] data = this.data;
        data[length++] = (byte)i;
        data[length++] = (byte)(i >>> 8);
        data[length++] = (byte)(i >>> 16);
        data[length++] = (byte)(i >>> 24);
        this.length = length;
        return this;
    }

    public ByteVector putInt(int i, int position) {
        byte[] data = this.data;
        data[position++] = (byte)i;
        data[position++] = (byte)(i >>> 8);
        data[position++] = (byte)(i >>> 16);
        data[position++] = (byte)(i >>> 24);
        return this;
    }

    public ByteVector putLong(long l) {
        int length = this.length;
        if (length + 8 > this.data.length) {
            this.enlarge(8);
        }
        byte[] data = this.data;
        int i = (int)l;
        data[length++] = (byte)i;
        data[length++] = (byte)(i >>> 8);
        data[length++] = (byte)(i >>> 16);
        data[length++] = (byte)(i >>> 24);
        i = (int)(l >>> 32);
        data[length++] = (byte)i;
        data[length++] = (byte)(i >>> 8);
        data[length++] = (byte)(i >>> 16);
        data[length++] = (byte)(i >>> 24);
        this.length = length;
        return this;
    }

    public ByteVector putUTF8(String s) {
        int len = this.length;
        int charLength = s.length();
        if (len + 2 + charLength > this.data.length) {
            this.enlarge(2 + charLength);
        }
        byte[] data = this.data;
        data[len++] = (byte)(charLength >>> 8);
        data[len++] = (byte)charLength;
        int i = 0;
        while (i < charLength) {
            char c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                data[len++] = (byte)c;
            } else {
                int byteLength = i;
                int j = i;
                while (j < charLength) {
                    c = s.charAt(j);
                    byteLength = c >= '\u0001' && c <= '\u007f' ? ++byteLength : (c > '\u07ff' ? (byteLength += 3) : (byteLength += 2));
                    ++j;
                }
                data[this.length] = (byte)(byteLength >>> 8);
                data[this.length + 1] = (byte)byteLength;
                if (this.length + 2 + byteLength > data.length) {
                    this.length = len;
                    this.enlarge(2 + byteLength);
                    data = this.data;
                }
                j = i;
                while (j < charLength) {
                    c = s.charAt(j);
                    if (c >= '\u0001' && c <= '\u007f') {
                        data[len++] = (byte)c;
                    } else if (c > '\u07ff') {
                        data[len++] = (byte)(0xE0 | c >> 12 & 0xF);
                        data[len++] = (byte)(0x80 | c >> 6 & 0x3F);
                        data[len++] = (byte)(0x80 | c & 0x3F);
                    } else {
                        data[len++] = (byte)(0xC0 | c >> 6 & 0x1F);
                        data[len++] = (byte)(0x80 | c & 0x3F);
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        this.length = len;
        return this;
    }

    public ByteVector putMUTF8(String s) {
        int len = this.length;
        int charLength = s.length();
        if (len + 1 + charLength > this.data.length) {
            this.enlarge(1 + charLength);
        }
        byte[] data = this.data;
        int i = 0;
        while (i < charLength) {
            char c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                data[len++] = (byte)c;
            } else {
                int byteLength = i;
                int j = i;
                while (j < charLength) {
                    c = s.charAt(j);
                    byteLength = c >= '\u0001' && c <= '\u007f' ? ++byteLength : (c > '\u07ff' ? (byteLength += 3) : (byteLength += 2));
                    ++j;
                }
                if (this.length + 1 + byteLength > data.length) {
                    this.length = len;
                    this.enlarge(1 + byteLength);
                    data = this.data;
                }
                j = i;
                while (j < charLength) {
                    c = s.charAt(j);
                    if (c >= '\u0001' && c <= '\u007f') {
                        data[len++] = (byte)c;
                    } else if (c > '\u07ff') {
                        data[len++] = (byte)(0xE0 | c >> 12 & 0xF);
                        data[len++] = (byte)(0x80 | c >> 6 & 0x3F);
                        data[len++] = (byte)(0x80 | c & 0x3F);
                    } else {
                        data[len++] = (byte)(0xC0 | c >> 6 & 0x1F);
                        data[len++] = (byte)(0x80 | c & 0x3F);
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        data[len++] = 0;
        this.length = len;
        return this;
    }

    public ByteVector putByteArray(byte[] b, int off, int len) {
        if (this.length + len > this.data.length) {
            this.enlarge(len);
        }
        if (b != null) {
            System.arraycopy(b, off, this.data, this.length, len);
        }
        this.length += len;
        return this;
    }

    public ByteVector putByteArray(byte[] b) {
        return this.putByteArray(b, 0, b.length);
    }

    public ByteVector putByteArray(byte[] b, int position) {
        if (b != null) {
            System.arraycopy(b, 0, this.data, position, b.length);
        }
        return this;
    }

    private void enlarge(int size) {
        int length1 = 2 * this.data.length;
        int length2 = this.length + size;
        byte[] newData = new byte[length1 > length2 ? length1 : length2];
        System.arraycopy(this.data, 0, newData, 0, this.length);
        this.data = newData;
    }

    public void addPadding(int alignment) {
        int padding = this.length % alignment;
        switch (padding) {
            case 0: {
                break;
            }
            case 1: {
                this.putByte(0);
                this.putShort(0);
                break;
            }
            case 2: {
                this.putShort(0);
                break;
            }
            case 3: {
                this.putByte(0);
            }
        }
    }

    public void addPadding() {
        this.addPadding(4);
    }
}

