/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.instruction;

import org.ow2.asmdex.instruction.IIndexInstruction;
import org.ow2.asmdex.instruction.IRegisterArrayInstruction;
import org.ow2.asmdex.instruction.Instruction;
import org.ow2.asmdex.lowLevelUtils.ByteVector;
import org.ow2.asmdex.lowLevelUtils.IDalvikValueReader;
import org.ow2.asmdex.structureWriter.ConstantPool;
import org.ow2.asmdex.structureWriter.Method;

public class InstructionFormat35C
extends Instruction
implements IRegisterArrayInstruction,
IIndexInstruction {
    private static final int INSTRUCTION_SIZE = 6;
    private int[] registers;
    private int index;
    private String type;
    private Method method;

    @Override
    public int[] getRegisters() {
        return this.registers;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public static int getIndex(IDalvikValueReader reader) {
        return reader.ushort();
    }

    public static int[] getRegisters(IDalvikValueReader reader, int opcode) {
        int nbRegisters = opcode >> 12 & 0xF;
        int[] registers = new int[nbRegisters];
        int thirdShort = reader.ushort();
        if (nbRegisters > 0) {
            registers[0] = thirdShort & 0xF;
            if (nbRegisters > 1) {
                registers[1] = thirdShort >> 4 & 0xF;
            }
            if (nbRegisters > 2) {
                registers[2] = thirdShort >> 8 & 0xF;
            }
            if (nbRegisters > 3) {
                registers[3] = thirdShort >> 12 & 0xF;
            }
            if (nbRegisters > 4) {
                registers[4] = opcode >> 8 & 0xF;
            }
            if (nbRegisters > 5) {
                try {
                    throw new Exception("Abnormal arguments number : " + nbRegisters);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return registers;
    }

    public static void skip(IDalvikValueReader reader) {
        reader.relativeSeek(4);
    }

    public InstructionFormat35C(int opcode, Method method, int[] registers) {
        super(opcode);
        this.method = method;
        this.registers = registers;
        Instruction.test4BitsLimit(registers);
    }

    public InstructionFormat35C(int opcode, String type, int[] registers) {
        super(opcode);
        this.type = type;
        this.registers = registers;
        Instruction.test4BitsLimit(registers);
    }

    @Override
    public int getSize() {
        return 6;
    }

    @Override
    public void write(ByteVector out, ConstantPool constantPool) {
        int nbRegisters;
        int firstShort = (nbRegisters << 12) + this.opcodeByte + ((nbRegisters = this.registers.length) > 4 ? (this.registers[4] & 0xF) << 8 : 0);
        int thirdShort = 0;
        if (nbRegisters > 0) {
            thirdShort = this.registers[0] & 0xF;
        }
        if (nbRegisters > 1) {
            thirdShort += (this.registers[1] & 0xF) << 4;
        }
        if (nbRegisters > 2) {
            thirdShort += (this.registers[2] & 0xF) << 8;
        }
        if (nbRegisters > 3) {
            thirdShort += (this.registers[3] & 0xF) << 12;
        }
        if (nbRegisters > 5) {
            try {
                throw new Exception("Abnormal arguments number : " + nbRegisters);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        out.putShort(firstShort);
        if (this.opcodeByte == 36) {
            out.putShort(constantPool.getTypeIndex(this.type));
        } else {
            out.putShort(constantPool.getMethodIndex(this.method));
        }
        out.putShort(thirdShort);
    }
}

