/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.instruction;

import org.ow2.asmdex.instruction.ITwoRegistersInstruction;
import org.ow2.asmdex.instruction.Instruction;
import org.ow2.asmdex.lowLevelUtils.ByteVector;
import org.ow2.asmdex.lowLevelUtils.IDalvikValueReader;
import org.ow2.asmdex.structureWriter.ConstantPool;

public class InstructionFormat32X
extends Instruction
implements ITwoRegistersInstruction {
    private static final int INSTRUCTION_SIZE = 6;
    private int registerA;
    private int registerB;

    @Override
    public int getRegisterA() {
        return this.registerA;
    }

    @Override
    public int getRegisterB() {
        return this.registerB;
    }

    public static int getRegisterA(IDalvikValueReader reader) {
        return reader.ushort();
    }

    public static int getRegisterB(IDalvikValueReader reader) {
        return reader.ushort();
    }

    public static void skip(IDalvikValueReader reader) {
        reader.relativeSeek(4);
    }

    public InstructionFormat32X(int opcode, int registerA, int registerB) {
        super(opcode);
        this.registerA = registerA;
        this.registerB = registerB;
    }

    @Override
    public int getSize() {
        return 6;
    }

    @Override
    public void write(ByteVector out, ConstantPool constantPool) {
        out.putShort(this.opcodeByte);
        out.putShort(this.registerA & 0xFFFF);
        out.putShort(this.registerB & 0xFFFF);
    }
}

