/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.instruction;

import org.ow2.asmdex.instruction.IIndexInstruction;
import org.ow2.asmdex.instruction.IOneRegisterInstruction;
import org.ow2.asmdex.instruction.Instruction;
import org.ow2.asmdex.lowLevelUtils.ByteVector;
import org.ow2.asmdex.lowLevelUtils.IDalvikValueReader;
import org.ow2.asmdex.structureWriter.ConstantPool;

public class InstructionFormat31C
extends Instruction
implements IOneRegisterInstruction,
IIndexInstruction {
    private static final int INSTRUCTION_SIZE = 6;
    private int registerA;
    private int indexB;
    private String string;

    @Override
    public int getRegisterA() {
        return this.registerA;
    }

    @Override
    public int getIndex() {
        return this.indexB;
    }

    public static int getRegisterA(int opcode) {
        return opcode >> 8 & 0xFF;
    }

    public static int getIndexB(IDalvikValueReader reader) {
        return reader.ushort() + (reader.ushort() << 16);
    }

    public static void skip(IDalvikValueReader reader) {
        reader.relativeSeek(4);
    }

    public InstructionFormat31C(int opcode, String string, int registerA) {
        super(opcode);
        this.registerA = registerA;
        this.string = string;
    }

    @Override
    public int getSize() {
        return 6;
    }

    @Override
    public void write(ByteVector out, ConstantPool constantPool) {
        out.putShort(((this.registerA & 0xFF) << 8) + this.opcodeByte);
        int index = constantPool.getStringIndex(this.string);
        out.putShort(index & 0xFFFF);
        out.putShort(index >> 16 & 0xFFFF);
    }
}

