/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.instruction;

import org.ow2.asmdex.instruction.ILiteralInstruction;
import org.ow2.asmdex.instruction.ITwoRegistersInstruction;
import org.ow2.asmdex.instruction.Instruction;
import org.ow2.asmdex.lowLevelUtils.ByteVector;
import org.ow2.asmdex.lowLevelUtils.IDalvikValueReader;
import org.ow2.asmdex.structureWriter.ConstantPool;

public class InstructionFormat22S
extends Instruction
implements ITwoRegistersInstruction,
ILiteralInstruction {
    private static final int INSTRUCTION_SIZE = 4;
    private int registerA;
    private int registerB;
    private int literalC;

    @Override
    public int getRegisterA() {
        return this.registerA;
    }

    @Override
    public int getRegisterB() {
        return this.registerB;
    }

    @Override
    public int getLiteral() {
        return this.literalC;
    }

    public static int getRegisterA(int opcode) {
        return opcode >> 8 & 0xF;
    }

    public static int getRegisterB(int opcode) {
        return opcode >> 12 & 0xF;
    }

    public static int getLiteralC(IDalvikValueReader reader) {
        return reader.sshort();
    }

    public static void skip(IDalvikValueReader reader) {
        reader.relativeSeek(2);
    }

    public InstructionFormat22S(int opcode, int registerA, int registerB, int value) {
        super(opcode);
        this.registerA = registerA;
        this.registerB = registerB;
        this.literalC = value;
        Instruction.test4BitsLimit(registerA);
        Instruction.test4BitsLimit(registerB);
    }

    @Override
    public int getSize() {
        return 4;
    }

    @Override
    public void write(ByteVector out, ConstantPool constantPool) {
        out.putShort(((this.registerA & 0xF) << 8) + ((this.registerB & 0xF) << 12) + this.opcodeByte);
        out.putShort(this.literalC & 0xFFFF);
    }
}

