/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.encodedValue;

import org.ow2.asmdex.encodedValue.EncodedValue;
import org.ow2.asmdex.encodedValue.EncodedValueUtil;
import org.ow2.asmdex.structureWriter.ConstantPool;

public class EncodedValueLong
extends EncodedValue {
    private int type = 6;
    private long value;

    public EncodedValueLong(long value) {
        this.value = value;
    }

    public EncodedValueLong(Object value) {
        this.value = (Long)value;
    }

    @Override
    public byte[] encode(ConstantPool constantPool) {
        return EncodedValueUtil.encodeSignedValue(this.value, this.type);
    }

    @Override
    public int getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        boolean result = false;
        if (o instanceof EncodedValueLong) {
            EncodedValueLong encodedValue = (EncodedValueLong)o;
            result = this.type == encodedValue.type && this.value == encodedValue.value;
        }
        return result;
    }

    public int hashCode() {
        return this.type + (int)this.value * 8943;
    }

    @Override
    int compareValue(EncodedValue encodedValue) {
        if (this == encodedValue) {
            return 0;
        }
        EncodedValueLong el = (EncodedValueLong)encodedValue;
        long value2 = el.value;
        return this.value == value2 ? 0 : (this.value > value2 ? 1 : -1);
    }
}

