/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ow2.asmdex.AnnotationVisitor;
import org.ow2.asmdex.AnnotationWriter;
import org.ow2.asmdex.ClassWriter;
import org.ow2.asmdex.MethodVisitor;
import org.ow2.asmdex.instruction.IOffsetInstruction;
import org.ow2.asmdex.instruction.IPseudoInstruction;
import org.ow2.asmdex.instruction.Instruction;
import org.ow2.asmdex.instruction.InstructionFormat10X;
import org.ow2.asmdex.instruction.InstructionFormat20T;
import org.ow2.asmdex.instruction.InstructionFormat30T;
import org.ow2.asmdex.instruction.PseudoInstructionFillArrayData;
import org.ow2.asmdex.instruction.PseudoInstructionPackedSwitch;
import org.ow2.asmdex.instruction.PseudoInstructionSparseSwitch;
import org.ow2.asmdex.lowLevelUtils.InstructionEncoder;
import org.ow2.asmdex.structureCommon.Label;
import org.ow2.asmdex.structureCommon.LocalVariable;
import org.ow2.asmdex.structureWriter.AnnotationItem;
import org.ow2.asmdex.structureWriter.CodeItem;
import org.ow2.asmdex.structureWriter.ConstantPool;
import org.ow2.asmdex.structureWriter.ExceptionHandler;
import org.ow2.asmdex.structureWriter.Field;
import org.ow2.asmdex.structureWriter.Method;
import org.ow2.asmdex.structureWriter.Prototype;
import org.ow2.asmdex.structureWriter.TryCatch;

public class MethodWriter
extends MethodVisitor {
    static final int MAXIMUM_SIGNED_VALUE_8_BITS = 127;
    static final int MAXIMUM_SIGNED_VALUE_16_BITS = Short.MAX_VALUE;
    static final int MINIMUM_SIGNED_VALUE_16_BITS = Short.MIN_VALUE;
    static final int MAXIMUM_SIGNED_VALUE_32_BITS = Integer.MAX_VALUE;
    private ClassWriter classWriter;
    private ConstantPool constantPool;
    private Method method;
    private ArrayList<Instruction> pseudoInstructionList = new ArrayList();
    private int nextLineNumber = 0;

    public MethodWriter(ClassWriter classWriter, int access, String name, String desc, String[] signature, String[] exceptions) {
        super(262144);
        this.classWriter = classWriter;
        this.constantPool = classWriter.getConstantPool();
        this.method = this.constantPool.addMethodToConstantPool(name, classWriter.getName(), desc, access, signature, exceptions);
        CodeItem codeItem = this.getCodeItem();
        if (codeItem != null) {
            int ias = (access & 8) > 0 ? 0 : 2;
            codeItem.setIncomingArgumentsSizeInWord((ias += Prototype.getSizeOfDescriptor(desc, true)) / 2);
        }
    }

    public ClassWriter getClassWriter() {
        return this.classWriter;
    }

    public void setStartBytecodeToCopy(int start) {
        this.method.setStartBytecodeToCopy(start);
    }

    public Method getMethod() {
        return this.method;
    }

    public CodeItem getCodeItem() {
        return this.method.getCodeItem();
    }

    public void addLabel(Label label) {
        this.getCodeItem().addLabel(label);
    }

    public void addInstruction(Instruction insn) {
        this.getCodeItem().addInstruction(insn);
        if (this.nextLineNumber > 0) {
            insn.setLineNumber(this.nextLineNumber);
            this.nextLineNumber = 0;
        }
    }

    public int addPadding() {
        CodeItem codeItem = this.getCodeItem();
        int padding = codeItem.getSize() % 4;
        if (padding != 0) {
            if (padding == 2) {
                codeItem.addInstruction(new InstructionFormat10X(0));
            } else {
                throw new RuntimeException("Padding can only be 0 or 2 ! (" + this.method.getMethodName() + " " + this.method.getClassName() + " " + codeItem.getSize() + " " + padding + ")");
            }
        }
        return padding;
    }

    @Override
    public void visitCode() {
    }

    @Override
    public void visitEnd() {
        this.closeAnnotations();
        CodeItem codeItem = this.getCodeItem();
        if (codeItem == null) {
            return;
        }
        if (codeItem.getSize() == 0) {
            this.method.free();
            return;
        }
        this.checkAndCorrectLabelReferences();
        for (Instruction insn : this.pseudoInstructionList) {
            this.addPadding();
            IPseudoInstruction ps = (IPseudoInstruction)((Object)insn);
            Label label = ps.getSourceInstruction().getLabel();
            label.setOffset(codeItem.getSize());
            this.addInstruction(insn);
        }
        this.method.generateCodeItemCode();
        this.method.free();
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, int[] arguments) {
        Method newMethod = this.constantPool.addMethodToConstantPool(name, owner, desc, 262144, null, null);
        Instruction insn = InstructionEncoder.encodeMethodInsn(opcode, newMethod, arguments);
        this.addInstruction(insn);
        CodeItem codeItem = this.getCodeItem();
        int storedOutgoingSize = codeItem.getOutgoingArgumentsSizeInWord();
        int outgoingSize = Prototype.getSizeOfDescriptor(desc, true) / 2;
        if (opcode != 113) {
            ++outgoingSize;
        }
        if (outgoingSize > storedOutgoingSize) {
            codeItem.setOutgoingArgumentsSizeInWord(outgoingSize);
        }
        Prototype prototype = this.constantPool.addPrototypeToConstantPool(desc);
        this.constantPool.addTypeListToConstantPool(prototype.getParameterTypes());
    }

    @Override
    public void visitParameters(String[] parameters) {
        if (parameters != null) {
            String[] stringArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                String parameter = stringArray[n2];
                if (!parameter.equals("")) {
                    this.constantPool.addStringToConstantPool(parameter);
                }
                ++n2;
            }
        }
        this.method.setParameters(parameters);
    }

    @Override
    public void visitVarInsn(int opcode, int destinationRegister, int var) {
        Instruction insn = InstructionEncoder.encodeVarInsn(opcode, destinationRegister, var);
        this.addInstruction(insn);
    }

    @Override
    public void visitVarInsn(int opcode, int destinationRegister, long var) {
        Instruction insn = InstructionEncoder.encodeVarInsn(opcode, destinationRegister, var);
        this.addInstruction(insn);
    }

    @Override
    public void visitInsn(int opcode) {
        this.addInstruction(InstructionEncoder.encodeInsn(opcode));
    }

    @Override
    public void visitLabel(Label label) {
        CodeItem codeItem = this.getCodeItem();
        label.setOffset(codeItem.getSize());
        this.addLabel(label);
    }

    @Override
    public void visitOperationInsn(int opcode, int destinationRegister, int firstSourceRegister, int secondSourceRegister, int value) {
        Instruction insn = InstructionEncoder.encodeOperationInsn(opcode, destinationRegister, firstSourceRegister, secondSourceRegister, value);
        this.addInstruction(insn);
    }

    @Override
    public void visitIntInsn(int opcode, int register) {
        Instruction insn = InstructionEncoder.encodeIntInsn(opcode, register);
        this.addInstruction(insn);
    }

    @Override
    public void visitJumpInsn(int opcode, Label label, int registerA, int registerB) {
        CodeItem codeItem = this.getCodeItem();
        Instruction insn = InstructionEncoder.encodeJumpInsn(opcode, label, registerA, registerB, codeItem.getSize());
        label.addReferringInstruction(insn);
        this.addInstruction(insn);
        this.addLabel(label);
    }

    @Override
    public void visitFillArrayDataInsn(int arrayReference, Object[] arrayData) {
        CodeItem codeItem = this.getCodeItem();
        Label arrayLabel = new Label();
        Instruction insn = InstructionEncoder.encodeFillArrayDataInsn(38, arrayReference, arrayLabel, codeItem.getSize());
        this.addInstruction(insn);
        PseudoInstructionFillArrayData ps = new PseudoInstructionFillArrayData(arrayData, (IOffsetInstruction)((Object)insn));
        this.pseudoInstructionList.add(ps);
    }

    @Override
    public void visitTypeInsn(int opcode, int destinationRegister, int referenceBearingRegister, int sizeRegister, String type) {
        this.constantPool.addTypeToConstantPool(type);
        Instruction insn = InstructionEncoder.encodeTypeInsn(opcode, destinationRegister, referenceBearingRegister, sizeRegister, type);
        this.addInstruction(insn);
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int[] registers) {
        this.constantPool.addTypeToConstantPool(desc);
        Instruction insn = InstructionEncoder.encodeMultiANewArrayInsn(desc, registers);
        this.addInstruction(insn);
    }

    @Override
    public void visitTableSwitchInsn(int register, int min, int max, Label dflt, Label[] labels) {
        Label switchLabel = new Label();
        CodeItem codeItem = this.getCodeItem();
        Instruction insn = InstructionEncoder.encodeTableSwitchInsn(register, switchLabel, codeItem.getSize());
        this.addInstruction(insn);
        PseudoInstructionPackedSwitch ps = new PseudoInstructionPackedSwitch(min, labels, (IOffsetInstruction)((Object)insn));
        this.pseudoInstructionList.add(ps);
    }

    @Override
    public void visitLookupSwitchInsn(int register, Label dflt, int[] keys, Label[] labels) {
        CodeItem codeItem = this.getCodeItem();
        Label switchLabel = new Label();
        Instruction insn = InstructionEncoder.encodeSparseSwitchInsn(register, switchLabel, codeItem.getSize());
        this.addInstruction(insn);
        PseudoInstructionSparseSwitch ps = new PseudoInstructionSparseSwitch(keys, labels, (IOffsetInstruction)((Object)insn));
        this.pseudoInstructionList.add(ps);
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.constantPool.addTypeToConstantPool(type);
        this.addLabel(end);
        this.addLabel(handler);
        CodeItem codeItem = this.getCodeItem();
        codeItem.addTryCatch(new TryCatch(start, end, new ExceptionHandler(handler, type)));
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationWriter annotationWriter = AnnotationWriter.createAnnotationWriter(desc, visible, this.constantPool, null);
        this.method.addAnnotationItem(annotationWriter.getAnnotationItem());
        return annotationWriter;
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        AnnotationItem annotationItem = new AnnotationItem(visible, desc);
        this.method.addParameterAnnotationItem(parameter, annotationItem);
        this.constantPool.addTypeToConstantPool(desc);
        return new AnnotationWriter(this.constantPool, annotationItem);
    }

    @Override
    public void visitArrayLengthInsn(int destinationRegister, int arrayReferenceBearing) {
        Instruction insn = InstructionEncoder.encodeArrayLength(destinationRegister, arrayReferenceBearing);
        this.addInstruction(insn);
    }

    @Override
    public void visitArrayOperationInsn(int opcode, int valueRegister, int arrayRegister, int indexRegister) {
        Instruction insn = InstructionEncoder.encodeArrayOperation(opcode, valueRegister, arrayRegister, indexRegister);
        this.addInstruction(insn);
    }

    @Override
    public void visitStringInsn(int opcode, int destinationRegister, String string) {
        this.constantPool.addStringToConstantPool(string);
        Instruction insn = InstructionEncoder.encodeStringOperation(opcode, destinationRegister, string);
        this.addInstruction(insn);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc, int valueRegister, int objectRegister) {
        Field field = this.constantPool.addFieldToConstantPool(name, desc, owner, 262144, null, null);
        Instruction insn = InstructionEncoder.encodeFieldInsn(opcode, valueRegister, objectRegister, field);
        if (insn == null) {
            throw new RuntimeException("MethodWriter.visitFieldInsn");
        }
        this.addInstruction(insn);
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        ArrayList<Label> ends = null;
        if (end != null) {
            ends = new ArrayList<Label>(1);
            ends.add(end);
        }
        this.visitLocalVariable(name, desc, signature, start, ends, null, index);
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, List<Label> ends, List<Label> restarts, int index) {
        this.constantPool.addStringToConstantPool(name);
        this.constantPool.addTypeToConstantPool(desc);
        this.constantPool.addStringToConstantPool(signature);
        LocalVariable localVariable = new LocalVariable(index, name, desc, signature, start, ends, restarts);
        this.method.addLocalVariable(localVariable);
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        this.nextLineNumber = line;
        this.method.setFirstLineNumberIfNeeded(this.nextLineNumber);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        this.method.getCodeItem().setRegisterSize(maxStack);
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        return AnnotationWriter.createAnnotationWriter("Ldalvik/annotation/AnnotationDefault;", false, this.constantPool, this.classWriter.getClassDefinitionItem());
    }

    @Override
    public void visitAttribute(Object attr) {
    }

    @Override
    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
    }

    private void checkAndCorrectLabelReferences() {
        boolean madeChange;
        CodeItem codeItem = this.getCodeItem();
        List<Label> labels = codeItem.getLabels();
        do {
            madeChange = false;
            Iterator<Label> labelIterator = labels.iterator();
            while (!madeChange && labelIterator.hasNext()) {
                Label label = labelIterator.next();
                ArrayList<Instruction> instructions = label.getReferringInstructions();
                int insnIndex = 0;
                int nbInsn = instructions.size();
                while (!madeChange && insnIndex < nbInsn) {
                    Instruction insn = instructions.get(insnIndex);
                    IOffsetInstruction offsetInsn = (IOffsetInstruction)((Object)insn);
                    int instructionOffset = offsetInsn.getInstructionOffset();
                    int relativeOffset = (label.getOffset() - instructionOffset) / 2;
                    int opcode = insn.getOpcodeByte();
                    int maximumOffset = 0;
                    switch (opcode) {
                        case 40: {
                            maximumOffset = 127;
                            break;
                        }
                        case 41: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: {
                            maximumOffset = Short.MAX_VALUE;
                            break;
                        }
                        case 42: 
                        case 43: 
                        case 44: {
                            maximumOffset = Integer.MAX_VALUE;
                            break;
                        }
                        default: {
                            try {
                                throw new Exception("Opcode error : 0x" + Integer.toHexString(opcode));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    int minimumOffset = -maximumOffset - 1;
                    if (relativeOffset < minimumOffset || relativeOffset > maximumOffset) {
                        if (opcode == 40 || opcode == 41) {
                            Instruction newInsn = relativeOffset > Short.MAX_VALUE || relativeOffset < Short.MIN_VALUE ? new InstructionFormat30T(42, label, instructionOffset) : new InstructionFormat20T(41, label, instructionOffset);
                            codeItem.replaceInstructions(insn, newInsn);
                            instructions.remove(insnIndex);
                            instructions.add(insnIndex, newInsn);
                            this.shiftOffsetInstructionsAndLabels(instructionOffset, newInsn.getSize() - insn.getSize());
                            madeChange = true;
                        } else {
                            try {
                                throw new IllegalArgumentException("Instruction Range extension unhandled. Opcode : 0x" + Integer.toHexString(opcode));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    ++insnIndex;
                }
            }
        } while (madeChange);
    }

    private void shiftOffsetInstructionsAndLabels(int shiftOffset, int shiftSize) {
        if (shiftSize != 0) {
            CodeItem codeItem = this.getCodeItem();
            List<Label> labels = codeItem.getLabels();
            for (Label label : labels) {
                int labelOffset = label.getOffset();
                if (labelOffset > shiftOffset) {
                    label.setOffset(labelOffset + shiftSize);
                }
                for (Instruction instruction : label.getReferringInstructions()) {
                    IOffsetInstruction offsetInstruction = (IOffsetInstruction)((Object)instruction);
                    int instructionOffset = offsetInstruction.getInstructionOffset();
                    if (instructionOffset <= shiftOffset) continue;
                    offsetInstruction.setInstructionOffset(instructionOffset + shiftSize);
                }
            }
        }
    }

    public void closeAnnotations() {
        this.method.closeAnnotations(this.constantPool);
    }
}

