/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex;

import org.ow2.asmdex.AnnotationVisitor;
import org.ow2.asmdex.AnnotationWriterArray;
import org.ow2.asmdex.AnnotationWriterDefaultAnnotation;
import org.ow2.asmdex.AnnotationWriterSubAnnotation;
import org.ow2.asmdex.encodedValue.EncodedValue;
import org.ow2.asmdex.encodedValue.EncodedValueArray;
import org.ow2.asmdex.encodedValue.EncodedValueEnum;
import org.ow2.asmdex.encodedValue.EncodedValueFactory;
import org.ow2.asmdex.encodedValue.EncodedValueType;
import org.ow2.asmdex.structureWriter.AnnotationElement;
import org.ow2.asmdex.structureWriter.AnnotationItem;
import org.ow2.asmdex.structureWriter.ClassDefinitionItem;
import org.ow2.asmdex.structureWriter.ConstantPool;
import org.ow2.asmdex.structureWriter.Field;

public class AnnotationWriter
extends AnnotationVisitor {
    private ConstantPool constantPool;
    protected AnnotationItem annotationItem;
    protected String currentName;
    protected String annotationType;
    protected AnnotationWriter father;
    protected EncodedValueArray unsortedArray;
    protected boolean mustSortArray = true;

    public AnnotationWriter(ConstantPool constantPool, AnnotationItem annotationItem) {
        super(262144);
        this.constantPool = constantPool;
        this.annotationItem = annotationItem;
    }

    public AnnotationItem getAnnotationItem() {
        return this.annotationItem;
    }

    public void setMustSortArray(boolean mustSortArray) {
        this.mustSortArray = mustSortArray;
        if (!mustSortArray && this.unsortedArray == null) {
            this.unsortedArray = new EncodedValueArray();
        }
    }

    @Override
    public void visit(String name, Object value) {
        this.visitManageNonDefaultAnnotation(name, value, false);
    }

    protected void visitManageNonDefaultAnnotation(String name, Object value, boolean isArrayAnnotation) {
        if (name == null) {
            name = this.currentName;
        }
        this.constantPool.addStringToConstantPool(name);
        EncodedValue encodedValue = EncodedValueFactory.getEncodedValue(value);
        if (encodedValue != null && encodedValue.getType() == 23) {
            this.constantPool.addStringToConstantPool((String)value);
            if (this.mustSortArray && isArrayAnnotation) {
                this.setMustSortArray(false);
            }
        }
        if (!this.mustSortArray && isArrayAnnotation) {
            this.unsortedArray.addEncodedValue(encodedValue);
        } else {
            AnnotationElement annotationElement = new AnnotationElement(name, encodedValue);
            this.annotationItem.addAnnotationElement(annotationElement);
        }
    }

    @Override
    public void visitEnd() {
        this.visitEndRegisterAnnotationItemNotDefaultAnnotation();
    }

    protected void visitEndRegisterAnnotationItemNotDefaultAnnotation() {
        if (this.father == null) {
            this.constantPool.addAnnotationItemToConstantPool(this.annotationItem);
        }
    }

    @Override
    public void visitEnum(String name, String desc, String value) {
        if (name == null) {
            name = this.currentName;
            this.setMustSortArray(false);
        }
        this.constantPool.addStringToConstantPool(name);
        Field field = this.constantPool.addFieldToConstantPool(value, desc, desc, 262144, null, null);
        EncodedValueEnum encodedValue = new EncodedValueEnum(field);
        if (this.mustSortArray) {
            AnnotationElement annotationElement = new AnnotationElement(name, encodedValue);
            this.annotationItem.addAnnotationElement(annotationElement);
        } else {
            this.unsortedArray.addEncodedValue(encodedValue);
        }
    }

    @Override
    public AnnotationVisitor visitArray(String name) {
        this.constantPool.addStringToConstantPool(name);
        AnnotationItem childAnnotationItem = new AnnotationItem(this.annotationItem.getVisibility(), this.annotationItem.getAnnotationType());
        AnnotationWriterArray childAnnotationWriter = new AnnotationWriterArray(this.constantPool, childAnnotationItem);
        childAnnotationWriter.father = this;
        childAnnotationWriter.currentName = name;
        childAnnotationWriter.setMustSortArray(this.mustSortArray);
        return childAnnotationWriter;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, String desc) {
        if (name == null) {
            name = this.currentName;
        }
        this.constantPool.addStringToConstantPool(name);
        this.constantPool.addTypeToConstantPool(desc);
        AnnotationItem childAnnotationItem = new AnnotationItem(this.annotationItem.getVisibility(), this.annotationItem.getAnnotationType());
        AnnotationWriterSubAnnotation childAnnotationWriter = new AnnotationWriterSubAnnotation(this.constantPool, childAnnotationItem);
        childAnnotationWriter.father = this;
        childAnnotationWriter.currentName = name;
        childAnnotationWriter.annotationType = desc;
        return childAnnotationWriter;
    }

    @Override
    public void visitClass(String annotationName, String className) {
        if (annotationName == null) {
            annotationName = this.currentName;
            this.setMustSortArray(false);
        }
        this.constantPool.addTypeToConstantPool(className);
        EncodedValueType encodedValue = new EncodedValueType(className);
        if (this.mustSortArray) {
            AnnotationElement annotationElement = new AnnotationElement(annotationName, encodedValue);
            this.annotationItem.addAnnotationElement(annotationElement);
        } else {
            this.unsortedArray.addEncodedValue(encodedValue);
        }
    }

    public static AnnotationWriter createAnnotationWriter(String desc, boolean visible, ConstantPool constantPool, ClassDefinitionItem classDefinitionItem) {
        AnnotationWriter annotationWriter;
        constantPool.addTypeToConstantPool(desc);
        int visibility = 2;
        boolean isSignature = false;
        if (desc.equals("Ldalvik/annotation/Signature;")) {
            isSignature = true;
        } else if (!desc.equals("Ldalvik/annotation/AnnotationDefault;")) {
            visibility = visible ? 1 : 0;
        }
        AnnotationItem annotationItem = new AnnotationItem(visibility, desc);
        if (classDefinitionItem != null) {
            annotationWriter = new AnnotationWriterDefaultAnnotation(constantPool, annotationItem, classDefinitionItem);
            annotationWriter.currentName = classDefinitionItem.getClassName();
        } else {
            annotationWriter = new AnnotationWriter(constantPool, annotationItem);
        }
        if (isSignature) {
            annotationWriter.setMustSortArray(false);
        }
        return annotationWriter;
    }
}

