/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asmdex;

import java.io.File;
import java.io.IOException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.objectweb.asmdex.TestUtil;
import org.ow2.asmdex.ApplicationReader;
import org.ow2.asmdex.ApplicationWriter;

public class ApplicationWriterTest {
    @AfterClass
    public static void testAfter() {
        TestUtil.removeTemporaryFolder();
    }

    @Test
    public void testApplicationWriter() {
        new ApplicationWriter();
    }

    @Test
    public void testVisit() {
        ApplicationWriter aw = new ApplicationWriter();
        aw.visit();
    }

    @Test
    public void testVisitClass() {
        ApplicationWriter aw = new ApplicationWriter();
        aw.visitClass(0, "class", null, null, null);
    }

    @Test
    public void testToByteArrayNull() {
        ApplicationWriter aw = new ApplicationWriter();
        Assert.assertNull((Object)aw.toByteArray());
    }

    @Test
    public void testGetConstantPool() {
        ApplicationWriter aw = new ApplicationWriter();
        Assert.assertNotNull((Object)aw.getConstantPool());
    }

    @Test
    public void testVisitEndAlmostEmpty() {
        ApplicationWriter aw = new ApplicationWriter();
        aw.visitEnd();
        byte[] bytes = aw.toByteArray();
        Assert.assertEquals((long)140L, (long)bytes.length);
    }

    @Test
    public void testGetApplicationReaderNull() {
        ApplicationWriter aw = new ApplicationWriter();
        Assert.assertNull((Object)aw.getApplicationReader());
    }

    @Test
    public void testGetApplicationReader() throws IOException {
        ApplicationReader ar = new ApplicationReader(262144, "test/case/full/helloWorld.dex");
        ApplicationWriter aw = new ApplicationWriter(ar);
        Assert.assertNotNull((Object)aw.getApplicationReader());
    }

    @Test
    public void testToByteArray() throws IOException {
        boolean result = this.testToByteArray(false);
        Assert.assertTrue((String)"Generated dex files aren't equal to the ones from dx.", (boolean)result);
    }

    @Test
    public void testToByteArrayOptimization() throws IOException {
        boolean result = this.testToByteArray(true);
        Assert.assertTrue((String)"Generated dex files aren't equal to the ones from dx.", (boolean)result);
    }

    private boolean testToByteArray(boolean shortCutOptimization) throws IOException {
        File testCaseFolder = new File("test/case/full/");
        boolean result = this.testGenerationToByteArray(testCaseFolder, false, shortCutOptimization);
        testCaseFolder = new File("test/case/skipLineNumbers/");
        return result &= this.testGenerationToByteArray(testCaseFolder, true, shortCutOptimization);
    }

    private boolean testGenerationToByteArray(File folder, boolean skipLineNumbers, boolean shortCutOptimization) throws IOException {
        boolean areFolderIdentical = true;
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File dexFile = fileArray[n2];
            String dexFileName = dexFile.getName();
            if (dexFileName.toLowerCase().endsWith(".dex")) {
                String fullDexFileName = String.valueOf(folder.getPath()) + "/" + dexFileName;
                TestUtil.removeTemporaryFolder();
                TestUtil.baksmali(new String[]{fullDexFileName, "-otmpAsmDexTest/expected/"});
                ApplicationReader ar = new ApplicationReader(262144, fullDexFileName);
                ApplicationWriter aw = shortCutOptimization ? new ApplicationWriter(ar) : new ApplicationWriter();
                ar.accept(aw, 0);
                byte[] generatedDexFile = aw.toByteArray();
                String fullGeneratedDexFileName = "tmpAsmDexTest/generated.dex";
                File createdDexFile = TestUtil.createFileFromByteArray(generatedDexFile, fullGeneratedDexFileName);
                Assert.assertTrue((String)("Unequal Map between " + dexFileName + " and the generated file."), (boolean)TestUtil.testMapDexFiles(createdDexFile, dexFile));
                TestUtil.baksmali(new String[]{fullGeneratedDexFileName, "-otmpAsmDexTest/generated/"});
                areFolderIdentical = TestUtil.testSmaliFoldersEquality("tmpAsmDexTest/generated/", "tmpAsmDexTest/expected/", skipLineNumbers);
                Assert.assertTrue((String)"Generated .smali files differ.", (boolean)areFolderIdentical);
                TestUtil.removeTemporaryFolder();
            }
            ++n2;
        }
        return areFolderIdentical;
    }
}

